/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Collections12 {
    public static final Map EMPTY_MAP = new EmptyMap();

    private Collections12() {
    }

    public static Map singletonMap(Object object, Object object2) {
        return new SingletonMap(object, object2);
    }

    public static List singletonList(Object object) {
        return new SingletonList(object);
    }

    private static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static final class EmptyMap
    extends AbstractMap
    implements Serializable {
        private EmptyMap() {
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean containsKey(Object object) {
            return false;
        }

        public boolean containsValue(Object object) {
            return false;
        }

        public Object get(Object object) {
            return null;
        }

        public Set keySet() {
            return Collections.EMPTY_SET;
        }

        public Collection values() {
            return Collections.EMPTY_SET;
        }

        public Set entrySet() {
            return Collections.EMPTY_SET;
        }

        public boolean equals(Object object) {
            return object instanceof Map && ((Map)object).size() == 0;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class SingletonList
    extends AbstractList
    implements Serializable {
        private final Object element;

        SingletonList(Object object) {
            this.element = object;
        }

        public int size() {
            return 1;
        }

        public boolean contains(Object object) {
            return Collections12.eq(object, this.element);
        }

        public Object get(int n) {
            if (n != 0) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: 1");
            }
            return this.element;
        }
    }

    private static class SingletonMap
    extends AbstractMap
    implements Serializable {
        private final Object k;
        private final Object v;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        SingletonMap(Object object, Object object2) {
            this.k = object;
            this.v = object2;
        }

        public int size() {
            return 1;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean containsKey(Object object) {
            return Collections12.eq(object, this.k);
        }

        public boolean containsValue(Object object) {
            return Collections12.eq(object, this.v);
        }

        public Object get(Object object) {
            return Collections12.eq(object, this.k) ? this.v : null;
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.singleton(this.k);
            }
            return this.keySet;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.singleton(new ImmutableEntry(this.k, this.v));
            }
            return this.entrySet;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        private static class ImmutableEntry
        implements Map.Entry {
            final Object k;
            final Object v;

            ImmutableEntry(Object object, Object object2) {
                this.k = object;
                this.v = object2;
            }

            public Object getKey() {
                return this.k;
            }

            public Object getValue() {
                return this.v;
            }

            public Object setValue(Object object) {
                throw new UnsupportedOperationException();
            }

            public boolean equals(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return Collections12.eq(entry.getKey(), this.k) && Collections12.eq(entry.getValue(), this.v);
            }

            public int hashCode() {
                return (this.k == null ? 0 : this.k.hashCode()) ^ (this.v == null ? 0 : this.v.hashCode());
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }
}

