/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class CaptureOutput
implements TemplateTransformModel {
    public Writer getWriter(final Writer writer, Map map) throws TemplateModelException {
        String string = "Must specify the name of the variable in which to capture the output with the 'var' or 'local' or 'global' parameter.";
        if (map == null) {
            throw new TemplateModelException(string);
        }
        boolean bl = false;
        boolean bl2 = false;
        final TemplateModel templateModel = (TemplateModel)map.get("namespace");
        Object v = map.get("var");
        if (v == null) {
            v = map.get("local");
            if (v == null) {
                v = map.get("global");
                bl2 = true;
            } else {
                bl = true;
            }
            if (v == null) {
                throw new TemplateModelException(string);
            }
        }
        if (map.size() == 2) {
            if (templateModel == null) {
                throw new TemplateModelException("Second parameter can only be namespace");
            }
            if (bl) {
                throw new TemplateModelException("Cannot specify namespace for a local assignment");
            }
            if (bl2) {
                throw new TemplateModelException("Cannot specify namespace for a global assignment");
            }
            if (!(templateModel instanceof Environment.Namespace)) {
                throw new TemplateModelException("namespace parameter does not specify a namespace. It is a " + templateModel.getClass().getName());
            }
        } else if (map.size() != 1) {
            throw new TemplateModelException("Bad parameters. Use only one of 'var' or 'local' or 'global' parameters.");
        }
        if (!(v instanceof TemplateScalarModel)) {
            throw new TemplateModelException("'var' or 'local' or 'global' parameter doesn't evaluate to a string");
        }
        final String string2 = ((TemplateScalarModel)v).getAsString();
        if (string2 == null) {
            throw new TemplateModelException("'var' or 'local' or 'global' parameter evaluates to null string");
        }
        final StringBuffer stringBuffer = new StringBuffer();
        final Environment environment = Environment.getCurrentEnvironment();
        final boolean bl3 = bl;
        final boolean bl4 = bl2;
        return new Writer(){

            public void write(char[] cArray, int n, int n2) {
                stringBuffer.append(cArray, n, n2);
            }

            public void flush() throws IOException {
                writer.flush();
            }

            public void close() throws IOException {
                SimpleScalar simpleScalar = new SimpleScalar(stringBuffer.toString());
                try {
                    if (bl3) {
                        environment.setLocalVariable(string2, simpleScalar);
                    } else if (bl4) {
                        environment.setGlobalVariable(string2, simpleScalar);
                    } else if (templateModel == null) {
                        environment.setVariable(string2, simpleScalar);
                    } else {
                        ((Environment.Namespace)templateModel).put(string2, simpleScalar);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw new IOException("Could not set variable " + string2 + ": " + illegalStateException.getMessage());
                }
            }
        };
    }
}

