/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.Environment;
import freemarker.template.TemplateException;
import java.io.PrintWriter;
import java.io.Writer;

public interface TemplateExceptionHandler {
    public static final TemplateExceptionHandler IGNORE_HANDLER = new TemplateExceptionHandler(){

        public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) {
        }
    };
    public static final TemplateExceptionHandler RETHROW_HANDLER = new TemplateExceptionHandler(){

        public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
            throw templateException;
        }
    };
    public static final TemplateExceptionHandler DEBUG_HANDLER = new TemplateExceptionHandler(){

        public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
            PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
            templateException.printStackTrace(printWriter);
            printWriter.flush();
            throw templateException;
        }
    };
    public static final TemplateExceptionHandler HTML_DEBUG_HANDLER = new TemplateExceptionHandler(){

        public void handleTemplateException(TemplateException templateException, Environment environment, Writer writer) throws TemplateException {
            PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
            printWriter.println("<!-- FREEMARKER ERROR MESSAGE STARTS HERE --><script language=javascript>//\"></script><script language=javascript>//'></script><script language=javascript>//\"></script><script language=javascript>//'></script></title></xmp></script></noscript></style></object></head></pre></table></form></table></table></table></a></u></i></b><div align=left style='background-color:#FFFF00; color:#FF0000; display:block; border-top:double; padding:2pt; font-size:medium; font-family:Arial,sans-serif; font-style: normal; font-variant: normal; font-weight: normal; text-decoration: none; text-transform: none'><b style='font-size:medium'>FreeMarker template error!</b><pre><xmp>");
            templateException.printStackTrace(printWriter);
            printWriter.println("</xmp></pre></div></html>");
            printWriter.flush();
            throw templateException;
        }
    };

    public void handleTemplateException(TemplateException var1, Environment var2, Writer var3) throws TemplateException;
}

