/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.Environment;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;

public class TemplateException
extends Exception {
    private static final boolean BEFORE_1_4 = TemplateException.before14();
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Exception causeException;
    private final Environment env;
    private final String ftlInstructionStack;
    static /* synthetic */ Class class$java$lang$Exception;

    private static boolean before14() {
        Class clazz = class$java$lang$Exception == null ? (class$java$lang$Exception = TemplateException.class$("java.lang.Exception")) : class$java$lang$Exception;
        try {
            clazz.getMethod("getCause", new Class[0]);
        }
        catch (Throwable throwable) {
            return true;
        }
        return false;
    }

    public TemplateException(Environment environment) {
        this(null, null, environment);
    }

    public TemplateException(String string, Environment environment) {
        this(string, null, environment);
    }

    public TemplateException(Exception exception, Environment environment) {
        this(null, exception, environment);
    }

    public TemplateException(String string, Exception exception, Environment environment) {
        super(TemplateException.getDescription(string, exception));
        this.causeException = exception;
        this.env = environment;
        if (environment != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            environment.outputInstructionStack(printWriter);
            printWriter.flush();
            this.ftlInstructionStack = stringWriter.toString();
        } else {
            this.ftlInstructionStack = "";
        }
    }

    private static String getDescription(String string, Exception exception) {
        if (string != null) {
            return string;
        }
        if (exception != null) {
            return exception.getClass().getName() + ": " + exception.getMessage();
        }
        return "No error message";
    }

    public Exception getCauseException() {
        return this.causeException;
    }

    public Throwable getCause() {
        return this.causeException;
    }

    public String getFTLInstructionStack() {
        return this.ftlInstructionStack;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public void printStackTrace(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(printStream), true);
        this.printStackTrace(printWriter);
        printWriter.flush();
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println(this.getMessage());
        if (this.ftlInstructionStack != null && this.ftlInstructionStack.length() != 0) {
            printWriter.println("The problematic instruction:");
            printWriter.println(this.ftlInstructionStack);
        }
        printWriter.println("Java backtrace for programmers:");
        printWriter.println("----------");
        super.printStackTrace(printWriter);
        if (BEFORE_1_4 && this.causeException != null) {
            printWriter.println("Underlying cause: ");
            this.causeException.printStackTrace(printWriter);
        }
        try {
            Method method = this.causeException.getClass().getMethod("getRootCause", EMPTY_CLASS_ARRAY);
            Throwable throwable = (Throwable)method.invoke((Object)this.causeException, EMPTY_OBJECT_ARRAY);
            if (throwable != null) {
                Throwable throwable2 = null;
                if (!BEFORE_1_4 && this.causeException != null) {
                    method = this.causeException.getClass().getMethod("getCause", EMPTY_CLASS_ARRAY);
                    throwable2 = (Throwable)method.invoke((Object)this.causeException, EMPTY_OBJECT_ARRAY);
                }
                if (throwable2 == null) {
                    printWriter.println("ServletException root cause: ");
                    throwable.printStackTrace(printWriter);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

