/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.core.FMParser;
import freemarker.core.LibraryLoad;
import freemarker.core.Macro;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.core.TextBlock;
import freemarker.core.TokenMgrError;
import freemarker.debug.impl.DebuggerService;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateNodeModel;
import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.TreePath;

public class Template
extends Configurable {
    public static final String DEFAULT_NAMESPACE_PREFIX = "D";
    public static final String NO_NS_PREFIX = "N";
    private Map macros = new HashMap();
    private List imports = new Vector();
    private TemplateElement rootElement;
    private String encoding;
    private String defaultNS;
    private final String name;
    private final ArrayList lines = new ArrayList();
    private Map prefixToNamespaceURILookup = new HashMap();
    private Map namespaceURIToPrefixLookup = new HashMap();

    private Template(String string, Configuration configuration) {
        super(configuration != null ? configuration : Configuration.getDefaultConfiguration());
        this.name = string;
    }

    public Template(String string, Reader reader, Configuration configuration, String string2) throws IOException {
        this(string, configuration);
        this.encoding = string2;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader, 4096);
        }
        LineTableBuilder lineTableBuilder = new LineTableBuilder(reader);
        try {
            FMParser fMParser = new FMParser(this, lineTableBuilder, this.getConfiguration().getStrictSyntaxMode(), this.getConfiguration().getWhitespaceStripping(), this.getConfiguration().getTagSyntax());
            this.rootElement = fMParser.Root();
        }
        catch (TokenMgrError tokenMgrError) {
            throw new ParseException("Token manager error: " + tokenMgrError, 0, 0);
        }
        finally {
            lineTableBuilder.close();
        }
        DebuggerService.registerTemplate(this);
        this.namespaceURIToPrefixLookup = Collections.unmodifiableMap(this.namespaceURIToPrefixLookup);
        this.prefixToNamespaceURILookup = Collections.unmodifiableMap(this.prefixToNamespaceURILookup);
    }

    public Template(String string, Reader reader, Configuration configuration) throws IOException {
        this(string, reader, configuration, null);
    }

    public Template(String string, Reader reader) throws IOException {
        this(string, reader, null);
    }

    Template(String string, TemplateElement templateElement, Configuration configuration) {
        this(string, configuration);
        this.rootElement = templateElement;
        DebuggerService.registerTemplate(this);
    }

    public static Template getPlainTextTemplate(String string, String string2, Configuration configuration) {
        Template template = new Template(string, configuration);
        TextBlock textBlock = new TextBlock(string2);
        template.rootElement = textBlock;
        DebuggerService.registerTemplate(template);
        return template;
    }

    public void process(Object object, Writer writer) throws TemplateException, IOException {
        this.createProcessingEnvironment(object, writer, null).process();
    }

    public void process(Object object, Writer writer, ObjectWrapper objectWrapper, TemplateNodeModel templateNodeModel) throws TemplateException, IOException {
        Environment environment = this.createProcessingEnvironment(object, writer, objectWrapper);
        if (templateNodeModel != null) {
            environment.setCurrentVisitorNode(templateNodeModel);
        }
        environment.process();
    }

    public void process(Object object, Writer writer, ObjectWrapper objectWrapper) throws TemplateException, IOException {
        this.process(object, writer, objectWrapper, null);
    }

    public Environment createProcessingEnvironment(Object object, Writer writer, ObjectWrapper objectWrapper) throws TemplateException, IOException {
        TemplateHashModel templateHashModel = null;
        if (object instanceof TemplateHashModel) {
            templateHashModel = (TemplateHashModel)object;
        } else {
            if (objectWrapper == null) {
                objectWrapper = this.getObjectWrapper();
            }
            try {
                TemplateHashModel templateHashModel2 = templateHashModel = object != null ? (TemplateHashModel)objectWrapper.wrap(object) : new SimpleHash(objectWrapper);
                if (templateHashModel == null) {
                    throw new IllegalArgumentException(objectWrapper.getClass().getName() + " converted " + object.getClass().getName() + " to null.");
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(objectWrapper.getClass().getName() + " could not convert " + object.getClass().getName() + " to a TemplateHashModel.");
            }
        }
        Environment environment = new Environment(this, templateHashModel, writer);
        this.getConfiguration().doAutoImports(environment);
        this.getConfiguration().doAutoIncludes(environment);
        return environment;
    }

    public Environment createProcessingEnvironment(Object object, Writer writer) throws TemplateException, IOException {
        return this.createProcessingEnvironment(object, writer, null);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.dump(stringWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        return stringWriter.toString();
    }

    public String getName() {
        return this.name;
    }

    public Configuration getConfiguration() {
        return (Configuration)this.getParent();
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void dump(PrintStream printStream) {
        printStream.print(this.rootElement.getCanonicalForm());
    }

    public void dump(Writer writer) throws IOException {
        writer.write(this.rootElement.getCanonicalForm());
    }

    public void addMacro(Macro macro) {
        this.macros.put(macro.getName(), macro);
    }

    public void addImport(LibraryLoad libraryLoad) {
        this.imports.add(libraryLoad);
    }

    public String getSource(int n, int n2, int n3, int n4) {
        int n5;
        --n;
        --n3;
        --n4;
        StringBuffer stringBuffer = new StringBuffer();
        for (n5 = --n2; n5 <= n4; ++n5) {
            if (n5 >= this.lines.size()) continue;
            stringBuffer.append(this.lines.get(n5));
        }
        n5 = this.lines.get(n4).toString().length();
        int n6 = n5 - n3 - 1;
        stringBuffer.delete(0, n);
        stringBuffer.delete(stringBuffer.length() - n6, stringBuffer.length());
        return stringBuffer.toString();
    }

    public TemplateElement getRootTreeNode() {
        return this.rootElement;
    }

    public Map getMacros() {
        return this.macros;
    }

    public List getImports() {
        return this.imports;
    }

    public void addPrefixNSMapping(String string, String string2) {
        if (string2.length() == 0) {
            throw new IllegalArgumentException("Cannot map empty string URI");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Cannot map empty string prefix");
        }
        if (string.equals(NO_NS_PREFIX)) {
            throw new IllegalArgumentException("The prefix: " + string + " cannot be registered, it is reserved for special internal use.");
        }
        if (this.prefixToNamespaceURILookup.containsKey(string)) {
            throw new IllegalArgumentException("The prefix: '" + string + "' was repeated. This is illegal.");
        }
        if (this.namespaceURIToPrefixLookup.containsKey(string2)) {
            throw new IllegalArgumentException("The namespace URI: " + string2 + " cannot be mapped to 2 different prefixes.");
        }
        if (string.equals(DEFAULT_NAMESPACE_PREFIX)) {
            this.defaultNS = string2;
        } else {
            this.prefixToNamespaceURILookup.put(string, string2);
            this.namespaceURIToPrefixLookup.put(string2, string);
        }
    }

    public String getDefaultNS() {
        return this.defaultNS;
    }

    public String getNamespaceForPrefix(String string) {
        if (string.equals("")) {
            return this.defaultNS == null ? "" : this.defaultNS;
        }
        return (String)this.prefixToNamespaceURILookup.get(string);
    }

    public String getPrefixForNamespace(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return this.defaultNS == null ? "" : NO_NS_PREFIX;
        }
        if (string.equals(this.defaultNS)) {
            return "";
        }
        return (String)this.namespaceURIToPrefixLookup.get(string);
    }

    public String getPrefixedName(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            if (this.defaultNS != null) {
                return "N:" + string;
            }
            return string;
        }
        if (string2.equals(this.defaultNS)) {
            return string;
        }
        String string3 = this.getPrefixForNamespace(string2);
        if (string3 == null) {
            return null;
        }
        return string3 + ":" + string;
    }

    public TreePath containingElements(int n, int n2) {
        ArrayList<TemplateElement> arrayList = new ArrayList<TemplateElement>();
        TemplateElement templateElement = this.rootElement;
        block0: while (templateElement.contains(n, n2)) {
            arrayList.add(templateElement);
            Enumeration enumeration = templateElement.children();
            while (enumeration.hasMoreElements()) {
                TemplateElement templateElement2 = (TemplateElement)enumeration.nextElement();
                if (!templateElement2.contains(n, n2)) continue;
                templateElement = templateElement2;
                continue block0;
            }
            break block0;
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        return new TreePath(arrayList.toArray());
    }

    private class LineTableBuilder
    extends FilterReader {
        StringBuffer lineBuf = new StringBuffer();
        int lastChar;

        LineTableBuilder(Reader reader) {
            super(reader);
        }

        public int read() throws IOException {
            int n = this.in.read();
            this.handleChar(n);
            return n;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = this.in.read(cArray, n, n2);
            for (int i = n; i < n + n3; ++i) {
                char c = cArray[i];
                this.handleChar(c);
            }
            return n3;
        }

        public void close() throws IOException {
            if (this.lineBuf.length() > 0) {
                Template.this.lines.add(this.lineBuf.toString());
                this.lineBuf.setLength(0);
            }
            super.close();
        }

        private void handleChar(int n) {
            if (n == 10 || n == 13) {
                if (this.lastChar == 13 && n == 10) {
                    int n2 = Template.this.lines.size() - 1;
                    String string = (String)Template.this.lines.get(n2);
                    Template.this.lines.set(n2, string + '\n');
                } else {
                    this.lineBuf.append((char)n);
                    Template.this.lines.add(this.lineBuf.toString());
                    this.lineBuf.setLength(0);
                }
            } else if (n == 9) {
                int n3 = 8 - this.lineBuf.length() % 8;
                for (int i = 0; i < n3; ++i) {
                    this.lineBuf.append(' ');
                }
            } else {
                this.lineBuf.append((char)n);
            }
            this.lastChar = n;
        }
    }

    public static class WrongEncodingException
    extends ParseException {
        public String specifiedEncoding;

        public WrongEncodingException(String string) {
            this.specifiedEncoding = string;
        }
    }
}

