/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.WrappingTemplateModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SimpleSequence
extends WrappingTemplateModel
implements TemplateSequenceModel,
Serializable {
    protected final List list;
    private List unwrappedList;

    public SimpleSequence() {
        this((ObjectWrapper)null);
    }

    public SimpleSequence(int n) {
        this.list = new ArrayList(n);
    }

    public SimpleSequence(Collection collection) {
        this(collection, null);
    }

    public SimpleSequence(TemplateCollectionModel templateCollectionModel) throws TemplateModelException {
        ArrayList<TemplateModel> arrayList = new ArrayList<TemplateModel>();
        TemplateModelIterator templateModelIterator = templateCollectionModel.iterator();
        while (templateModelIterator.hasNext()) {
            arrayList.add(templateModelIterator.next());
        }
        arrayList.trimToSize();
        this.list = arrayList;
    }

    public SimpleSequence(ObjectWrapper objectWrapper) {
        super(objectWrapper);
        this.list = new ArrayList();
    }

    public SimpleSequence(Collection collection, ObjectWrapper objectWrapper) {
        super(objectWrapper);
        this.list = new ArrayList(collection);
    }

    public void add(Object object) {
        this.list.add(object);
        this.unwrappedList = null;
    }

    public void add(boolean bl) {
        if (bl) {
            this.add(TemplateBooleanModel.TRUE);
        } else {
            this.add(TemplateBooleanModel.FALSE);
        }
    }

    public List toList() throws TemplateModelException {
        if (this.unwrappedList == null) {
            Class<?> clazz = this.list.getClass();
            List list = null;
            try {
                list = (List)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new TemplateModelException("Error instantiating an object of type " + clazz.getName() + "\n" + exception.getMessage());
            }
            BeansWrapper beansWrapper = BeansWrapper.getDefaultInstance();
            for (int i = 0; i < this.list.size(); ++i) {
                Object object = this.list.get(i);
                if (object instanceof TemplateModel) {
                    object = beansWrapper.unwrap((TemplateModel)object);
                }
                list.add(object);
            }
            this.unwrappedList = list;
        }
        return this.unwrappedList;
    }

    public TemplateModel get(int n) throws TemplateModelException {
        try {
            Object e = this.list.get(n);
            if (e instanceof TemplateModel) {
                return (TemplateModel)e;
            }
            TemplateModel templateModel = this.wrap(e);
            this.list.set(n, templateModel);
            return templateModel;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public int size() {
        return this.list.size();
    }

    public SimpleSequence synchronizedWrapper() {
        return new SynchronizedSequence();
    }

    public String toString() {
        return this.list.toString();
    }

    private class SynchronizedSequence
    extends SimpleSequence {
        private SynchronizedSequence() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Object object) {
            SimpleSequence simpleSequence = SimpleSequence.this;
            synchronized (simpleSequence) {
                SimpleSequence.this.add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemplateModel get(int n) throws TemplateModelException {
            SimpleSequence simpleSequence = SimpleSequence.this;
            synchronized (simpleSequence) {
                return SimpleSequence.this.get(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            SimpleSequence simpleSequence = SimpleSequence.this;
            synchronized (simpleSequence) {
                return SimpleSequence.this.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List toList() throws TemplateModelException {
            SimpleSequence simpleSequence = SimpleSequence.this;
            synchronized (simpleSequence) {
                return SimpleSequence.this.toList();
            }
        }
    }
}

