/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.WrappingTemplateModel;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SimpleHash
extends WrappingTemplateModel
implements TemplateHashModelEx,
Serializable {
    private Map map;
    private boolean putFailed;
    private Map unwrappedMap;

    public SimpleHash() {
        this((ObjectWrapper)null);
    }

    public SimpleHash(Map map) {
        this(map, null);
    }

    public SimpleHash(ObjectWrapper objectWrapper) {
        super(objectWrapper);
        this.map = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleHash(Map map, ObjectWrapper objectWrapper) {
        super(objectWrapper);
        try {
            this.map = this.copyMap(map);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Map map2 = map;
            synchronized (map2) {
                this.map = this.copyMap(map);
            }
        }
    }

    protected Map copyMap(Map map) {
        if (map instanceof HashMap) {
            return (Map)((HashMap)map).clone();
        }
        if (map instanceof SortedMap) {
            if (map instanceof TreeMap) {
                return (Map)((TreeMap)map).clone();
            }
            return new TreeMap((SortedMap)map);
        }
        return new HashMap(map);
    }

    public void put(String string, Object object) {
        this.map.put(string, object);
        this.unwrappedMap = null;
    }

    public void put(String string, boolean bl) {
        this.put(string, bl ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE);
    }

    public TemplateModel get(String string) throws TemplateModelException {
        Object v = this.map.get(string);
        if (v == null && string.length() == 1) {
            try {
                v = this.map.get(new Character(string.charAt(0)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (v instanceof TemplateModel) {
            return (TemplateModel)v;
        }
        TemplateModel templateModel = this.wrap(v);
        if (!this.putFailed) {
            try {
                this.map.put(string, templateModel);
            }
            catch (Exception exception) {
                this.putFailed = true;
            }
        }
        return templateModel;
    }

    public void remove(String string) {
        this.map.remove(string);
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put((String)entry.getKey(), entry.getValue());
        }
    }

    public Map toMap() throws TemplateModelException {
        if (this.unwrappedMap == null) {
            Class<?> clazz = this.map.getClass();
            Map map = null;
            try {
                map = (Map)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new TemplateModelException("Error instantiating map of type " + clazz.getName() + "\n" + exception.getMessage());
            }
            BeansWrapper beansWrapper = BeansWrapper.getDefaultInstance();
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object object = entry.getValue();
                if (object instanceof TemplateModel) {
                    object = beansWrapper.unwrap((TemplateModel)object);
                }
                map.put(k, object);
            }
            this.unwrappedMap = map;
        }
        return this.unwrappedMap;
    }

    public String toString() {
        return this.map.toString();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public TemplateCollectionModel keys() {
        return new SimpleCollection(this.map.keySet(), this.getObjectWrapper());
    }

    public TemplateCollectionModel values() {
        return new SimpleCollection(this.map.values(), this.getObjectWrapper());
    }

    public SimpleHash synchronizedWrapper() {
        return new SynchronizedHash();
    }

    private class SynchronizedHash
    extends SimpleHash {
        private SynchronizedHash() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(String string, Object object) {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                SimpleHash.this.put(string, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemplateModel get(String string) throws TemplateModelException {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.get(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(String string) {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                SimpleHash.this.remove(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemplateCollectionModel keys() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.keys();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemplateCollectionModel values() {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map toMap() throws TemplateModelException {
            SimpleHash simpleHash = SimpleHash.this;
            synchronized (simpleHash) {
                return SimpleHash.this.toMap();
            }
        }
    }
}

