/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.WrappingTemplateModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class SimpleCollection
extends WrappingTemplateModel
implements TemplateCollectionModel,
Serializable {
    private boolean iteratorDirty;
    private Iterator iterator;
    private Collection collection;

    public SimpleCollection(Iterator iterator) {
        this.iterator = iterator;
    }

    public SimpleCollection(Collection collection) {
        this.collection = collection;
    }

    public SimpleCollection(Iterator iterator, ObjectWrapper objectWrapper) {
        super(objectWrapper);
        this.iterator = iterator;
    }

    public SimpleCollection(Collection collection, ObjectWrapper objectWrapper) {
        super(objectWrapper);
        this.collection = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateModelIterator iterator() {
        if (this.iterator != null) {
            return new SimpleTemplateModelIterator(this.iterator, true);
        }
        Collection collection = this.collection;
        synchronized (collection) {
            return new SimpleTemplateModelIterator(this.collection.iterator(), false);
        }
    }

    private class SimpleTemplateModelIterator
    implements TemplateModelIterator {
        private Iterator iterator;
        private boolean iteratorShared;

        SimpleTemplateModelIterator(Iterator iterator, boolean bl) {
            this.iterator = iterator;
            this.iteratorShared = bl;
        }

        public TemplateModel next() throws TemplateModelException {
            if (this.iteratorShared) {
                this.makeIteratorDirty();
            }
            if (!this.iterator.hasNext()) {
                throw new TemplateModelException("The collection has no more elements.");
            }
            Object e = this.iterator.next();
            if (e instanceof TemplateModel) {
                return (TemplateModel)e;
            }
            return SimpleCollection.this.wrap(e);
        }

        public boolean hasNext() throws TemplateModelException {
            if (this.iteratorShared) {
                this.makeIteratorDirty();
            }
            return this.iterator.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeIteratorDirty() throws TemplateModelException {
            SimpleCollection simpleCollection = SimpleCollection.this;
            synchronized (simpleCollection) {
                if (SimpleCollection.this.iteratorDirty) {
                    throw new TemplateModelException("This collection variable wraps a java.util.Iterator, thus it can be <list>-ed or <foreach>-ed only once");
                }
                SimpleCollection.this.iteratorDirty = true;
                this.iteratorShared = false;
            }
        }
    }
}

