/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.ParseException;
import freemarker.template.utility.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;

class SettingStringParser {
    private String text;
    private int p;
    private int ln;

    SettingStringParser(String string) {
        this.text = string;
        this.p = 0;
        this.ln = string.length();
    }

    ArrayList parseAsList() throws ParseException {
        char c;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((c = this.skipWS()) != ' ') {
            arrayList.add(this.fetchStringValue());
            c = this.skipWS();
            if (c == ' ') break;
            if (c != ',') {
                throw new ParseException("Expected \",\" or the end of text but found \"" + c + "\"", 0, 0);
            }
            ++this.p;
        }
        return arrayList;
    }

    HashMap parseAsImportList() throws ParseException {
        char c;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while ((c = this.skipWS()) != ' ') {
            String string = this.fetchStringValue();
            c = this.skipWS();
            if (c == ' ') {
                throw new ParseException("Unexpected end of text: expected \"as\"", 0, 0);
            }
            String string2 = this.fetchKeyword();
            if (!string2.equalsIgnoreCase("as")) {
                throw new ParseException("Expected \"as\", but found " + StringUtil.jQuote(string2), 0, 0);
            }
            c = this.skipWS();
            if (c == ' ') {
                throw new ParseException("Unexpected end of text: expected gate hash name", 0, 0);
            }
            String string3 = this.fetchStringValue();
            hashMap.put(string3, string);
            c = this.skipWS();
            if (c == ' ') break;
            if (c != ',') {
                throw new ParseException("Expected \",\" or the end of text but found \"" + c + "\"", 0, 0);
            }
            ++this.p;
        }
        return hashMap;
    }

    String fetchStringValue() throws ParseException {
        String string = this.fetchWord();
        if (string.startsWith("'") || string.startsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return StringUtil.FTLStringLiteralDec(string);
    }

    String fetchKeyword() throws ParseException {
        String string = this.fetchWord();
        if (string.startsWith("'") || string.startsWith("\"")) {
            throw new ParseException("Keyword expected, but a string value found: " + string, 0, 0);
        }
        return string;
    }

    char skipWS() {
        while (this.p < this.ln) {
            char c = this.text.charAt(this.p);
            if (!Character.isWhitespace(c)) {
                return c;
            }
            ++this.p;
        }
        return ' ';
    }

    private String fetchWord() throws ParseException {
        if (this.p == this.ln) {
            throw new ParseException("Unexpeced end of text", 0, 0);
        }
        char c = this.text.charAt(this.p);
        int n = this.p;
        if (c == '\'' || c == '\"') {
            boolean bl = false;
            char c2 = c;
            ++this.p;
            while (this.p < this.ln) {
                c = this.text.charAt(this.p);
                if (!bl) {
                    if (c == '\\') {
                        bl = true;
                    } else if (c == c2) {
                        break;
                    }
                } else {
                    bl = false;
                }
                ++this.p;
            }
            if (this.p == this.ln) {
                throw new ParseException("Missing " + c2, 0, 0);
            }
            ++this.p;
            return this.text.substring(n, this.p);
        }
        while (Character.isLetterOrDigit(c = this.text.charAt(this.p)) || c == '/' || c == '\\' || c == '_' || c == '.' || c == '-' || c == '!' || c == '*' || c == '?') {
            ++this.p;
            if (this.p < this.ln) continue;
        }
        if (n == this.p) {
            throw new ParseException("Unexpected character: " + c, 0, 0);
        }
        return this.text.substring(n, this.p);
    }
}

