/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.dom.NodeModel;
import freemarker.ext.jython.JythonWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;

public class DefaultObjectWrapper
extends BeansWrapper {
    static final DefaultObjectWrapper instance = new DefaultObjectWrapper();
    private static Class W3C_DOM_NODE_CLASS;
    private static Class JYTHON_OBJ_CLASS;
    private static ObjectWrapper JYTHON_WRAPPER;

    public TemplateModel wrap(Object object) throws TemplateModelException {
        if (object == null) {
            return super.wrap(null);
        }
        if (object instanceof TemplateModel) {
            return (TemplateModel)object;
        }
        if (object instanceof String) {
            return new SimpleScalar((String)object);
        }
        if (object instanceof Number) {
            return new SimpleNumber((Number)object);
        }
        if (object instanceof java.util.Date) {
            if (object instanceof Date) {
                return new SimpleDate((Date)object);
            }
            if (object instanceof Time) {
                return new SimpleDate((Time)object);
            }
            if (object instanceof Timestamp) {
                return new SimpleDate((Timestamp)object);
            }
            return new SimpleDate((java.util.Date)object, this.getDefaultDateType());
        }
        if (object.getClass().isArray()) {
            object = this.convertArray(object);
        }
        if (object instanceof Collection) {
            return new SimpleSequence((Collection)object, this);
        }
        if (object instanceof Map) {
            return new SimpleHash((Map)object, this);
        }
        if (object instanceof Boolean) {
            return object.equals(Boolean.TRUE) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
        if (object instanceof Iterator) {
            return new SimpleCollection((Iterator)object, (ObjectWrapper)this);
        }
        return this.handleUnknownType(object);
    }

    protected TemplateModel handleUnknownType(Object object) throws TemplateModelException {
        if (W3C_DOM_NODE_CLASS != null && W3C_DOM_NODE_CLASS.isInstance(object)) {
            return this.wrapDomNode(object);
        }
        if (JYTHON_WRAPPER != null && JYTHON_OBJ_CLASS.isInstance(object)) {
            return JYTHON_WRAPPER.wrap(object);
        }
        return super.wrap(object);
    }

    public TemplateModel wrapDomNode(Object object) {
        return NodeModel.wrap((Node)object);
    }

    protected Object convertArray(Object object) {
        int n = Array.getLength(object);
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(Array.get(object, i));
        }
        return arrayList;
    }

    static {
        try {
            W3C_DOM_NODE_CLASS = Class.forName("org.w3c.dom.Node");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JYTHON_OBJ_CLASS = Class.forName("org.python.core.PyObject");
            JYTHON_WRAPPER = JythonWrapper.INSTANCE;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

