/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.TemplateCache;
import freemarker.cache.TemplateLoader;
import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.template.SettingStringParser;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.CaptureOutput;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.HtmlEscape;
import freemarker.template.utility.NormalizeNewlines;
import freemarker.template.utility.SecurityUtilities;
import freemarker.template.utility.StandardCompress;
import freemarker.template.utility.StringUtil;
import freemarker.template.utility.XmlEscape;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class Configuration
extends Configurable
implements Cloneable {
    public static final String DEFAULT_ENCODING_KEY = "default_encoding";
    public static final String LOCALIZED_LOOKUP_KEY = "localized_lookup";
    public static final String STRICT_SYNTAX_KEY = "strict_syntax";
    public static final String WHITESPACE_STRIPPING_KEY = "whitespace_stripping";
    public static final String CACHE_STORAGE_KEY = "cache_storage";
    public static final String TEMPLATE_UPDATE_DELAY_KEY = "template_update_delay";
    public static final String AUTO_IMPORT_KEY = "auto_import";
    public static final String AUTO_INCLUDE_KEY = "auto_include";
    public static final String TAG_SYNTAX_KEY = "tag_syntax";
    public static final int AUTO_DETECT_TAG_SYNTAX = 0;
    public static final int ANGLE_BRACKET_TAG_SYNTAX = 1;
    public static final int SQUARE_BRACKET_TAG_SYNTAX = 2;
    private static Configuration defaultConfig = new Configuration();
    private static String cachedVersion;
    private boolean strictSyntax = true;
    private boolean localizedLookup = true;
    private boolean whitespaceStripping = true;
    private int tagSyntax = 1;
    private TemplateCache cache;
    private HashMap variables = new HashMap();
    private HashMap encodingMap = new HashMap();
    private Map autoImportMap = new HashMap();
    private ArrayList autoImports = new ArrayList();
    private ArrayList autoIncludes = new ArrayList();
    private String defaultEncoding = SecurityUtilities.getSystemProperty("file.encoding");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$freemarker$template$Configuration;

    public Configuration() {
        this.cache = new TemplateCache();
        this.cache.setConfiguration(this);
        this.cache.setDelay(5000L);
        this.loadBuiltInSharedVariables();
    }

    public Object clone() {
        try {
            Configuration configuration = (Configuration)super.clone();
            configuration.variables = new HashMap(this.variables);
            configuration.encodingMap = new HashMap(this.encodingMap);
            configuration.createTemplateCache(this.cache.getTemplateLoader(), this.cache.getCacheStorage());
            return configuration;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Clone is not supported, but it should be: " + cloneNotSupportedException.getMessage());
        }
    }

    private void loadBuiltInSharedVariables() {
        this.variables.put("capture_output", new CaptureOutput());
        this.variables.put("compress", StandardCompress.INSTANCE);
        this.variables.put("html_escape", new HtmlEscape());
        this.variables.put("normalize_newlines", new NormalizeNewlines());
        this.variables.put("xml_escape", new XmlEscape());
    }

    public void loadBuiltInEncodingMap() {
        this.encodingMap.clear();
        this.encodingMap.put("ar", "ISO-8859-6");
        this.encodingMap.put("be", "ISO-8859-5");
        this.encodingMap.put("bg", "ISO-8859-5");
        this.encodingMap.put("ca", "ISO-8859-1");
        this.encodingMap.put("cs", "ISO-8859-2");
        this.encodingMap.put("da", "ISO-8859-1");
        this.encodingMap.put("de", "ISO-8859-1");
        this.encodingMap.put("el", "ISO-8859-7");
        this.encodingMap.put("en", "ISO-8859-1");
        this.encodingMap.put("es", "ISO-8859-1");
        this.encodingMap.put("et", "ISO-8859-1");
        this.encodingMap.put("fi", "ISO-8859-1");
        this.encodingMap.put("fr", "ISO-8859-1");
        this.encodingMap.put("hr", "ISO-8859-2");
        this.encodingMap.put("hu", "ISO-8859-2");
        this.encodingMap.put("is", "ISO-8859-1");
        this.encodingMap.put("it", "ISO-8859-1");
        this.encodingMap.put("iw", "ISO-8859-8");
        this.encodingMap.put("ja", "Shift_JIS");
        this.encodingMap.put("ko", "EUC-KR");
        this.encodingMap.put("lt", "ISO-8859-2");
        this.encodingMap.put("lv", "ISO-8859-2");
        this.encodingMap.put("mk", "ISO-8859-5");
        this.encodingMap.put("nl", "ISO-8859-1");
        this.encodingMap.put("no", "ISO-8859-1");
        this.encodingMap.put("pl", "ISO-8859-2");
        this.encodingMap.put("pt", "ISO-8859-1");
        this.encodingMap.put("ro", "ISO-8859-2");
        this.encodingMap.put("ru", "ISO-8859-5");
        this.encodingMap.put("sh", "ISO-8859-5");
        this.encodingMap.put("sk", "ISO-8859-2");
        this.encodingMap.put("sl", "ISO-8859-2");
        this.encodingMap.put("sq", "ISO-8859-2");
        this.encodingMap.put("sr", "ISO-8859-5");
        this.encodingMap.put("sv", "ISO-8859-1");
        this.encodingMap.put("tr", "ISO-8859-9");
        this.encodingMap.put("uk", "ISO-8859-5");
        this.encodingMap.put("zh", "GB2312");
        this.encodingMap.put("zh_TW", "Big5");
    }

    public void clearEncodingMap() {
        this.encodingMap.clear();
    }

    public static Configuration getDefaultConfiguration() {
        return defaultConfig;
    }

    public static void setDefaultConfiguration(Configuration configuration) {
        defaultConfig = configuration;
    }

    public synchronized void setTemplateLoader(TemplateLoader templateLoader) {
        this.createTemplateCache(templateLoader, this.cache.getCacheStorage());
    }

    private void createTemplateCache(TemplateLoader templateLoader, CacheStorage cacheStorage) {
        TemplateCache templateCache = this.cache;
        this.cache = new TemplateCache(templateLoader, cacheStorage);
        this.cache.setDelay(templateCache.getDelay());
        this.cache.setConfiguration(this);
        this.cache.setLocalizedLookup(this.localizedLookup);
    }

    public TemplateLoader getTemplateLoader() {
        return this.cache.getTemplateLoader();
    }

    public synchronized void setCacheStorage(CacheStorage cacheStorage) {
        this.createTemplateCache(this.cache.getTemplateLoader(), cacheStorage);
    }

    public void setDirectoryForTemplateLoading(File file) throws IOException {
        String string;
        TemplateLoader templateLoader = this.getTemplateLoader();
        if (templateLoader instanceof FileTemplateLoader && (string = ((FileTemplateLoader)templateLoader).baseDir.getCanonicalPath()).equals(file.getCanonicalPath())) {
            return;
        }
        this.setTemplateLoader(new FileTemplateLoader(file));
    }

    public void setServletContextForTemplateLoading(Object object, String string) {
        try {
            if (string == null) {
                this.setTemplateLoader((TemplateLoader)ClassUtil.forName("freemarker.cache.WebappTemplateLoader").getConstructor(ClassUtil.forName("javax.servlet.ServletContext")).newInstance(object));
            } else {
                this.setTemplateLoader((TemplateLoader)ClassUtil.forName("freemarker.cache.WebappTemplateLoader").getConstructor(ClassUtil.forName("javax.servlet.ServletContext"), class$java$lang$String == null ? (class$java$lang$String = Configuration.class$("java.lang.String")) : class$java$lang$String).newInstance(object, string));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal FreeMarker error: " + exception);
        }
    }

    public void setClassForTemplateLoading(Class clazz, String string) {
        this.setTemplateLoader(new ClassTemplateLoader(clazz, string));
    }

    public void setTemplateUpdateDelay(int n) {
        this.cache.setDelay(1000L * (long)n);
    }

    public void setStrictSyntaxMode(boolean bl) {
        this.strictSyntax = bl;
    }

    public boolean getStrictSyntaxMode() {
        return this.strictSyntax;
    }

    public void setWhitespaceStripping(boolean bl) {
        this.whitespaceStripping = bl;
    }

    public boolean getWhitespaceStripping() {
        return this.whitespaceStripping;
    }

    public void setTagSyntax(int n) {
        if (n != 0 && n != 2 && n != 1) {
            throw new IllegalArgumentException("This can only be set to one of three settings: Configuration.AUTO_DETECT_TAG_SYNTAX, Configuration.ANGLE_BRACKET_SYNTAX, or Configuration.SQAUARE_BRACKET_SYNTAX");
        }
        this.tagSyntax = n;
    }

    public int getTagSyntax() {
        return this.tagSyntax;
    }

    public Template getTemplate(String string) throws IOException {
        Locale locale = this.getLocale();
        return this.getTemplate(string, locale, this.getEncoding(locale), true);
    }

    public Template getTemplate(String string, Locale locale) throws IOException {
        return this.getTemplate(string, locale, this.getEncoding(locale), true);
    }

    public Template getTemplate(String string, String string2) throws IOException {
        return this.getTemplate(string, this.getLocale(), string2, true);
    }

    public Template getTemplate(String string, Locale locale, String string2) throws IOException {
        return this.getTemplate(string, locale, string2, true);
    }

    public Template getTemplate(String string, Locale locale, String string2, boolean bl) throws IOException {
        Template template = this.cache.getTemplate(string, locale, string2, bl);
        if (template == null) {
            throw new FileNotFoundException("Template " + string + " not found.");
        }
        return template;
    }

    public void setDefaultEncoding(String string) {
        this.defaultEncoding = string;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getEncoding(Locale locale) {
        String string = (String)this.encodingMap.get(locale.toString());
        if (string == null) {
            Locale locale2;
            if (locale.getVariant().length() > 0 && (string = (String)this.encodingMap.get((locale2 = new Locale(locale.getLanguage(), locale.getCountry())).toString())) != null) {
                this.encodingMap.put(locale.toString(), string);
            }
            if ((string = (String)this.encodingMap.get(locale.getLanguage())) != null) {
                this.encodingMap.put(locale.toString(), string);
            }
        }
        return string != null ? string : this.defaultEncoding;
    }

    public void setEncoding(Locale locale, String string) {
        this.encodingMap.put(locale.toString(), string);
    }

    public void setSharedVariable(String string, TemplateModel templateModel) {
        this.variables.put(string, templateModel);
    }

    public Set getSharedVariableNames() {
        return new HashSet(this.variables.keySet());
    }

    public void setSharedVariable(String string, Object object) throws TemplateModelException {
        this.setSharedVariable(string, this.getObjectWrapper().wrap(object));
    }

    public void setAllSharedVariables(TemplateHashModelEx templateHashModelEx) throws TemplateModelException {
        TemplateModelIterator templateModelIterator = templateHashModelEx.keys().iterator();
        TemplateModelIterator templateModelIterator2 = templateHashModelEx.values().iterator();
        while (templateModelIterator.hasNext()) {
            this.setSharedVariable(((TemplateScalarModel)templateModelIterator.next()).getAsString(), templateModelIterator2.next());
        }
    }

    public TemplateModel getSharedVariable(String string) {
        return (TemplateModel)this.variables.get(string);
    }

    public void clearSharedVariables() {
        this.variables.clear();
        this.loadBuiltInSharedVariables();
    }

    public void clearTemplateCache() {
        this.cache.clear();
    }

    public boolean getLocalizedLookup() {
        return this.cache.getLocalizedLookup();
    }

    public void setLocalizedLookup(boolean bl) {
        this.localizedLookup = bl;
        this.cache.setLocalizedLookup(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSetting(String string, String string2) throws TemplateException {
        if ("TemplateUpdateInterval".equalsIgnoreCase(string)) {
            string = TEMPLATE_UPDATE_DELAY_KEY;
        } else if ("DefaultEncoding".equalsIgnoreCase(string)) {
            string = DEFAULT_ENCODING_KEY;
        }
        try {
            if (DEFAULT_ENCODING_KEY.equals(string)) {
                this.setDefaultEncoding(string2);
                return;
            }
            if (LOCALIZED_LOOKUP_KEY.equals(string)) {
                this.setLocalizedLookup(StringUtil.getYesNo(string2));
                return;
            }
            if (STRICT_SYNTAX_KEY.equals(string)) {
                this.setStrictSyntaxMode(StringUtil.getYesNo(string2));
                return;
            }
            if (WHITESPACE_STRIPPING_KEY.equals(string)) {
                this.setWhitespaceStripping(StringUtil.getYesNo(string2));
                return;
            }
            if (CACHE_STORAGE_KEY.equals(string)) {
                if (string2.indexOf(46) == -1) {
                    int n = 0;
                    int n2 = 0;
                    Map map = StringUtil.parseNameValuePairList(string2, String.valueOf(Integer.MAX_VALUE));
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        int n3;
                        Map.Entry entry = iterator.next();
                        String string3 = (String)entry.getKey();
                        try {
                            n3 = Integer.parseInt((String)entry.getValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw this.invalidSettingValueException(string, string2);
                        }
                        if ("soft".equalsIgnoreCase(string3)) {
                            n2 = n3;
                            continue;
                        }
                        if (!"strong".equalsIgnoreCase(string3)) throw this.invalidSettingValueException(string, string2);
                        n = n3;
                    }
                    if (n2 == 0 && n == 0) {
                        throw this.invalidSettingValueException(string, string2);
                    }
                    this.setCacheStorage(new MruCacheStorage(n, n2));
                    return;
                }
                this.setCacheStorage((CacheStorage)ClassUtil.forName(string2).newInstance());
                return;
            }
            if (TEMPLATE_UPDATE_DELAY_KEY.equals(string)) {
                this.setTemplateUpdateDelay(Integer.parseInt(string2));
                return;
            } else if (AUTO_INCLUDE_KEY.equals(string)) {
                this.setAutoIncludes(new SettingStringParser(string2).parseAsList());
                return;
            } else if (AUTO_IMPORT_KEY.equals(string)) {
                this.setAutoImports(new SettingStringParser(string2).parseAsImportList());
                return;
            } else if (TAG_SYNTAX_KEY.equals(string)) {
                if ("auto_detect".equals(string2)) {
                    this.setTagSyntax(0);
                    return;
                } else if ("angle_bracket".equals(string2)) {
                    this.setTagSyntax(1);
                    return;
                } else {
                    if (!"square_bracket".equals(string2)) throw this.invalidSettingValueException(string, string2);
                    this.setTagSyntax(2);
                }
                return;
            } else {
                super.setSetting(string, string2);
            }
            return;
        }
        catch (Exception exception) {
            throw new TemplateException("Failed to set setting " + string + " to value " + string2, exception, this.getEnvironment());
        }
    }

    public synchronized void addAutoImport(String string, String string2) {
        this.autoImports.remove(string);
        this.autoImports.add(string);
        this.autoImportMap.put(string, string2);
    }

    public synchronized void removeAutoImport(String string) {
        this.autoImports.remove(string);
        this.autoImportMap.remove(string);
    }

    public synchronized void setAutoImports(Map map) {
        this.autoImports = new ArrayList(map.keySet());
        this.autoImportMap = map instanceof HashMap ? (Map)((HashMap)map).clone() : (map instanceof SortedMap ? new TreeMap(map) : new HashMap(map));
    }

    void doAutoImports(Environment environment) throws TemplateException, IOException {
        for (int i = 0; i < this.autoImports.size(); ++i) {
            String string = (String)this.autoImports.get(i);
            String string2 = (String)this.autoImportMap.get(string);
            environment.importLib(string2, string);
        }
    }

    public synchronized void addAutoInclude(String string) {
        this.autoIncludes.remove(string);
        this.autoIncludes.add(string);
    }

    public synchronized void setAutoIncludes(List list) {
        this.autoIncludes.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof String)) {
                throw new IllegalArgumentException("List items must be String-s.");
            }
            this.autoIncludes.add(e);
        }
    }

    public synchronized void removeAutoInclude(String string) {
        this.autoIncludes.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersionNumber() {
        if (cachedVersion != null) {
            return cachedVersion;
        }
        try {
            Properties properties = new Properties();
            InputStream inputStream = (class$freemarker$template$Configuration == null ? (class$freemarker$template$Configuration = Configuration.class$("freemarker.template.Configuration")) : class$freemarker$template$Configuration).getClassLoader().getResourceAsStream("freemarker/version.properties");
            if (inputStream == null) {
                throw new RuntimeException("Version file is missing.");
            }
            try {
                properties.load(inputStream);
            }
            finally {
                inputStream.close();
            }
            String string = properties.getProperty("version");
            if (string == null) {
                throw new RuntimeException("Version file is corrupt: version key is missing.");
            }
            cachedVersion = string;
            return cachedVersion;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to load version file: " + iOException);
        }
    }

    void doAutoIncludes(Environment environment) throws TemplateException, IOException {
        for (int i = 0; i < this.autoIncludes.size(); ++i) {
            String string = (String)this.autoIncludes.get(i);
            Template template = this.getTemplate(string, environment.getLocale());
            environment.include(template);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

