/*
 * Decompiled with CFR 0.152.
 */
package freemarker.log;

import freemarker.log.LoggerFactory;
import freemarker.log.NullLoggerFactory;
import freemarker.template.utility.ClassUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class Logger {
    public static final int LIBRARY_AUTO = -1;
    public static final int LIBRARY_NONE = 0;
    public static final int LIBRARY_JAVA = 1;
    public static final int LIBRARY_AVALON = 2;
    public static final int LIBRARY_LOG4J = 3;
    private static final String[] LIBINIT = new String[]{"freemarker.log", "Null", "java.util.logging", "JDK14", "org.apache.log", "Avalon", "org.apache.log4j", "Log4J"};
    private static int logLibrary;
    private static LoggerFactory factory;
    private static String categoryPrefix;
    private static final Map loggers;
    static /* synthetic */ Class class$freemarker$log$Logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void selectLoggerLibrary(int n) throws ClassNotFoundException {
        Class clazz = class$freemarker$log$Logger == null ? (class$freemarker$log$Logger = Logger.class$("freemarker.log.Logger")) : class$freemarker$log$Logger;
        synchronized (clazz) {
            if (n < -1 || n * 2 >= LIBINIT.length) {
                throw new IllegalArgumentException();
            }
            logLibrary = n;
            factory = Logger.createFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCategoryPrefix(String string) {
        Class clazz = class$freemarker$log$Logger == null ? (class$freemarker$log$Logger = Logger.class$("freemarker.log.Logger")) : class$freemarker$log$Logger;
        synchronized (clazz) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            categoryPrefix = string;
        }
    }

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isFatalEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String string) {
        Object object;
        if (factory == null) {
            object = class$freemarker$log$Logger == null ? (class$freemarker$log$Logger = Logger.class$("freemarker.log.Logger")) : class$freemarker$log$Logger;
            synchronized (object) {
                if (factory == null) {
                    try {
                        Logger.selectLoggerLibrary(-1);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new RuntimeException(classNotFoundException.getMessage());
                    }
                }
            }
        }
        string = categoryPrefix + string;
        object = loggers;
        synchronized (object) {
            Logger logger = (Logger)loggers.get(string);
            if (logger == null) {
                logger = factory.getLogger(string);
                loggers.put(string, logger);
            }
            return logger;
        }
    }

    private static LoggerFactory createFactory() throws ClassNotFoundException {
        if (logLibrary == -1) {
            for (int i = LIBINIT.length / 2 - 1; i > 0; --i) {
                try {
                    return Logger.createFactory(i);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
            }
            System.err.println("*** WARNING: FreeMarker logging suppressed.");
            return new NullLoggerFactory();
        }
        return Logger.createFactory(logLibrary);
    }

    private static LoggerFactory createFactory(int n) throws ClassNotFoundException {
        String string = LIBINIT[n * 2];
        String string2 = LIBINIT[n * 2 + 1];
        try {
            ClassUtil.forName(string + ".Logger");
            return (LoggerFactory)Class.forName("freemarker.log." + string2 + "LoggerFactory").newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new InstantiationError(instantiationException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        categoryPrefix = "";
        loggers = new HashMap();
    }
}

