/*
 * Decompiled with CFR 0.152.
 */
package freemarker.log;

import freemarker.log.Logger;
import freemarker.log.LoggerFactory;
import java.util.logging.Level;

class JDK14LoggerFactory
implements LoggerFactory {
    JDK14LoggerFactory() {
    }

    public Logger getLogger(String string) {
        return new JDK14Logger(java.util.logging.Logger.getLogger(string));
    }

    private static class JDK14Logger
    extends Logger {
        private final java.util.logging.Logger logger;

        JDK14Logger(java.util.logging.Logger logger) {
            this.logger = logger;
        }

        public void debug(String string) {
            this.logger.log(Level.FINE, string);
        }

        public void debug(String string, Throwable throwable) {
            this.logger.log(Level.FINE, string, throwable);
        }

        public void error(String string) {
            this.logger.log(Level.SEVERE, string);
        }

        public void error(String string, Throwable throwable) {
            this.logger.log(Level.SEVERE, string, throwable);
        }

        public void info(String string) {
            this.logger.log(Level.INFO, string);
        }

        public void info(String string, Throwable throwable) {
            this.logger.log(Level.INFO, string, throwable);
        }

        public void warn(String string) {
            this.logger.log(Level.WARNING, string);
        }

        public void warn(String string, Throwable throwable) {
            this.logger.log(Level.WARNING, string, throwable);
        }

        public boolean isDebugEnabled() {
            return this.logger.isLoggable(Level.FINE);
        }

        public boolean isInfoEnabled() {
            return this.logger.isLoggable(Level.INFO);
        }

        public boolean isWarnEnabled() {
            return this.logger.isLoggable(Level.WARNING);
        }

        public boolean isErrorEnabled() {
            return this.logger.isLoggable(Level.SEVERE);
        }

        public boolean isFatalEnabled() {
            return this.logger.isLoggable(Level.SEVERE);
        }
    }
}

