/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.xml;

import freemarker.ext.xml.Namespaces;
import freemarker.ext.xml.Navigator;
import freemarker.ext.xml.NodeOperator;
import freemarker.log.Logger;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.Collections12;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class NodeListModel
implements TemplateHashModel,
TemplateMethodModel,
TemplateScalarModel,
TemplateSequenceModel,
TemplateNodeModel {
    private static final Logger logger = Logger.getLogger("freemarker.xml");
    private static final Class DOM_NODE_CLASS = NodeListModel.getClass("org.w3c.dom.Node");
    private static final Class DOM4J_NODE_CLASS = NodeListModel.getClass("org.dom4j.Node");
    private static final Navigator DOM_NAVIGATOR = NodeListModel.getNavigator("Dom");
    private static final Navigator DOM4J_NAVIGATOR = NodeListModel.getNavigator("Dom4j");
    private static final Navigator JDOM_NAVIGATOR = NodeListModel.getNavigator("Jdom");
    private static final Namespaces.Factory NS_FACTORY = NodeListModel.getNamespacesFactory();
    private final Navigator navigator;
    private final List nodes;
    private Namespaces namespaces;

    public NodeListModel(Object object) {
        Object object2 = object;
        if (object instanceof Collection) {
            this.nodes = new ArrayList((Collection)object);
            object2 = this.nodes.isEmpty() ? null : this.nodes.get(0);
        } else if (object != null) {
            this.nodes = Collections12.singletonList(object);
        } else {
            throw new IllegalArgumentException("nodes == null");
        }
        this.navigator = DOM_NODE_CLASS != null && DOM_NODE_CLASS.isInstance(object2) ? DOM_NAVIGATOR : (DOM4J_NODE_CLASS != null && DOM4J_NODE_CLASS.isInstance(object2) ? DOM4J_NAVIGATOR : JDOM_NAVIGATOR);
        this.namespaces = NS_FACTORY.create();
    }

    private NodeListModel(Navigator navigator, List list, Namespaces namespaces) {
        this.navigator = navigator;
        this.nodes = list;
        this.namespaces = namespaces;
    }

    private NodeListModel deriveModel(List list) {
        this.namespaces.markShared();
        return new NodeListModel(this.navigator, list, this.namespaces);
    }

    public int size() {
        return this.nodes.size();
    }

    public Object exec(List list) throws TemplateModelException {
        if (list.size() != 1) {
            throw new TemplateModelException("Expecting exactly one argument - an XPath expression");
        }
        return this.deriveModel(this.navigator.applyXPath(this.nodes, (String)list.get(0), this.namespaces));
    }

    public String getAsString() throws TemplateModelException {
        StringWriter stringWriter = new StringWriter(this.size() * 128);
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String) {
                stringWriter.write((String)e);
                continue;
            }
            this.navigator.getAsString(e, stringWriter);
        }
        return stringWriter.toString();
    }

    public TemplateModel get(int n) {
        return this.deriveModel(Collections12.singletonList(this.nodes.get(n)));
    }

    public TemplateModel get(String string) throws TemplateModelException {
        Object object;
        NodeOperator nodeOperator = this.navigator.getOperator(string);
        String string2 = null;
        String string3 = "";
        if (nodeOperator == null && string.length() > 0 && string.charAt(0) == '_') {
            if (string.equals("_unique")) {
                return this.deriveModel(NodeListModel.removeDuplicates(this.nodes));
            }
            if (string.equals("_filterType") || string.equals("_ftype")) {
                return new FilterByType();
            }
            if (string.equals("_registerNamespace") && this.namespaces.isShared()) {
                this.namespaces = (Namespaces)this.namespaces.clone();
            }
        }
        if (nodeOperator == null) {
            int n = string.indexOf(58);
            if (n == -1) {
                string2 = string;
            } else {
                string2 = string.substring(n + 1);
                object = string.substring(0, n);
                string3 = this.namespaces.translateNamespacePrefixToUri((String)object);
                if (string3 == null) {
                    throw new TemplateModelException("Namespace prefix " + (String)object + " is not registered.");
                }
            }
            if (string2.charAt(0) == '@') {
                nodeOperator = this.navigator.getAttributeOperator();
                string2 = string2.substring(1);
            } else {
                nodeOperator = this.navigator.getChildrenOperator();
            }
        }
        ArrayList arrayList = new ArrayList();
        object = this.nodes.iterator();
        while (object.hasNext()) {
            try {
                nodeOperator.process(object.next(), string2, string3, arrayList);
            }
            catch (RuntimeException runtimeException) {
                throw new TemplateModelException(runtimeException);
            }
        }
        return this.deriveModel(arrayList);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public void registerNamespace(String string, String string2) {
        if (this.namespaces.isShared()) {
            this.namespaces = (Namespaces)this.namespaces.clone();
        }
        this.namespaces.registerNamespace(string, string2);
    }

    private static final List removeDuplicates(List list) {
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        HashSet hashSet = new HashSet(n * 4 / 3, 0.75f);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!hashSet.add(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    private static Class getClass(String string) {
        try {
            return ClassUtil.forName(string);
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug("Couldn't load class " + string, exception);
            }
            return null;
        }
    }

    private static Namespaces.Factory getNamespacesFactory() {
        Namespaces.Factory factory = NodeListModel.getNamespacesFactory("JaxenNamespaces");
        if (factory == null) {
            factory = NodeListModel.getNamespacesFactory("Namespaces");
        }
        return factory;
    }

    private static Namespaces.Factory getNamespacesFactory(String string) {
        try {
            return (Namespaces.Factory)ClassUtil.forName("freemarker.ext.xml." + string).getDeclaredField("FACTORY").get(null);
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not load " + string, throwable);
            }
            return null;
        }
    }

    private static Navigator getNavigator(String string) {
        try {
            Navigator navigator = (Navigator)ClassUtil.forName("freemarker.ext.xml." + string + "Navigator").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return navigator;
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not load navigator for " + string, throwable);
            }
            return null;
        }
    }

    public TemplateSequenceModel getChildNodes() throws TemplateModelException {
        return (TemplateSequenceModel)this.get("_content");
    }

    public String getNodeName() throws TemplateModelException {
        return this.getUniqueText((NodeListModel)this.get("_name"), "name");
    }

    public String getNodeNamespace() throws TemplateModelException {
        return this.getUniqueText((NodeListModel)this.get("_nsuri"), "namespace");
    }

    public String getNodeType() throws TemplateModelException {
        return this.getUniqueText((NodeListModel)this.get("_type"), "type");
    }

    public TemplateNodeModel getParentNode() throws TemplateModelException {
        return (TemplateNodeModel)this.get("_parent");
    }

    private String getUniqueText(NodeListModel nodeListModel, String string) throws TemplateModelException {
        String string2 = null;
        HashSet<String> hashSet = null;
        Iterator iterator = nodeListModel.nodes.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string3 == null) continue;
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            if (string2.equals(string3)) continue;
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashSet.add(string2);
            }
            hashSet.add(string3);
        }
        if (hashSet == null) {
            return string2;
        }
        throw new TemplateModelException("Value for node " + string + " is ambiguos: " + hashSet);
    }

    private class FilterByType
    implements TemplateMethodModel {
        private FilterByType() {
        }

        public Object exec(List list) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!list.contains(NodeListModel.this.navigator.getType(e))) continue;
                arrayList.add(e);
            }
            return NodeListModel.this.deriveModel(arrayList);
        }
    }
}

