/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.xml;

import freemarker.ext.xml.NodeOperator;
import freemarker.template.TemplateModelException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jaxen.NamespaceContext;

abstract class Navigator {
    private final Map xpathCache = new WeakHashMap();
    private final Map operators = this.createOperatorMap();
    private final NodeOperator attributeOperator = this.getOperator("_attributes");
    private final NodeOperator childrenOperator = this.getOperator("_children");

    Navigator() {
    }

    NodeOperator getOperator(String string) {
        return (NodeOperator)this.operators.get(string);
    }

    NodeOperator getAttributeOperator() {
        return this.attributeOperator;
    }

    NodeOperator getChildrenOperator() {
        return this.childrenOperator;
    }

    abstract void getAsString(Object var1, StringWriter var2) throws TemplateModelException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List applyXPath(List list, String string, Object object) throws TemplateModelException {
        XPathEx xPathEx = null;
        try {
            Map map = this.xpathCache;
            synchronized (map) {
                xPathEx = (XPathEx)this.xpathCache.get(string);
                if (xPathEx == null) {
                    xPathEx = this.createXPathEx(string);
                    this.xpathCache.put(string, xPathEx);
                }
            }
            return xPathEx.selectNodes(list, (NamespaceContext)object);
        }
        catch (Exception exception) {
            throw new TemplateModelException("Could not evaulate XPath expression " + string, exception);
        }
    }

    abstract XPathEx createXPathEx(String var1) throws TemplateModelException;

    abstract void getChildren(Object var1, String var2, String var3, List var4);

    abstract void getAttributes(Object var1, String var2, String var3, List var4);

    abstract void getDescendants(Object var1, List var2);

    abstract Object getParent(Object var1);

    abstract Object getDocument(Object var1);

    abstract Object getDocumentType(Object var1);

    private void getAncestors(Object object, List list) {
        Object object2;
        while ((object2 = this.getParent(object)) != null) {
            list.add(object2);
            object = object2;
        }
    }

    abstract void getContent(Object var1, List var2);

    abstract String getText(Object var1);

    abstract String getLocalName(Object var1);

    abstract String getNamespacePrefix(Object var1);

    String getQualifiedName(Object object) {
        String string = this.getLocalName(object);
        if (string == null) {
            return null;
        }
        String string2 = this.getNamespacePrefix(object);
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string2 + ":" + string;
    }

    abstract String getType(Object var1);

    abstract String getNamespaceUri(Object var1);

    boolean equal(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    private Map createOperatorMap() {
        HashMap<String, NodeOperator> hashMap = new HashMap<String, NodeOperator>();
        hashMap.put("_attributes", new AttributesOp());
        hashMap.put("@*", (NodeOperator)hashMap.get("_attributes"));
        hashMap.put("_children", new ChildrenOp());
        hashMap.put("*", (NodeOperator)hashMap.get("_children"));
        hashMap.put("_descendantOrSelf", new DescendantOrSelfOp());
        hashMap.put("_descendant", new DescendantOp());
        hashMap.put("_document", new DocumentOp());
        hashMap.put("_doctype", new DocumentTypeOp());
        hashMap.put("_ancestor", new AncestorOp());
        hashMap.put("_ancestorOrSelf", new AncestorOrSelfOp());
        hashMap.put("_content", new ContentOp());
        hashMap.put("_name", new LocalNameOp());
        hashMap.put("_nsprefix", new NamespacePrefixOp());
        hashMap.put("_nsuri", new NamespaceUriOp());
        hashMap.put("_parent", new ParentOp());
        hashMap.put("_qname", new QualifiedNameOp());
        hashMap.put("_text", new TextOp());
        hashMap.put("_type", new TypeOp());
        return hashMap;
    }

    private class AncestorOp
    implements NodeOperator {
        private AncestorOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            Navigator.this.getAncestors(object, list);
        }
    }

    private class AncestorOrSelfOp
    implements NodeOperator {
        private AncestorOrSelfOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            list.add(object);
            Navigator.this.getAncestors(object, list);
        }
    }

    private class AttributesOp
    implements NodeOperator {
        private AttributesOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            Navigator.this.getAttributes(object, string, string2, list);
        }
    }

    private class ChildrenOp
    implements NodeOperator {
        private ChildrenOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            Navigator.this.getChildren(object, string, string2, list);
        }
    }

    private class ContentOp
    implements NodeOperator {
        private ContentOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            Navigator.this.getContent(object, list);
        }
    }

    private class DescendantOp
    implements NodeOperator {
        private DescendantOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            Navigator.this.getDescendants(object, list);
        }
    }

    private class DescendantOrSelfOp
    implements NodeOperator {
        private DescendantOrSelfOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            list.add(object);
            Navigator.this.getDescendants(object, list);
        }
    }

    private class DocumentOp
    implements NodeOperator {
        private DocumentOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            Object object2 = Navigator.this.getDocument(object);
            if (object2 != null) {
                list.add(object2);
            }
        }
    }

    private class DocumentTypeOp
    implements NodeOperator {
        private DocumentTypeOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            Object object2 = Navigator.this.getDocumentType(object);
            if (object2 != null) {
                list.add(object2);
            }
        }
    }

    private class LocalNameOp
    implements NodeOperator {
        private LocalNameOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            String string3 = Navigator.this.getLocalName(object);
            if (string3 != null) {
                list.add(string3);
            }
        }
    }

    private class NamespacePrefixOp
    implements NodeOperator {
        private NamespacePrefixOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            String string3 = Navigator.this.getNamespacePrefix(object);
            if (string3 != null) {
                list.add(string3);
            }
        }
    }

    private class NamespaceUriOp
    implements NodeOperator {
        private NamespaceUriOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            String string3 = Navigator.this.getNamespaceUri(object);
            if (string3 != null) {
                list.add(string3);
            }
        }
    }

    private class ParentOp
    implements NodeOperator {
        private ParentOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            Object object2 = Navigator.this.getParent(object);
            if (object2 != null) {
                list.add(object2);
            }
        }
    }

    private class QualifiedNameOp
    implements NodeOperator {
        private QualifiedNameOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            String string3 = Navigator.this.getQualifiedName(object);
            if (string3 != null) {
                list.add(string3);
            }
        }
    }

    private class TextOp
    implements NodeOperator {
        private TextOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            String string3 = Navigator.this.getText(object);
            if (string3 != null) {
                list.add(string3);
            }
        }
    }

    private class TypeOp
    implements NodeOperator {
        private TypeOp() {
        }

        public void process(Object object, String string, String string2, List list) {
            list.add(Navigator.this.getType(object));
        }
    }

    static interface XPathEx {
        public List selectNodes(Object var1, NamespaceContext var2) throws TemplateModelException;
    }
}

