/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.xml;

import freemarker.ext.xml.Navigator;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.NamespaceContext;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.output.XMLOutputter;

class JdomNavigator
extends Navigator {
    private static final XMLOutputter OUTPUT = new XMLOutputter();

    JdomNavigator() {
    }

    void getAsString(Object object, StringWriter stringWriter) throws TemplateModelException {
        block11: {
            try {
                if (object instanceof Element) {
                    OUTPUT.output((Element)object, (Writer)stringWriter);
                    break block11;
                }
                if (object instanceof Attribute) {
                    Attribute attribute = (Attribute)object;
                    stringWriter.write(" ");
                    stringWriter.write(attribute.getQualifiedName());
                    stringWriter.write("=\"");
                    stringWriter.write(OUTPUT.escapeAttributeEntities(attribute.getValue()));
                    stringWriter.write("\"");
                    break block11;
                }
                if (object instanceof Text) {
                    OUTPUT.output((Text)object, (Writer)stringWriter);
                    break block11;
                }
                if (object instanceof Document) {
                    OUTPUT.output((Document)object, (Writer)stringWriter);
                    break block11;
                }
                if (object instanceof ProcessingInstruction) {
                    OUTPUT.output((ProcessingInstruction)object, (Writer)stringWriter);
                    break block11;
                }
                if (object instanceof Comment) {
                    OUTPUT.output((Comment)object, (Writer)stringWriter);
                    break block11;
                }
                if (object instanceof CDATA) {
                    OUTPUT.output((CDATA)object, (Writer)stringWriter);
                    break block11;
                }
                if (object instanceof DocType) {
                    OUTPUT.output((DocType)object, (Writer)stringWriter);
                    break block11;
                }
                if (object instanceof EntityRef) {
                    OUTPUT.output((EntityRef)object, (Writer)stringWriter);
                    break block11;
                }
                throw new TemplateModelException(object.getClass().getName() + " is not a core JDOM class");
            }
            catch (IOException iOException) {
                throw new TemplateModelException(iOException);
            }
        }
    }

    void getChildren(Object object, String string, String string2, List list) {
        if (object instanceof Element) {
            Element element = (Element)object;
            if (string == null) {
                list.addAll(element.getChildren());
            } else {
                list.addAll(element.getChildren(string, Namespace.getNamespace((String)"", (String)string2)));
            }
        } else if (object instanceof Document) {
            Element element = ((Document)object).getRootElement();
            if (string == null || this.equal(element.getName(), string) && this.equal(element.getNamespaceURI(), string2)) {
                list.add(element);
            }
        }
    }

    void getAttributes(Object object, String string, String string2, List list) {
        if (object instanceof Element) {
            Element element = (Element)object;
            if (string == null) {
                list.addAll(element.getAttributes());
            } else {
                Attribute attribute = element.getAttribute(string, Namespace.getNamespace((String)"", (String)string2));
                if (attribute != null) {
                    list.add(attribute);
                }
            }
        } else if (object instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
            if ("target".equals(string)) {
                list.add(new Attribute("target", processingInstruction.getTarget()));
            } else if ("data".equals(string)) {
                list.add(new Attribute("data", processingInstruction.getData()));
            } else {
                list.add(new Attribute(string, processingInstruction.getValue(string)));
            }
        } else if (object instanceof DocType) {
            DocType docType = (DocType)object;
            if ("publicId".equals(string)) {
                list.add(new Attribute("publicId", docType.getPublicID()));
            } else if ("systemId".equals(string)) {
                list.add(new Attribute("systemId", docType.getSystemID()));
            } else if ("elementName".equals(string)) {
                list.add(new Attribute("elementName", docType.getElementName()));
            }
        }
    }

    void getDescendants(Object object, List list) {
        if (object instanceof Document) {
            Element element = ((Document)object).getRootElement();
            list.add(element);
            this.getDescendants(element, list);
        } else if (object instanceof Element) {
            this.getDescendants((Element)object, list);
        }
    }

    private void getDescendants(Element element, List list) {
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            list.add(element2);
            this.getDescendants(element2, list);
        }
    }

    Object getParent(Object object) {
        if (object instanceof Element) {
            return ((Element)object).getParent();
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getParent();
        }
        if (object instanceof Text) {
            return ((Text)object).getParent();
        }
        if (object instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)object).getParent();
        }
        if (object instanceof Comment) {
            return ((Comment)object).getParent();
        }
        if (object instanceof EntityRef) {
            return ((EntityRef)object).getParent();
        }
        return null;
    }

    Object getDocument(Object object) {
        if (object instanceof Element) {
            return ((Element)object).getDocument();
        }
        if (object instanceof Attribute) {
            Element element = ((Attribute)object).getParent();
            return element == null ? null : element.getDocument();
        }
        if (object instanceof Text) {
            Element element = ((Text)object).getParent();
            return element == null ? null : element.getDocument();
        }
        if (object instanceof Document) {
            return (Document)object;
        }
        if (object instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)object).getDocument();
        }
        if (object instanceof EntityRef) {
            return ((EntityRef)object).getDocument();
        }
        if (object instanceof Comment) {
            return ((Comment)object).getDocument();
        }
        return null;
    }

    Object getDocumentType(Object object) {
        return object instanceof Document ? ((Document)object).getDocType() : null;
    }

    void getContent(Object object, List list) {
        if (object instanceof Element) {
            list.addAll(((Element)object).getContent());
        } else if (object instanceof Document) {
            list.addAll(((Document)object).getContent());
        }
    }

    String getText(Object object) {
        if (object instanceof Element) {
            return ((Element)object).getTextTrim();
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getValue();
        }
        if (object instanceof CDATA) {
            return ((CDATA)object).getText();
        }
        if (object instanceof Comment) {
            return ((Comment)object).getText();
        }
        if (object instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)object).getData();
        }
        return null;
    }

    String getLocalName(Object object) {
        if (object instanceof Element) {
            return ((Element)object).getName();
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getName();
        }
        if (object instanceof EntityRef) {
            return ((EntityRef)object).getName();
        }
        if (object instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)object).getTarget();
        }
        if (object instanceof DocType) {
            return ((DocType)object).getElementName();
        }
        return null;
    }

    String getNamespacePrefix(Object object) {
        if (object instanceof Element) {
            return ((Element)object).getNamespacePrefix();
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getNamespacePrefix();
        }
        return null;
    }

    String getNamespaceUri(Object object) {
        if (object instanceof Element) {
            return ((Element)object).getNamespaceURI();
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getNamespaceURI();
        }
        return null;
    }

    String getType(Object object) {
        if (object instanceof Attribute) {
            return "attribute";
        }
        if (object instanceof CDATA) {
            return "cdata";
        }
        if (object instanceof Comment) {
            return "comment";
        }
        if (object instanceof Document) {
            return "document";
        }
        if (object instanceof DocType) {
            return "documentType";
        }
        if (object instanceof Element) {
            return "element";
        }
        if (object instanceof EntityRef) {
            return "entityReference";
        }
        if (object instanceof Namespace) {
            return "namespace";
        }
        if (object instanceof ProcessingInstruction) {
            return "processingInstruction";
        }
        if (object instanceof Text) {
            return "text";
        }
        return "unknown";
    }

    Navigator.XPathEx createXPathEx(String string) throws TemplateModelException {
        try {
            return new JDOMXPathEx(string);
        }
        catch (Exception exception) {
            throw new TemplateModelException(exception);
        }
    }

    private static final class JDOMXPathEx
    extends JDOMXPath
    implements Navigator.XPathEx {
        JDOMXPathEx(String string) throws Exception {
            super(string);
        }

        public List selectNodes(Object object, NamespaceContext namespaceContext) throws TemplateModelException {
            Context context = this.getContext(object);
            context.getContextSupport().setNamespaceContext(namespaceContext);
            try {
                return this.selectNodesForContext(context);
            }
            catch (Exception exception) {
                throw new TemplateModelException(exception);
            }
        }
    }
}

