/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.xml;

import freemarker.ext.xml.Navigator;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.StringUtil;
import java.io.StringWriter;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.NamespaceContext;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class DomNavigator
extends Navigator {
    DomNavigator() {
    }

    void getAsString(Object object, StringWriter stringWriter) {
        this.outputContent((Node)object, stringWriter.getBuffer());
    }

    private void outputContent(Node node, StringBuffer stringBuffer) {
        switch (node.getNodeType()) {
            case 2: {
                stringBuffer.append(' ').append(this.getQualifiedName(node)).append("=\"").append(StringUtil.XMLEncNA(node.getNodeValue())).append('\"');
                break;
            }
            case 4: {
                stringBuffer.append("<![CDATA[").append(node.getNodeValue()).append("]]>");
                break;
            }
            case 8: {
                stringBuffer.append("<!--").append(node.getNodeValue()).append("-->");
                break;
            }
            case 9: {
                this.outputContent(node.getChildNodes(), stringBuffer);
                break;
            }
            case 10: {
                stringBuffer.append("<!DOCTYPE ").append(node.getNodeName());
                DocumentType documentType = (DocumentType)node;
                if (documentType.getPublicId() != null) {
                    stringBuffer.append(" PUBLIC \"").append(documentType.getPublicId()).append('\"');
                }
                if (documentType.getSystemId() != null) {
                    stringBuffer.append('\"').append(documentType.getSystemId()).append('\"');
                }
                if (documentType.getInternalSubset() != null) {
                    stringBuffer.append(" [").append(documentType.getInternalSubset()).append(']');
                }
                stringBuffer.append('>');
                break;
            }
            case 1: {
                stringBuffer.append('<').append(this.getQualifiedName(node));
                this.outputContent(node.getAttributes(), stringBuffer);
                stringBuffer.append('>');
                this.outputContent(node.getChildNodes(), stringBuffer);
                stringBuffer.append("</").append(this.getQualifiedName(node)).append('>');
                break;
            }
            case 6: {
                this.outputContent(node.getChildNodes(), stringBuffer);
                break;
            }
            case 5: {
                stringBuffer.append('&').append(node.getNodeName()).append(';');
                break;
            }
            case 7: {
                stringBuffer.append("<?").append(node.getNodeName()).append(' ').append(node.getNodeValue()).append("?>");
                break;
            }
            case 3: {
                stringBuffer.append(StringUtil.XMLEncNQG(node.getNodeValue()));
            }
        }
    }

    private void outputContent(NodeList nodeList, StringBuffer stringBuffer) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.outputContent(nodeList.item(i), stringBuffer);
        }
    }

    private void outputContent(NamedNodeMap namedNodeMap, StringBuffer stringBuffer) {
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            this.outputContent(namedNodeMap.item(i), stringBuffer);
        }
    }

    void getChildren(Object object, String string, String string2, List list) {
        if ("".equals(string2)) {
            string2 = null;
        }
        NodeList nodeList = ((Node)object).getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 && node.getNodeType() != 3 || string != null && (!this.equal(node.getNodeName(), string) || !this.equal(node.getNamespaceURI(), string2))) continue;
            list.add(node);
        }
    }

    void getAttributes(Object object, String string, String string2, List list) {
        if (object instanceof Element) {
            Element element = (Element)object;
            if (string == null) {
                NamedNodeMap namedNodeMap = element.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    list.add(namedNodeMap.item(i));
                }
            } else {
                Attr attr;
                if ("".equals(string2)) {
                    string2 = null;
                }
                if ((attr = element.getAttributeNodeNS(string2, string)) != null) {
                    list.add(attr);
                }
            }
        } else if (object instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
            if ("target".equals(string)) {
                list.add(this.createAttribute(processingInstruction, "target", processingInstruction.getTarget()));
            } else if ("data".equals(string)) {
                list.add(this.createAttribute(processingInstruction, "data", processingInstruction.getData()));
            }
        } else if (object instanceof DocumentType) {
            DocumentType documentType = (DocumentType)object;
            if ("publicId".equals(string)) {
                list.add(this.createAttribute(documentType, "publicId", documentType.getPublicId()));
            } else if ("systemId".equals(string)) {
                list.add(this.createAttribute(documentType, "systemId", documentType.getSystemId()));
            } else if ("elementName".equals(string)) {
                list.add(this.createAttribute(documentType, "elementName", documentType.getNodeName()));
            }
        }
    }

    private Attr createAttribute(Node node, String string, String string2) {
        Attr attr = node.getOwnerDocument().createAttribute(string);
        attr.setNodeValue(string2);
        return attr;
    }

    void getDescendants(Object object, List list) {
        NodeList nodeList = ((Node)object).getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            list.add(node);
            this.getDescendants(node, list);
        }
    }

    Object getParent(Object object) {
        return ((Node)object).getParentNode();
    }

    Object getDocument(Object object) {
        return ((Node)object).getOwnerDocument();
    }

    Object getDocumentType(Object object) {
        return object instanceof Document ? ((Document)object).getDoctype() : null;
    }

    void getContent(Object object, List list) {
        NodeList nodeList = ((Node)object).getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            list.add(nodeList.item(i));
        }
    }

    String getText(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Element) {
            NodeList nodeList = ((Node)object).getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Text)) continue;
                stringBuffer.append(node.getNodeValue());
            }
            return stringBuffer.toString();
        }
        return ((Node)object).getNodeValue();
    }

    String getLocalName(Object object) {
        return ((Node)object).getNodeName();
    }

    String getNamespacePrefix(Object object) {
        return ((Node)object).getPrefix();
    }

    String getNamespaceUri(Object object) {
        return ((Node)object).getNamespaceURI();
    }

    String getType(Object object) {
        switch (((Node)object).getNodeType()) {
            case 2: {
                return "attribute";
            }
            case 4: {
                return "cdata";
            }
            case 8: {
                return "comment";
            }
            case 9: {
                return "document";
            }
            case 10: {
                return "documentType";
            }
            case 1: {
                return "element";
            }
            case 6: {
                return "entity";
            }
            case 5: {
                return "entityReference";
            }
            case 7: {
                return "processingInstruction";
            }
            case 3: {
                return "text";
            }
        }
        return "unknown";
    }

    Navigator.XPathEx createXPathEx(String string) throws TemplateModelException {
        try {
            return new DomXPathEx(string);
        }
        catch (Exception exception) {
            throw new TemplateModelException(exception);
        }
    }

    private static final class DomXPathEx
    extends DOMXPath
    implements Navigator.XPathEx {
        DomXPathEx(String string) throws Exception {
            super(string);
        }

        public List selectNodes(Object object, NamespaceContext namespaceContext) throws TemplateModelException {
            Context context = this.getContext(object);
            context.getContextSupport().setNamespaceContext(namespaceContext);
            try {
                return this.selectNodesForContext(context);
            }
            catch (Exception exception) {
                throw new TemplateModelException(exception);
            }
        }
    }
}

