/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.xml;

import freemarker.ext.xml.Navigator;
import freemarker.template.TemplateModelException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.tree.DefaultAttribute;
import org.jaxen.Context;
import org.jaxen.NamespaceContext;
import org.jaxen.dom4j.Dom4jXPath;

class Dom4jNavigator
extends Navigator {
    Dom4jNavigator() {
    }

    void getAsString(Object object, StringWriter stringWriter) {
        stringWriter.getBuffer().append(((Node)object).asXML());
    }

    void getChildren(Object object, String string, String string2, List list) {
        if (object instanceof Element) {
            Element element = (Element)object;
            if (string == null) {
                list.addAll(element.elements());
            } else {
                list.addAll(element.elements(element.getQName().getDocumentFactory().createQName(string, "", string2)));
            }
        } else if (object instanceof Document) {
            Element element = ((Document)object).getRootElement();
            if (string == null || this.equal(element.getName(), string) && this.equal(element.getNamespaceURI(), string2)) {
                list.add(element);
            }
        }
    }

    void getAttributes(Object object, String string, String string2, List list) {
        if (object instanceof Element) {
            Element element = (Element)object;
            if (string == null) {
                list.addAll(element.attributes());
            } else {
                Attribute attribute = element.attribute(element.getQName().getDocumentFactory().createQName(string, "", string2));
                if (attribute != null) {
                    list.add(attribute);
                }
            }
        } else if (object instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
            if ("target".equals(string)) {
                list.add(new DefaultAttribute("target", processingInstruction.getTarget()));
            } else if ("data".equals(string)) {
                list.add(new DefaultAttribute("data", processingInstruction.getText()));
            } else {
                list.add(new DefaultAttribute(string, processingInstruction.getValue(string)));
            }
        } else if (object instanceof DocumentType) {
            DocumentType documentType = (DocumentType)object;
            if ("publicId".equals(string)) {
                list.add(new DefaultAttribute("publicId", documentType.getPublicID()));
            } else if ("systemId".equals(string)) {
                list.add(new DefaultAttribute("systemId", documentType.getSystemID()));
            } else if ("elementName".equals(string)) {
                list.add(new DefaultAttribute("elementName", documentType.getElementName()));
            }
        }
    }

    void getDescendants(Object object, List list) {
        if (object instanceof Branch) {
            this.getDescendants((Branch)object, list);
        }
    }

    private void getDescendants(Branch branch, List list) {
        List list2 = branch.content();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof Element)) continue;
            list.add(node);
            this.getDescendants(node, list);
        }
    }

    Object getParent(Object object) {
        return ((Node)object).getParent();
    }

    Object getDocument(Object object) {
        return ((Node)object).getDocument();
    }

    Object getDocumentType(Object object) {
        return object instanceof Document ? ((Document)object).getDocType() : null;
    }

    void getContent(Object object, List list) {
        if (object instanceof Branch) {
            list.addAll(((Branch)object).content());
        }
    }

    String getText(Object object) {
        return ((Node)object).getText();
    }

    String getLocalName(Object object) {
        return ((Node)object).getName();
    }

    String getNamespacePrefix(Object object) {
        if (object instanceof Element) {
            return ((Element)object).getNamespacePrefix();
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getNamespacePrefix();
        }
        return null;
    }

    String getNamespaceUri(Object object) {
        if (object instanceof Element) {
            return ((Element)object).getNamespaceURI();
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getNamespaceURI();
        }
        return null;
    }

    String getType(Object object) {
        switch (((Node)object).getNodeType()) {
            case 2: {
                return "attribute";
            }
            case 4: {
                return "cdata";
            }
            case 8: {
                return "comment";
            }
            case 9: {
                return "document";
            }
            case 10: {
                return "documentType";
            }
            case 1: {
                return "element";
            }
            case 5: {
                return "entityReference";
            }
            case 13: {
                return "namespace";
            }
            case 7: {
                return "processingInstruction";
            }
            case 3: {
                return "text";
            }
        }
        return "unknown";
    }

    Navigator.XPathEx createXPathEx(String string) throws TemplateModelException {
        try {
            return new Dom4jXPathEx(string);
        }
        catch (Exception exception) {
            throw new TemplateModelException(exception);
        }
    }

    private static final class Dom4jXPathEx
    extends Dom4jXPath
    implements Navigator.XPathEx {
        Dom4jXPathEx(String string) throws Exception {
            super(string);
        }

        public List selectNodes(Object object, NamespaceContext namespaceContext) throws TemplateModelException {
            Context context = this.getContext(object);
            context.getContextSupport().setNamespaceContext(namespaceContext);
            try {
                return this.selectNodesForContext(context);
            }
            catch (Exception exception) {
                throw new TemplateModelException(exception);
            }
        }
    }
}

