/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.util;

import freemarker.ext.util.IdentityHashMap;
import freemarker.ext.util.ModelFactory;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateModel;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;

public class ModelCache {
    private boolean useCache = false;
    private Map modelCache = null;
    private ReferenceQueue refQueue = null;
    private final ObjectWrapper wrapper;

    public ModelCache(ObjectWrapper objectWrapper) {
        this.wrapper = objectWrapper;
    }

    public synchronized void setUseCache(boolean bl) {
        this.useCache = bl;
        if (bl) {
            this.modelCache = new IdentityHashMap();
            this.refQueue = new ReferenceQueue();
        } else {
            this.modelCache = null;
            this.refQueue = null;
        }
    }

    public TemplateModel getInstance(Object object, ModelFactory modelFactory) {
        if (this.useCache) {
            TemplateModel templateModel = this.lookup(object);
            if (templateModel == null) {
                templateModel = modelFactory.create(object, this.wrapper);
                this.register(templateModel, object);
            }
            return templateModel;
        }
        return modelFactory.create(object, this.wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.modelCache != null) {
            Map map = this.modelCache;
            synchronized (map) {
                this.modelCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TemplateModel lookup(Object object) {
        ModelReference modelReference = null;
        Map map = this.modelCache;
        synchronized (map) {
            modelReference = (ModelReference)this.modelCache.get(object);
        }
        if (modelReference != null) {
            return modelReference.getModel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void register(TemplateModel templateModel, Object object) {
        Map map = this.modelCache;
        synchronized (map) {
            ModelReference modelReference;
            while ((modelReference = (ModelReference)this.refQueue.poll()) != null) {
                this.modelCache.remove(modelReference.object);
            }
            this.modelCache.put(object, new ModelReference(templateModel, object, this.refQueue));
        }
    }

    private static final class ModelReference
    extends SoftReference {
        Object object;

        ModelReference(TemplateModel templateModel, Object object, ReferenceQueue referenceQueue) {
            super(templateModel);
            this.object = object;
        }

        TemplateModel getModel() {
            return (TemplateModel)this.get();
        }
    }
}

