/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.servlet;

import freemarker.ext.servlet.FreemarkerServlet;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class HttpSessionHashModel
implements TemplateHashModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient HttpSession session;
    private final transient ObjectWrapper wrapper;
    private final transient FreemarkerServlet servlet;
    private final transient HttpServletRequest request;
    private final transient HttpServletResponse response;

    public HttpSessionHashModel(HttpSession httpSession, ObjectWrapper objectWrapper) {
        this.session = httpSession;
        this.wrapper = objectWrapper;
        this.servlet = null;
        this.request = null;
        this.response = null;
    }

    public HttpSessionHashModel(FreemarkerServlet freemarkerServlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ObjectWrapper objectWrapper) {
        this.wrapper = objectWrapper;
        this.servlet = freemarkerServlet;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
    }

    public TemplateModel get(String string) throws TemplateModelException {
        this.checkSessionExistence();
        return this.wrapper.wrap(this.session != null ? this.session.getAttribute(string) : null);
    }

    private void checkSessionExistence() throws TemplateModelException {
        if (this.session == null && this.request != null) {
            this.session = this.request.getSession(false);
            if (this.session != null && this.servlet != null) {
                try {
                    this.servlet.initializeSession(this.request, this.response);
                }
                catch (Exception exception) {
                    throw new TemplateModelException(exception);
                }
            }
        }
    }

    boolean isZombie() {
        return this.session == null && this.request == null;
    }

    public boolean isEmpty() throws TemplateModelException {
        this.checkSessionExistence();
        return this.session == null || !this.session.getAttributeNames().hasMoreElements();
    }
}

