/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.servlet;

import freemarker.cache.WebappTemplateLoader;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.AllHttpScopesHashModel;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FreemarkerServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger("freemarker.servlet");
    public static final long serialVersionUID = -2440216393145762479L;
    private static final String INITPARAM_TEMPLATE_PATH = "TemplatePath";
    private static final String INITPARAM_NOCACHE = "NoCache";
    private static final String INITPARAM_CONTENT_TYPE = "ContentType";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String INITPARAM_DEBUG = "Debug";
    private static final String DEPR_INITPARAM_TEMPLATE_DELAY = "TemplateDelay";
    private static final String DEPR_INITPARAM_ENCODING = "DefaultEncoding";
    private static final String DEPR_INITPARAM_OBJECT_WRAPPER = "ObjectWrapper";
    private static final String DEPR_INITPARAM_WRAPPER_SIMPLE = "simple";
    private static final String DEPR_INITPARAM_WRAPPER_BEANS = "beans";
    private static final String DEPR_INITPARAM_WRAPPER_JYTHON = "jython";
    private static final String DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER = "TemplateExceptionHandler";
    private static final String DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_RETHROW = "rethrow";
    private static final String DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_DEBUG = "debug";
    private static final String DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_HTML_DEBUG = "htmlDebug";
    private static final String DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_IGNORE = "ignore";
    private static final String DEPR_INITPARAM_DEBUG = "debug";
    public static final String KEY_REQUEST = "Request";
    public static final String KEY_REQUEST_PRIVATE = "__FreeMarkerServlet.Request__";
    public static final String KEY_REQUEST_PARAMETERS = "RequestParameters";
    public static final String KEY_SESSION = "Session";
    public static final String KEY_APPLICATION = "Application";
    public static final String KEY_APPLICATION_PRIVATE = "__FreeMarkerServlet.Application__";
    public static final String KEY_JSP_TAGLIBS = "JspTaglibs";
    private static final String ATTR_REQUEST_MODEL = ".freemarker.Request";
    private static final String ATTR_REQUEST_PARAMETERS_MODEL = ".freemarker.RequestParameters";
    private static final String ATTR_SESSION_MODEL = ".freemarker.Session";
    private static final String ATTR_APPLICATION_MODEL = ".freemarker.Application";
    private static final String ATTR_JSP_TAGLIBS_MODEL = ".freemarker.JspTaglibs";
    private static final String EXPIRATION_DATE;
    private String templatePath;
    private boolean nocache;
    protected boolean debug;
    private Configuration config;
    private ObjectWrapper wrapper;
    private String contentType;
    private boolean noCharsetInContentType;
    static /* synthetic */ Class class$java$lang$Throwable;

    public void init() throws ServletException {
        try {
            this.config = this.createConfiguration();
            this.config.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
            this.contentType = DEFAULT_CONTENT_TYPE;
            this.wrapper = this.createObjectWrapper();
            if (logger.isDebugEnabled()) {
                logger.debug("Using object wrapper of class " + this.wrapper.getClass().getName());
            }
            this.config.setObjectWrapper(this.wrapper);
            this.templatePath = this.getInitParameter(INITPARAM_TEMPLATE_PATH);
            if (this.templatePath == null) {
                this.templatePath = "class://";
            }
            if (this.templatePath.startsWith("class://")) {
                this.config.setClassForTemplateLoading(((Object)((Object)this)).getClass(), this.templatePath.substring(7));
            } else if (this.templatePath.startsWith("file://")) {
                this.templatePath = this.templatePath.substring(7);
                this.config.setDirectoryForTemplateLoading(new File(this.templatePath));
            } else {
                this.config.setTemplateLoader(new WebappTemplateLoader(this.getServletContext(), this.templatePath));
            }
            Enumeration enumeration = this.getServletConfig().getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.getInitParameter(string);
                if (string == null) {
                    throw new ServletException("init-param without param-name. Maybe the web.xml is not well-formed?");
                }
                if (string2 == null) {
                    throw new ServletException("init-param without param-value. Maybe the web.xml is not well-formed?");
                }
                if (string.equals(DEPR_INITPARAM_OBJECT_WRAPPER) || string.equals("object_wrapper") || string.equals(INITPARAM_TEMPLATE_PATH)) continue;
                if (string.equals(DEPR_INITPARAM_ENCODING)) {
                    if (this.getInitParameter("default_encoding") != null) {
                        throw new ServletException("Conflicting init-params: default_encoding and DefaultEncoding");
                    }
                    this.config.setDefaultEncoding(string2);
                    continue;
                }
                if (string.equals(DEPR_INITPARAM_TEMPLATE_DELAY)) {
                    if (this.getInitParameter("template_update_delay") != null) {
                        throw new ServletException("Conflicting init-params: template_update_delay and TemplateDelay");
                    }
                    try {
                        this.config.setTemplateUpdateDelay(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (string.equals(DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER)) {
                    if (this.getInitParameter("template_exception_handler") != null) {
                        throw new ServletException("Conflicting init-params: template_exception_handler and TemplateExceptionHandler");
                    }
                    if (DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_RETHROW.equals(string2)) {
                        this.config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
                        continue;
                    }
                    if ("debug".equals(string2)) {
                        this.config.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
                        continue;
                    }
                    if (DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_HTML_DEBUG.equals(string2)) {
                        this.config.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
                        continue;
                    }
                    if (DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_IGNORE.equals(string2)) {
                        this.config.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
                        continue;
                    }
                    throw new ServletException("Invalid value for servlet init-param TemplateExceptionHandler: " + string2);
                }
                if (string.equals(INITPARAM_NOCACHE)) {
                    this.nocache = StringUtil.getYesNo(string2);
                    continue;
                }
                if (string.equals("debug")) {
                    if (this.getInitParameter(INITPARAM_DEBUG) != null) {
                        throw new ServletException("Conflicting init-params: Debug and debug");
                    }
                    this.debug = StringUtil.getYesNo(string2);
                    continue;
                }
                if (string.equals(INITPARAM_DEBUG)) {
                    this.debug = StringUtil.getYesNo(string2);
                    continue;
                }
                if (string.equals(INITPARAM_CONTENT_TYPE)) {
                    this.contentType = string2;
                    continue;
                }
                this.config.setSetting(string, string2);
            }
            this.noCharsetInContentType = true;
            int n = this.contentType.toLowerCase().indexOf("charset=");
            if (n != -1) {
                char c = ' ';
                --n;
                while (n >= 0 && Character.isWhitespace(c = (char)this.contentType.charAt(n))) {
                    --n;
                }
                if (n == -1 || c == ';') {
                    this.noCharsetInContentType = false;
                }
            }
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.process(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.process(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block16: {
            if (this.preprocessRequest(httpServletRequest, httpServletResponse)) {
                return;
            }
            String string = this.requestUrlToTemplatePath(httpServletRequest);
            if (this.debug) {
                this.log("Requested template: " + string);
            }
            Template template = null;
            try {
                template = this.config.getTemplate(string, this.deduceLocale(string, httpServletRequest, httpServletResponse));
            }
            catch (FileNotFoundException fileNotFoundException) {
                httpServletResponse.sendError(404);
                return;
            }
            Object object = template.getCustomAttribute("content_type");
            if (object != null) {
                httpServletResponse.setContentType(object.toString());
            } else if (this.noCharsetInContentType) {
                httpServletResponse.setContentType(this.contentType + "; charset=" + template.getEncoding());
            } else {
                httpServletResponse.setContentType(this.contentType);
            }
            this.setBrowserCachingPolicy(httpServletResponse);
            ServletContext servletContext = this.getServletContext();
            try {
                TemplateModel templateModel = this.createModel(this.wrapper, servletContext, httpServletRequest, httpServletResponse);
                if (!this.preTemplateProcess(httpServletRequest, httpServletResponse, template, templateModel)) break block16;
                try {
                    template.process(templateModel, httpServletResponse.getWriter());
                }
                finally {
                    this.postTemplateProcess(httpServletRequest, httpServletResponse, template, templateModel);
                }
            }
            catch (TemplateException templateException) {
                if (this.config.getTemplateExceptionHandler().getClass().getName().indexOf(INITPARAM_DEBUG) != -1) {
                    this.log("Error executing FreeMarker template", templateException);
                }
                ServletException servletException = new ServletException("Error executing FreeMarker template", (Throwable)templateException);
                try {
                    ((Object)((Object)servletException)).getClass().getMethod("initCause", class$java$lang$Throwable == null ? (class$java$lang$Throwable = FreemarkerServlet.class$("java.lang.Throwable")) : class$java$lang$Throwable).invoke((Object)servletException, templateException);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw servletException;
            }
        }
    }

    protected Locale deduceLocale(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.config.getLocale();
    }

    protected TemplateModel createModel(ObjectWrapper objectWrapper, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws TemplateModelException {
        try {
            TemplateHashModel templateHashModel;
            AllHttpScopesHashModel allHttpScopesHashModel = new AllHttpScopesHashModel(objectWrapper, servletContext, httpServletRequest);
            ServletContextHashModel servletContextHashModel = (ServletContextHashModel)servletContext.getAttribute(ATTR_APPLICATION_MODEL);
            if (servletContextHashModel == null) {
                servletContextHashModel = new ServletContextHashModel((GenericServlet)this, objectWrapper);
                servletContext.setAttribute(ATTR_APPLICATION_MODEL, (Object)servletContextHashModel);
                templateHashModel = new TaglibFactory(servletContext);
                servletContext.setAttribute(ATTR_JSP_TAGLIBS_MODEL, (Object)templateHashModel);
                this.initializeServletContext(httpServletRequest, httpServletResponse);
            }
            allHttpScopesHashModel.putUnlistedModel(KEY_APPLICATION, servletContextHashModel);
            allHttpScopesHashModel.putUnlistedModel(KEY_APPLICATION_PRIVATE, servletContextHashModel);
            allHttpScopesHashModel.putUnlistedModel(KEY_JSP_TAGLIBS, (TemplateModel)servletContext.getAttribute(ATTR_JSP_TAGLIBS_MODEL));
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                templateHashModel = (HttpSessionHashModel)httpSession.getAttribute(ATTR_SESSION_MODEL);
                if (templateHashModel == null || ((HttpSessionHashModel)templateHashModel).isZombie()) {
                    templateHashModel = new HttpSessionHashModel(httpSession, objectWrapper);
                    httpSession.setAttribute(ATTR_SESSION_MODEL, (Object)templateHashModel);
                    if (!((HttpSessionHashModel)templateHashModel).isZombie()) {
                        this.initializeSession(httpServletRequest, httpServletResponse);
                    }
                }
            } else {
                templateHashModel = new HttpSessionHashModel(this, httpServletRequest, httpServletResponse, objectWrapper);
            }
            allHttpScopesHashModel.putUnlistedModel(KEY_SESSION, templateHashModel);
            HttpRequestHashModel httpRequestHashModel = (HttpRequestHashModel)httpServletRequest.getAttribute(ATTR_REQUEST_MODEL);
            if (httpRequestHashModel == null || httpRequestHashModel.getRequest() != httpServletRequest) {
                httpRequestHashModel = new HttpRequestHashModel(httpServletRequest, httpServletResponse, objectWrapper);
                httpServletRequest.setAttribute(ATTR_REQUEST_MODEL, (Object)httpRequestHashModel);
                httpServletRequest.setAttribute(ATTR_REQUEST_PARAMETERS_MODEL, (Object)this.createRequestParametersHashModel(httpServletRequest));
            }
            allHttpScopesHashModel.putUnlistedModel(KEY_REQUEST, httpRequestHashModel);
            allHttpScopesHashModel.putUnlistedModel(KEY_REQUEST_PRIVATE, httpRequestHashModel);
            HttpRequestParametersHashModel httpRequestParametersHashModel = (HttpRequestParametersHashModel)httpServletRequest.getAttribute(ATTR_REQUEST_PARAMETERS_MODEL);
            allHttpScopesHashModel.putUnlistedModel(KEY_REQUEST_PARAMETERS, httpRequestParametersHashModel);
            return allHttpScopesHashModel;
        }
        catch (ServletException servletException) {
            throw new TemplateModelException((Exception)((Object)servletException));
        }
        catch (IOException iOException) {
            throw new TemplateModelException(iOException);
        }
    }

    protected String requestUrlToTemplatePath(HttpServletRequest httpServletRequest) {
        String string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (string != null) {
            String string2 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            return string2 == null ? string : string2;
        }
        String string3 = httpServletRequest.getPathInfo();
        if (string3 != null) {
            return string3;
        }
        string3 = httpServletRequest.getServletPath();
        if (string3 != null) {
            return string3;
        }
        return "";
    }

    protected boolean preprocessRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        return false;
    }

    protected Configuration createConfiguration() {
        return new Configuration();
    }

    protected ObjectWrapper createObjectWrapper() {
        String string = this.getServletConfig().getInitParameter(DEPR_INITPARAM_OBJECT_WRAPPER);
        if (string != null) {
            if (this.getInitParameter("object_wrapper") != null) {
                throw new RuntimeException("Conflicting init-params: object_wrapper and ObjectWrapper");
            }
            if (DEPR_INITPARAM_WRAPPER_BEANS.equals(string)) {
                return ObjectWrapper.BEANS_WRAPPER;
            }
            if (DEPR_INITPARAM_WRAPPER_SIMPLE.equals(string)) {
                return ObjectWrapper.SIMPLE_WRAPPER;
            }
            if (DEPR_INITPARAM_WRAPPER_JYTHON.equals(string)) {
                try {
                    return (ObjectWrapper)Class.forName("freemarker.ext.jython.JythonWrapper").newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new InstantiationError(instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalAccessError(illegalAccessException.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ObjectWrapper.DEFAULT_WRAPPER;
        }
        string = this.getInitParameter("object_wrapper");
        if (string == null) {
            return ObjectWrapper.DEFAULT_WRAPPER;
        }
        try {
            this.config.setSetting("object_wrapper", string);
        }
        catch (TemplateException templateException) {
            throw new RuntimeException(templateException.toString());
        }
        return this.config.getObjectWrapper();
    }

    protected ObjectWrapper getObjectWrapper() {
        return this.wrapper;
    }

    protected final String getTemplatePath() {
        return this.templatePath;
    }

    protected HttpRequestParametersHashModel createRequestParametersHashModel(HttpServletRequest httpServletRequest) {
        return new HttpRequestParametersHashModel(httpServletRequest);
    }

    protected void initializeServletContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    protected void initializeSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    protected boolean preTemplateProcess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Template template, TemplateModel templateModel) throws ServletException, IOException {
        return true;
    }

    protected void postTemplateProcess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Template template, TemplateModel templateModel) throws ServletException, IOException {
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    private void setBrowserCachingPolicy(HttpServletResponse httpServletResponse) {
        if (this.nocache) {
            httpServletResponse.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, post-check=0, pre-check=0");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.setHeader("Expires", EXPIRATION_DATE);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.roll(1, -1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        EXPIRATION_DATE = simpleDateFormat.format(gregorianCalendar.getTime());
    }
}

