/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.servlet;

import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AllHttpScopesHashModel
extends SimpleHash {
    private final ObjectWrapper wrapper;
    private final ServletContext context;
    private final HttpServletRequest request;
    private final Map unlistedModels = new HashMap();

    AllHttpScopesHashModel(ObjectWrapper objectWrapper, ServletContext servletContext, HttpServletRequest httpServletRequest) {
        this.wrapper = objectWrapper;
        this.context = servletContext;
        this.request = httpServletRequest;
    }

    public void putUnlistedModel(String string, TemplateModel templateModel) {
        this.unlistedModels.put(string, templateModel);
    }

    public TemplateModel get(String string) throws TemplateModelException {
        TemplateModel templateModel = super.get(string);
        if (templateModel != null) {
            return templateModel;
        }
        templateModel = (TemplateModel)this.unlistedModels.get(string);
        if (templateModel != null) {
            return templateModel;
        }
        Object object = this.request.getAttribute(string);
        if (object != null) {
            return this.wrapper.wrap(object);
        }
        HttpSession httpSession = this.request.getSession(false);
        if (httpSession != null && (object = httpSession.getAttribute(string)) != null) {
            return this.wrapper.wrap(object);
        }
        object = this.context.getAttribute(string);
        if (object != null) {
            return this.wrapper.wrap(object);
        }
        return this.wrapper.wrap(null);
    }
}

