/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jython;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.DateModel;
import freemarker.ext.jython.JythonHashModel;
import freemarker.ext.jython.JythonModel;
import freemarker.ext.jython.JythonNumberModel;
import freemarker.ext.jython.JythonSequenceModel;
import freemarker.ext.util.ModelCache;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelAdapter;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.OptimizerUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;

public class JythonWrapper
implements ObjectWrapper {
    private static final Class PYOBJECT_CLASS = class$org$python$core$PyObject == null ? (class$org$python$core$PyObject = JythonWrapper.class$("org.python.core.PyObject")) : class$org$python$core$PyObject;
    public static final JythonWrapper INSTANCE = new JythonWrapper();
    private final ModelCache modelCache = new ModelCache(this);
    private boolean attributesShadowItems = true;
    static /* synthetic */ Class class$org$python$core$PyObject;
    static /* synthetic */ Class class$java$lang$Object;

    public void setUseCache(boolean bl) {
        this.modelCache.setUseCache(bl);
    }

    public synchronized void setAttributesShadowItems(boolean bl) {
        this.attributesShadowItems = bl;
    }

    boolean isAttributesShadowItems() {
        return this.attributesShadowItems;
    }

    public TemplateModel wrap(Object arrayList) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList instanceof TemplateModel) {
            return (TemplateModel)((Object)arrayList);
        }
        if (arrayList instanceof TemplateModelAdapter) {
            return ((TemplateModelAdapter)((Object)arrayList)).getTemplateModel();
        }
        boolean bl = false;
        boolean bl2 = false;
        if (arrayList instanceof PyJavaInstance) {
            Object object = ((PyJavaInstance)arrayList).__tojava__(class$java$lang$Object == null ? (class$java$lang$Object = JythonWrapper.class$("java.lang.Object")) : class$java$lang$Object);
            if (object instanceof TemplateModel) {
                return (TemplateModel)object;
            }
            if (object instanceof Map) {
                bl = true;
            }
            if (object instanceof Date) {
                return new DateModel((Date)object, BeansWrapper.getDefaultInstance());
            }
            if (object instanceof Collection) {
                bl2 = true;
                if (!(object instanceof List)) {
                    arrayList = new ArrayList((Collection)object);
                }
            }
        }
        if (!(arrayList instanceof PyObject)) {
            arrayList = Py.java2py((Object)arrayList);
        }
        if (bl || arrayList instanceof PyDictionary || arrayList instanceof PyStringMap) {
            return this.modelCache.getInstance(arrayList, JythonHashModel.FACTORY);
        }
        if (bl2 || arrayList instanceof PySequence) {
            return this.modelCache.getInstance(arrayList, JythonSequenceModel.FACTORY);
        }
        if (arrayList instanceof PyInteger || arrayList instanceof PyLong || arrayList instanceof PyFloat) {
            return this.modelCache.getInstance(arrayList, JythonNumberModel.FACTORY);
        }
        if (arrayList instanceof PyNone) {
            return null;
        }
        return this.modelCache.getInstance(arrayList, JythonModel.FACTORY);
    }

    public PyObject unwrap(TemplateModel templateModel) throws TemplateModelException {
        if (templateModel instanceof AdapterTemplateModel) {
            return Py.java2py((Object)((AdapterTemplateModel)templateModel).getAdaptedObject(PYOBJECT_CLASS));
        }
        if (templateModel instanceof WrapperTemplateModel) {
            return Py.java2py((Object)((WrapperTemplateModel)templateModel).getWrappedObject());
        }
        if (templateModel instanceof TemplateScalarModel) {
            return new PyString(((TemplateScalarModel)templateModel).getAsString());
        }
        if (templateModel instanceof TemplateNumberModel) {
            Number number = ((TemplateNumberModel)templateModel).getAsNumber();
            if (number instanceof BigDecimal) {
                number = OptimizerUtil.optimizeNumberRepresentation(number);
            }
            if (number instanceof BigInteger) {
                return new PyLong((BigInteger)number);
            }
            return Py.java2py((Object)number);
        }
        return new TemplateModelToJythonAdapter(templateModel);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TemplateModelToJythonAdapter
    extends PyObject
    implements TemplateModelAdapter {
        private final TemplateModel model;

        TemplateModelToJythonAdapter(TemplateModel templateModel) {
            this.model = templateModel;
        }

        public TemplateModel getTemplateModel() {
            return this.model;
        }

        public PyObject __finditem__(PyObject pyObject) {
            if (pyObject instanceof PyInteger) {
                return this.__finditem__(((PyInteger)pyObject).getValue());
            }
            return this.__finditem__(pyObject.toString());
        }

        public PyObject __finditem__(String string) {
            if (this.model instanceof TemplateHashModel) {
                try {
                    return JythonWrapper.this.unwrap(((TemplateHashModel)this.model).get(string));
                }
                catch (TemplateModelException templateModelException) {
                    throw Py.JavaError((Throwable)templateModelException);
                }
            }
            throw Py.TypeError((String)("item lookup on non-hash model (" + this.getModelClass() + ")"));
        }

        public PyObject __finditem__(int n) {
            if (this.model instanceof TemplateSequenceModel) {
                try {
                    return JythonWrapper.this.unwrap(((TemplateSequenceModel)this.model).get(n));
                }
                catch (TemplateModelException templateModelException) {
                    throw Py.JavaError((Throwable)templateModelException);
                }
            }
            throw Py.TypeError((String)("item lookup on non-sequence model (" + this.getModelClass() + ")"));
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            if (this.model instanceof TemplateMethodModel) {
                boolean bl = this.model instanceof TemplateMethodModelEx;
                ArrayList<Object> arrayList = new ArrayList<Object>(pyObjectArray.length);
                try {
                    for (int i = 0; i < pyObjectArray.length; ++i) {
                        arrayList.add(bl ? JythonWrapper.this.wrap(pyObjectArray[i]) : (pyObjectArray[i] == null ? null : pyObjectArray[i].toString()));
                    }
                    return JythonWrapper.this.unwrap((TemplateModel)((TemplateMethodModelEx)this.model).exec(arrayList));
                }
                catch (TemplateModelException templateModelException) {
                    throw Py.JavaError((Throwable)templateModelException);
                }
            }
            throw Py.TypeError((String)("call of non-method model (" + this.getModelClass() + ")"));
        }

        public int __len__() {
            try {
                if (this.model instanceof TemplateSequenceModel) {
                    return ((TemplateSequenceModel)this.model).size();
                }
                if (this.model instanceof TemplateHashModelEx) {
                    return ((TemplateHashModelEx)this.model).size();
                }
            }
            catch (TemplateModelException templateModelException) {
                throw Py.JavaError((Throwable)templateModelException);
            }
            return 0;
        }

        public boolean __nonzero__() {
            try {
                if (this.model instanceof TemplateBooleanModel) {
                    return ((TemplateBooleanModel)this.model).getAsBoolean();
                }
                if (this.model instanceof TemplateSequenceModel) {
                    return ((TemplateSequenceModel)this.model).size() > 0;
                }
                if (this.model instanceof TemplateHashModel) {
                    return !((TemplateHashModelEx)this.model).isEmpty();
                }
            }
            catch (TemplateModelException templateModelException) {
                throw Py.JavaError((Throwable)templateModelException);
            }
            return false;
        }

        private String getModelClass() {
            return this.model == null ? "null" : this.model.getClass().getName();
        }
    }
}

