/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jython;

import freemarker.ext.jython.JythonModel;
import freemarker.ext.jython.JythonWrapper;
import freemarker.ext.util.ModelFactory;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import org.python.core.PyException;
import org.python.core.PyObject;

public class JythonHashModel
extends JythonModel
implements TemplateHashModelEx {
    private static final String KEYS = "keys";
    private static final String KEYSET = "keySet";
    private static final String VALUES = "values";
    static final ModelFactory FACTORY = new ModelFactory(){

        public TemplateModel create(Object object, ObjectWrapper objectWrapper) {
            return new JythonHashModel((PyObject)object, (JythonWrapper)objectWrapper);
        }
    };

    public JythonHashModel(PyObject pyObject, JythonWrapper jythonWrapper) {
        super(pyObject, jythonWrapper);
    }

    public int size() throws TemplateModelException {
        try {
            return this.object.__len__();
        }
        catch (PyException pyException) {
            throw new TemplateModelException((Exception)((Object)pyException));
        }
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        try {
            PyObject pyObject = this.object.__findattr__(KEYS);
            if (pyObject == null) {
                pyObject = this.object.__findattr__(KEYSET);
            }
            if (pyObject != null) {
                return (TemplateCollectionModel)this.wrapper.wrap(pyObject.__call__());
            }
        }
        catch (PyException pyException) {
            throw new TemplateModelException((Exception)((Object)pyException));
        }
        throw new TemplateModelException("'?keys' is not supported as there is no 'keys' nor 'keySet' attribute on an instance of " + this.object.__class__.__name__);
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        try {
            PyObject pyObject = this.object.__findattr__(VALUES);
            if (pyObject != null) {
                return (TemplateCollectionModel)this.wrapper.wrap(pyObject.__call__());
            }
        }
        catch (PyException pyException) {
            throw new TemplateModelException((Exception)((Object)pyException));
        }
        throw new TemplateModelException("'?values' is not supported as there is no 'values' attribute on an instance of " + this.object.__class__.__name__);
    }
}

