/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jsp;

import freemarker.core.Environment;
import freemarker.ext.jsp.EventForwarding;
import freemarker.ext.jsp.TagTransformModel;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.log.Logger;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.ClassUtil;
import java.beans.IntrospectionException;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TaglibFactory
implements TemplateHashModel {
    private static final Logger logger = Logger.getLogger("freemarker.jsp");
    private static final int LOOKUP_NONE = 0;
    private static final int LOOKUP_WEB_XML = 1;
    private static final int LOOKUP_JARS = 2;
    private final ServletContext ctx;
    private final Map taglibs = new HashMap();
    private final Map locations = new HashMap();
    private int lookupPhase = 0;
    private static final Map dtds = new HashMap();
    static /* synthetic */ Class class$freemarker$ext$jsp$EventForwarding;

    public TaglibFactory(ServletContext servletContext) {
        this.ctx = servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateModel get(String string) throws TemplateModelException {
        string = TaglibFactory.resolveRelativeUri(string);
        Map map = this.taglibs;
        synchronized (map) {
            Taglib taglib = null;
            taglib = (Taglib)this.taglibs.get(string);
            if (taglib != null) {
                return taglib;
            }
            taglib = new Taglib();
            try {
                do {
                    if (!taglib.load(string, this.ctx, this.locations)) continue;
                    this.taglibs.put(string, taglib);
                    return taglib;
                } while (this.getMoreTaglibLocations());
            }
            catch (TemplateModelException templateModelException) {
                throw templateModelException;
            }
            catch (Exception exception) {
                throw new TemplateModelException("Could not load taglib information", exception);
            }
            return null;
        }
    }

    public boolean isEmpty() {
        return false;
    }

    private boolean getMoreTaglibLocations() throws MalformedURLException, ParserConfigurationException, IOException, SAXException {
        switch (this.lookupPhase) {
            case 0: {
                this.getLocationsFromWebXml();
                this.lookupPhase = 1;
                return true;
            }
            case 1: {
                this.getLocationsFromLibJars();
                this.lookupPhase = 2;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLocationsFromWebXml() throws MalformedURLException, ParserConfigurationException, IOException, SAXException {
        WebXmlParser webXmlParser = new WebXmlParser(this.locations);
        InputStream inputStream = this.ctx.getResourceAsStream("/WEB-INF/web.xml");
        if (inputStream == null) {
            return;
        }
        try {
            TaglibFactory.parseXml(inputStream, this.ctx.getResource("/WEB-INF/web.xml").toExternalForm(), webXmlParser);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLocationsFromLibJars() throws ParserConfigurationException, IOException, SAXException {
        Set set = this.ctx.getResourcePaths("/WEB-INF/lib");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.endsWith(".jar") && !string.endsWith(".zip")) continue;
            ZipInputStream zipInputStream = new ZipInputStream(this.ctx.getResourceAsStream(string));
            FilterInputStream filterInputStream = new FilterInputStream(zipInputStream){

                public void close() {
                }
            };
            try {
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    String string2;
                    String string3;
                    String string4 = zipEntry.getName();
                    if (!string4.startsWith("META-INF/") || !string4.endsWith(".tld") || (string3 = this.getTldUri(filterInputStream, string2 = "jar:" + this.ctx.getResource(string).toExternalForm() + "!" + string4)) == null) continue;
                    this.locations.put(string3, new String[]{string, string4});
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("libjar assigned URI " + string3 + " to location " + string + "!" + string4);
                }
            }
            finally {
                zipInputStream.close();
            }
        }
    }

    private String getTldUri(InputStream inputStream, String string) throws ParserConfigurationException, IOException, SAXException {
        TldUriReader tldUriReader = new TldUriReader();
        TaglibFactory.parseXml(inputStream, string, tldUriReader);
        return tldUriReader.getUri();
    }

    private static void parseXml(InputStream inputStream, String string, DefaultHandler defaultHandler) throws ParserConfigurationException, IOException, SAXException {
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(inputStream);
        inputSource.setSystemId(string);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(false);
        sAXParserFactory.setValidating(true);
        XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
        xMLReader.setEntityResolver(new LocalTaglibDtds());
        xMLReader.setContentHandler(defaultHandler);
        xMLReader.parse(inputSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map loadTaglib(String[] stringArray, ServletContext servletContext) throws ParserConfigurationException, IOException, SAXException, TemplateModelException {
        Object object;
        if (stringArray == null) {
            return null;
        }
        String string = stringArray[0];
        TldParser tldParser = new TldParser();
        InputStream inputStream = servletContext.getResourceAsStream(string);
        if (inputStream == null) {
            throw new TemplateModelException("Could not find webapp resource " + string);
        }
        String string2 = servletContext.getResource(string).toExternalForm();
        try {
            object = stringArray[1];
            if (object != null) {
                ZipEntry zipEntry;
                String string3;
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                do {
                    if ((zipEntry = zipInputStream.getNextEntry()) != null) continue;
                    throw new TemplateModelException("Could not find JAR entry " + (String)object + " inside webapp resource " + string);
                } while (!(string3 = zipEntry.getName()).equals(object));
                TaglibFactory.parseXml(zipInputStream, "jar:" + string2 + "!" + string3, tldParser);
            } else {
                TaglibFactory.parseXml(inputStream, string2, tldParser);
            }
        }
        finally {
            inputStream.close();
        }
        object = EventForwarding.getInstance(servletContext);
        if (object != null) {
            ((EventForwarding)object).addListeners(tldParser.getListeners());
        } else if (tldParser.getListeners().size() > 0) {
            throw new TemplateModelException("Event listeners specified in the TLD could not be  registered since the web application doesn't have a listener of class " + (class$freemarker$ext$jsp$EventForwarding == null ? (class$freemarker$ext$jsp$EventForwarding = TaglibFactory.class$("freemarker.ext.jsp.EventForwarding")) : class$freemarker$ext$jsp$EventForwarding).getName() + ". To remedy this, add this element to web.xml:\n" + "| <listener>\n" + "|   <listener-class>" + (class$freemarker$ext$jsp$EventForwarding == null ? (class$freemarker$ext$jsp$EventForwarding = TaglibFactory.class$("freemarker.ext.jsp.EventForwarding")) : class$freemarker$ext$jsp$EventForwarding).getName() + "</listener-class>\n" + "| </listener>");
        }
        return tldParser.getTags();
    }

    private static final String[] getTldPath(String string, Map map) {
        String[] stringArray = (String[])map.get(string);
        if (stringArray != null) {
            return stringArray;
        }
        if (string.startsWith("/")) {
            stringArray = new String[2];
            stringArray[0] = string;
            if (string.endsWith(".jar") || string.endsWith(".zip")) {
                stringArray[1] = "META-INF/taglib.tld";
            }
            return stringArray;
        }
        return null;
    }

    private static String resolveRelativeUri(String string) throws TemplateModelException {
        if (string.startsWith("/") || string.indexOf("://") != -1) {
            return string;
        }
        TemplateModel templateModel = Environment.getCurrentEnvironment().getVariable("__FreeMarkerServlet.Request__");
        if (templateModel instanceof HttpRequestHashModel) {
            int n;
            HttpServletRequest httpServletRequest = ((HttpRequestHashModel)templateModel).getRequest();
            String string2 = httpServletRequest.getPathInfo();
            String string3 = httpServletRequest.getServletPath();
            if (string3 == null) {
                string3 = "";
            }
            if ((n = (string3 = string3 + (string2 == null ? "" : string2)).lastIndexOf(47)) != -1) {
                return string3.substring(0, n + 1) + string;
            }
            return '/' + string;
        }
        throw new TemplateModelException("Can't resolve relative URI " + string + " as request URL information is unavailable.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        dtds.put("http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd", "web-jsptaglibrary_2_0.xsd");
        dtds.put("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", "web-jsptaglibrary_1_2.dtd");
        dtds.put("http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd", "web-jsptaglibrary_1_2.dtd");
        dtds.put("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", "web-jsptaglibrary_1_1.dtd");
        dtds.put("http://java.sun.com/j2ee/dtds/web-jsptaglibrary_1_1.dtd", "web-jsptaglibrary_1_1.dtd");
        dtds.put("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", "web-app_2_4.xsd");
        dtds.put("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "web-app_2_3.dtd");
        dtds.put("http://java.sun.com/dtd/web-app_2_3.dtd", "web-app_2_3.dtd");
        dtds.put("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "web-app_2_2.dtd");
        dtds.put("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd", "web-app_2_2.dtd");
    }

    private static final class LocalTaglibDtds
    implements EntityResolver {
        private LocalTaglibDtds() {
        }

        public InputSource resolveEntity(String string, String string2) {
            String string3 = (String)dtds.get(string);
            if (string3 == null) {
                string3 = (String)dtds.get(string2);
            }
            InputStream inputStream = string3 != null ? this.getClass().getResourceAsStream(string3) : new ByteArrayInputStream(new byte[0]);
            InputSource inputSource = new InputSource();
            inputSource.setPublicId(string);
            inputSource.setSystemId(string2);
            inputSource.setByteStream(inputStream);
            return inputSource;
        }
    }

    private static final class Taglib
    implements TemplateHashModel {
        private Map tags;

        Taglib() {
        }

        public TemplateModel get(String string) {
            return (TagTransformModel)this.tags.get(string);
        }

        public boolean isEmpty() {
            return false;
        }

        boolean load(String string, ServletContext servletContext, Map map) throws ParserConfigurationException, IOException, SAXException, TemplateModelException {
            String[] stringArray = TaglibFactory.getTldPath(string, map);
            if (logger.isDebugEnabled()) {
                if (stringArray == null) {
                    logger.debug("Loading taglib " + string + " from location null");
                } else {
                    logger.debug("Loading taglib " + string + " from location " + stringArray[0] + (stringArray[1] != null ? "!" + stringArray[1] : ""));
                }
            }
            this.tags = TaglibFactory.loadTaglib(stringArray, servletContext);
            if (this.tags != null) {
                map.remove(string);
                return true;
            }
            return false;
        }
    }

    private static final class TldParser
    extends DefaultHandler {
        private final Map tags = new HashMap();
        private final List listeners = new ArrayList();
        private Locator locator;
        private StringBuffer buf;
        private String tagName;
        private String tagClass;

        private TldParser() {
        }

        Map getTags() {
            return this.tags;
        }

        List getListeners() {
            return this.listeners;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("name".equals(string3) || "tagclass".equals(string3) || "tag-class".equals(string3) || "listener-class".equals(string3)) {
                this.buf = new StringBuffer();
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.buf != null) {
                this.buf.append(cArray, n, n2);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXParseException {
            if ("name".equals(string3)) {
                if (this.tagName == null) {
                    this.tagName = this.buf.toString().trim();
                }
                this.buf = null;
            } else if ("tagclass".equals(string3) || "tag-class".equals(string3)) {
                this.tagClass = this.buf.toString().trim();
                this.buf = null;
            } else {
                if ("tag".equals(string3)) {
                    try {
                        this.tags.put(this.tagName, new TagTransformModel(ClassUtil.forName(this.tagClass)));
                        this.tagName = null;
                        this.tagClass = null;
                    }
                    catch (IntrospectionException introspectionException) {
                        throw new SAXParseException("Can't introspect tag class " + this.tagClass, this.locator, introspectionException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new SAXParseException("Can't find tag class " + this.tagClass, this.locator, classNotFoundException);
                    }
                }
                if ("listener-class".equals(string3)) {
                    String string4 = this.buf.toString().trim();
                    this.buf = null;
                    try {
                        this.listeners.add(ClassUtil.forName(string4).newInstance());
                    }
                    catch (Exception exception) {
                        throw new SAXParseException("Can't instantiate listener class " + string4, this.locator, exception);
                    }
                }
            }
        }
    }

    private static class TldUriReader
    extends DefaultHandler {
        private StringBuffer buf;
        private String uri;

        TldUriReader() {
        }

        String getUri() {
            return this.uri;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("uri".equals(string3)) {
                this.buf = new StringBuffer();
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.buf != null) {
                this.buf.append(cArray, n, n2);
            }
        }

        public void endElement(String string, String string2, String string3) {
            if ("uri".equals(string3)) {
                this.uri = this.buf.toString().trim();
                this.buf = null;
            }
        }
    }

    private static class WebXmlParser
    extends DefaultHandler {
        private final Map locations;
        private StringBuffer buf;
        private String uri;
        private String location;

        WebXmlParser(Map map) {
            this.locations = map;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("taglib-uri".equals(string3) || "taglib-location".equals(string3)) {
                this.buf = new StringBuffer();
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.buf != null) {
                this.buf.append(cArray, n, n2);
            }
        }

        public void endElement(String string, String string2, String string3) {
            if ("taglib-uri".equals(string3)) {
                this.uri = this.buf.toString().trim();
                this.buf = null;
            } else if ("taglib-location".equals(string3)) {
                this.location = this.buf.toString().trim();
                if (this.location.indexOf("://") == -1 && !this.location.startsWith("/")) {
                    this.location = "/WEB-INF/" + this.location;
                }
                this.buf = null;
            } else if ("taglib".equals(string3)) {
                String[] stringArray = new String[2];
                stringArray[0] = this.location;
                if (this.location.endsWith(".jar") || this.location.endsWith(".zip")) {
                    stringArray[1] = "META-INF/taglib.tld";
                }
                this.locations.put(this.uri, stringArray);
                if (logger.isDebugEnabled()) {
                    logger.debug("web.xml assigned URI " + this.uri + " to location " + stringArray[0] + (stringArray[1] != null ? "!" + stringArray[1] : ""));
                }
            }
        }
    }
}

