/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jsp;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.jsp.FreeMarkerPageContext;
import freemarker.ext.jsp.PageContextFactory;
import freemarker.log.Logger;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateTransformModel;
import freemarker.template.TransformControl;
import freemarker.template.utility.SecurityUtilities;
import freemarker.template.utility.StringUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TryCatchFinally;

class TagTransformModel
implements TemplateTransformModel {
    private static final char[] NEWLINE = SecurityUtilities.getSystemProperty("line.separator").toCharArray();
    private static final Logger logger = Logger.getLogger("freemarker.servlet");
    private final Class tagClass;
    private final Method dynaSetter;
    private final Map propertySetters = new HashMap();
    private final boolean isBodyTag;
    private final boolean isIterationTag;
    private final boolean isTryCatchFinally;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$Tag;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$IterationTag;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$BodyTag;
    static /* synthetic */ Class class$javax$servlet$jsp$tagext$TryCatchFinally;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public TagTransformModel(Class clazz) throws IntrospectionException {
        Method method;
        if (!(class$javax$servlet$jsp$tagext$Tag == null ? (class$javax$servlet$jsp$tagext$Tag = TagTransformModel.class$("javax.servlet.jsp.tagext.Tag")) : class$javax$servlet$jsp$tagext$Tag).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " does not implement the " + (class$javax$servlet$jsp$tagext$Tag == null ? (class$javax$servlet$jsp$tagext$Tag = TagTransformModel.class$("javax.servlet.jsp.tagext.Tag")) : class$javax$servlet$jsp$tagext$Tag).getName() + " interface.");
        }
        this.isIterationTag = (class$javax$servlet$jsp$tagext$IterationTag == null ? (class$javax$servlet$jsp$tagext$IterationTag = TagTransformModel.class$("javax.servlet.jsp.tagext.IterationTag")) : class$javax$servlet$jsp$tagext$IterationTag).isAssignableFrom(clazz);
        this.isBodyTag = this.isIterationTag && (class$javax$servlet$jsp$tagext$BodyTag == null ? (class$javax$servlet$jsp$tagext$BodyTag = TagTransformModel.class$("javax.servlet.jsp.tagext.BodyTag")) : class$javax$servlet$jsp$tagext$BodyTag).isAssignableFrom(clazz);
        this.isTryCatchFinally = (class$javax$servlet$jsp$tagext$TryCatchFinally == null ? (class$javax$servlet$jsp$tagext$TryCatchFinally = TagTransformModel.class$("javax.servlet.jsp.tagext.TryCatchFinally")) : class$javax$servlet$jsp$tagext$TryCatchFinally).isAssignableFrom(clazz);
        this.tagClass = clazz;
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            Method method2 = propertyDescriptor.getWriteMethod();
            if (method2 == null) continue;
            this.propertySetters.put(propertyDescriptor.getName(), method2);
        }
        try {
            method = clazz.getMethod("setDynamicAttribute", class$java$lang$String == null ? (class$java$lang$String = TagTransformModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = TagTransformModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = TagTransformModel.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        this.dynaSetter = method;
    }

    public Writer getWriter(Writer object, Map map) throws TemplateModelException {
        try {
            boolean bl;
            Tag tag = this.getTagInstance();
            FreeMarkerPageContext freeMarkerPageContext = PageContextFactory.getCurrentPageContext();
            Tag tag2 = freeMarkerPageContext.peekTopTag();
            tag.setParent(tag2);
            tag.setPageContext((PageContext)freeMarkerPageContext);
            this.setupTag(tag, map, freeMarkerPageContext.getObjectWrapper());
            if (object instanceof JspWriter) {
                if (object != freeMarkerPageContext.getOut()) {
                    throw new TemplateModelException("out != pageContext.getOut(). Out is " + object + " pageContext.getOut() is " + freeMarkerPageContext.getOut());
                }
                bl = false;
            } else {
                object = new JspWriterAdapter((Writer)object);
                freeMarkerPageContext.pushWriter((JspWriter)object);
                bl = true;
            }
            TagWriter tagWriter = new TagWriter((Writer)object, tag, freeMarkerPageContext, bl);
            freeMarkerPageContext.pushTopTag(tag);
            freeMarkerPageContext.pushWriter((JspWriter)tagWriter);
            return tagWriter;
        }
        catch (TemplateModelException templateModelException) {
            throw templateModelException;
        }
        catch (Exception exception) {
            throw new TemplateModelException(exception);
        }
    }

    private Tag getTagInstance() throws IllegalAccessException, InstantiationException {
        return (Tag)this.tagClass.newInstance();
    }

    private void setupTag(Object object, Map map, ObjectWrapper objectWrapper) throws TemplateModelException, InvocationTargetException, IllegalAccessException {
        BeansWrapper beansWrapper;
        BeansWrapper beansWrapper2 = beansWrapper = objectWrapper instanceof BeansWrapper ? (BeansWrapper)objectWrapper : BeansWrapper.getDefaultInstance();
        if (map != null && !map.isEmpty()) {
            Object[] objectArray = new Object[1];
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                objectArray[0] = beansWrapper.unwrap((TemplateModel)entry.getValue());
                Method method = (Method)this.propertySetters.get(entry.getKey());
                if (method == null) {
                    if (this.dynaSetter == null) {
                        throw new TemplateModelException("Unknown property " + StringUtil.jQuote(entry.getKey().toString()) + " on instance of " + this.tagClass.getName());
                    }
                    this.dynaSetter.invoke(object, null, entry.getKey(), objectArray[0]);
                    continue;
                }
                BeansWrapper.coerceBigDecimals(method, objectArray);
                method.invoke(object, objectArray);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class BodyContentImpl
    extends BodyContent {
        private CharArrayWriter buf;

        BodyContentImpl(JspWriter jspWriter, boolean bl) {
            super(jspWriter);
            if (bl) {
                this.initBuffer();
            }
        }

        void initBuffer() {
            this.buf = new CharArrayWriter();
        }

        public void flush() throws IOException {
            if (this.buf == null) {
                this.getEnclosingWriter().flush();
            }
        }

        public void clear() throws IOException {
            if (this.buf == null) {
                throw new IOException("Can't clear");
            }
            this.buf = new CharArrayWriter();
        }

        public void clearBuffer() throws IOException {
            if (this.buf == null) {
                throw new IOException("Can't clear");
            }
            this.buf = new CharArrayWriter();
        }

        public int getRemaining() {
            return Integer.MAX_VALUE;
        }

        public void newLine() throws IOException {
            this.write(NEWLINE);
        }

        public void close() throws IOException {
        }

        public void print(boolean bl) throws IOException {
            this.write(bl ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        }

        public void print(char c) throws IOException {
            this.write(c);
        }

        public void print(char[] cArray) throws IOException {
            this.write(cArray);
        }

        public void print(double d) throws IOException {
            this.write(Double.toString(d));
        }

        public void print(float f) throws IOException {
            this.write(Float.toString(f));
        }

        public void print(int n) throws IOException {
            this.write(Integer.toString(n));
        }

        public void print(long l) throws IOException {
            this.write(Long.toString(l));
        }

        public void print(Object object) throws IOException {
            this.write(object == null ? "null" : object.toString());
        }

        public void print(String string) throws IOException {
            this.write(string);
        }

        public void println() throws IOException {
            this.newLine();
        }

        public void println(boolean bl) throws IOException {
            this.print(bl);
            this.newLine();
        }

        public void println(char c) throws IOException {
            this.print(c);
            this.newLine();
        }

        public void println(char[] cArray) throws IOException {
            this.print(cArray);
            this.newLine();
        }

        public void println(double d) throws IOException {
            this.print(d);
            this.newLine();
        }

        public void println(float f) throws IOException {
            this.print(f);
            this.newLine();
        }

        public void println(int n) throws IOException {
            this.print(n);
            this.newLine();
        }

        public void println(long l) throws IOException {
            this.print(l);
            this.newLine();
        }

        public void println(Object object) throws IOException {
            this.print(object);
            this.newLine();
        }

        public void println(String string) throws IOException {
            this.print(string);
            this.newLine();
        }

        public void write(int n) throws IOException {
            if (this.buf != null) {
                this.buf.write(n);
            } else {
                this.getEnclosingWriter().write(n);
            }
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            if (this.buf != null) {
                this.buf.write(cArray, n, n2);
            } else {
                this.getEnclosingWriter().write(cArray, n, n2);
            }
        }

        public String getString() {
            return this.buf.toString();
        }

        public Reader getReader() {
            return new CharArrayReader(this.buf.toCharArray());
        }

        public void writeOut(Writer writer) throws IOException {
            this.buf.writeTo(writer);
        }
    }

    static class JspWriterAdapter
    extends JspWriter {
        private final Writer out;

        JspWriterAdapter(Writer writer) {
            super(0, true);
            this.out = writer;
        }

        public String toString() {
            return "JspWriterAdapter wrapping a " + this.out.toString();
        }

        public void clear() throws IOException {
            throw new IOException("Can't clear");
        }

        public void clearBuffer() throws IOException {
            throw new IOException("Can't clear");
        }

        public void close() throws IOException {
            throw new IOException("Close not permitted.");
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public int getRemaining() {
            return 0;
        }

        public void newLine() throws IOException {
            this.out.write(NEWLINE);
        }

        public void print(boolean bl) throws IOException {
            this.out.write(bl ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        }

        public void print(char c) throws IOException {
            this.out.write(c);
        }

        public void print(char[] cArray) throws IOException {
            this.out.write(cArray);
        }

        public void print(double d) throws IOException {
            this.out.write(Double.toString(d));
        }

        public void print(float f) throws IOException {
            this.out.write(Float.toString(f));
        }

        public void print(int n) throws IOException {
            this.out.write(Integer.toString(n));
        }

        public void print(long l) throws IOException {
            this.out.write(Long.toString(l));
        }

        public void print(Object object) throws IOException {
            this.out.write(object == null ? "null" : object.toString());
        }

        public void print(String string) throws IOException {
            this.out.write(string);
        }

        public void println() throws IOException {
            this.newLine();
        }

        public void println(boolean bl) throws IOException {
            this.print(bl);
            this.newLine();
        }

        public void println(char c) throws IOException {
            this.print(c);
            this.newLine();
        }

        public void println(char[] cArray) throws IOException {
            this.print(cArray);
            this.newLine();
        }

        public void println(double d) throws IOException {
            this.print(d);
            this.newLine();
        }

        public void println(float f) throws IOException {
            this.print(f);
            this.newLine();
        }

        public void println(int n) throws IOException {
            this.print(n);
            this.newLine();
        }

        public void println(long l) throws IOException {
            this.print(l);
            this.newLine();
        }

        public void println(Object object) throws IOException {
            this.print(object);
            this.newLine();
        }

        public void println(String string) throws IOException {
            this.print(string);
            this.newLine();
        }

        public void write(int n) throws IOException {
            this.out.write(n);
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            this.out.write(cArray, n, n2);
        }
    }

    class TagWriter
    extends BodyContentImpl
    implements TransformControl {
        private final Tag tag;
        private final FreeMarkerPageContext pageContext;
        private boolean needPop = true;
        private final boolean needDoublePop;

        TagWriter(Writer writer, Tag tag, FreeMarkerPageContext freeMarkerPageContext, boolean bl) {
            super((JspWriter)writer, false);
            this.needDoublePop = bl;
            this.tag = tag;
            this.pageContext = freeMarkerPageContext;
        }

        public String toString() {
            return "TagWriter for " + this.tag.getClass().getName() + " wrapping a " + this.getEnclosingWriter().toString();
        }

        Tag getTag() {
            return this.tag;
        }

        FreeMarkerPageContext getPageContext() {
            return this.pageContext;
        }

        public int onStart() throws TemplateModelException {
            try {
                int n = this.tag.doStartTag();
                switch (n) {
                    case 0: 
                    case 6: {
                        this.endEvaluation();
                        return 0;
                    }
                    case 2: {
                        if (TagTransformModel.this.isBodyTag) {
                            this.initBuffer();
                            BodyTag bodyTag = (BodyTag)this.tag;
                            bodyTag.setBodyContent((BodyContent)this);
                            bodyTag.doInitBody();
                        } else {
                            throw new TemplateModelException("Can't buffer body since " + this.tag.getClass().getName() + " does not implement BodyTag.");
                        }
                    }
                    case 1: {
                        return 1;
                    }
                }
                throw new RuntimeException("Illegal return value " + n + " from " + this.tag.getClass().getName() + ".doStartTag()");
            }
            catch (JspException jspException) {
                throw new TemplateModelException(jspException.getMessage(), (Exception)((Object)jspException));
            }
        }

        public int afterBody() throws TemplateModelException {
            try {
                if (TagTransformModel.this.isIterationTag) {
                    int n = ((IterationTag)this.tag).doAfterBody();
                    switch (n) {
                        case 0: {
                            this.endEvaluation();
                            return 1;
                        }
                        case 2: {
                            return 0;
                        }
                    }
                    throw new TemplateModelException("Unexpected return value " + n + "from " + this.tag.getClass().getName() + ".doAfterBody()");
                }
                this.endEvaluation();
                return 1;
            }
            catch (JspException jspException) {
                throw new TemplateModelException((Exception)((Object)jspException));
            }
        }

        private void endEvaluation() throws JspException {
            if (this.needPop) {
                this.pageContext.popWriter();
                this.needPop = false;
            }
            if (this.tag.doEndTag() == 5) {
                logger.warn("Tag.SKIP_PAGE was ignored from a " + this.tag.getClass().getName() + " tag.");
            }
        }

        public void onError(Throwable throwable) throws Throwable {
            if (!TagTransformModel.this.isTryCatchFinally) {
                throw throwable;
            }
            ((TryCatchFinally)this.tag).doCatch(throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.needPop) {
                this.pageContext.popWriter();
            }
            this.pageContext.popTopTag();
            try {
                if (TagTransformModel.this.isTryCatchFinally) {
                    ((TryCatchFinally)this.tag).doFinally();
                }
                this.tag.release();
            }
            finally {
                if (this.needDoublePop) {
                    this.pageContext.popWriter();
                }
            }
        }
    }
}

