/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jdom;

import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.Collections12;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class NodeListModel
implements TemplateHashModel,
TemplateMethodModel,
TemplateCollectionModel,
TemplateSequenceModel,
TemplateScalarModel {
    private static final AttributeXMLOutputter OUTPUT = new AttributeXMLOutputter();
    private static final NodeListModel EMPTY = new NodeListModel(null, false);
    private static final Map XPATH_CACHE = new WeakHashMap();
    private static final NamedNodeOperator NAMED_CHILDREN_OP = new NamedChildrenOp();
    private static final NamedNodeOperator NAMED_ATTRIBUTE_OP = new NamedAttributeOp();
    private static final NodeOperator ALL_ATTRIBUTES_OP = new AllAttributesOp();
    private static final NodeOperator ALL_CHILDREN_OP = new AllChildrenOp();
    private static final Map OPERATIONS = NodeListModel.createOperations();
    private static final Map SPECIAL_OPERATIONS = NodeListModel.createSpecialOperations();
    private static final int SPECIAL_OPERATION_COPY = 0;
    private static final int SPECIAL_OPERATION_UNIQUE = 1;
    private static final int SPECIAL_OPERATION_FILTER_NAME = 2;
    private static final int SPECIAL_OPERATION_FILTER_TYPE = 3;
    private static final int SPECIAL_OPERATION_QUERY_TYPE = 4;
    private static final int SPECIAL_OPERATION_REGISTER_NAMESPACE = 5;
    private static final int SPECIAL_OPERATION_PLAINTEXT = 6;
    private final List nodes;
    private final Map namespaces;

    public NodeListModel(Document document) {
        this.nodes = document == null ? Collections.EMPTY_LIST : Collections12.singletonList(document);
        this.namespaces = new HashMap();
    }

    public NodeListModel(Element element) {
        this.nodes = element == null ? Collections.EMPTY_LIST : Collections12.singletonList(element);
        this.namespaces = new HashMap();
    }

    private NodeListModel(Object object, Map map) {
        this.nodes = object == null ? Collections.EMPTY_LIST : Collections12.singletonList(object);
        this.namespaces = map;
    }

    public NodeListModel(List list) {
        this(list, true);
    }

    public NodeListModel(List list, boolean bl) {
        this.nodes = bl && list != null ? new ArrayList(list) : (list == null ? Collections.EMPTY_LIST : list);
        this.namespaces = new HashMap();
    }

    private NodeListModel(List list, Map map) {
        this.nodes = list == null ? Collections.EMPTY_LIST : list;
        this.namespaces = map;
    }

    private static final NodeListModel createNodeListModel(List list, Map map) {
        if (list == null || list.isEmpty()) {
            if (map.isEmpty()) {
                return EMPTY;
            }
            return new NodeListModel(Collections.EMPTY_LIST, map);
        }
        if (list.size() == 1) {
            return new NodeListModel(list.get(0), map);
        }
        return new NodeListModel(list, map);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public String getAsString() throws TemplateModelException {
        if (this.isEmpty()) {
            return "";
        }
        StringWriter stringWriter = new StringWriter(this.nodes.size() * 128);
        try {
            Iterator iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Element) {
                    OUTPUT.output((Element)e, stringWriter);
                    continue;
                }
                if (e instanceof Attribute) {
                    OUTPUT.output((Attribute)e, stringWriter);
                    continue;
                }
                if (e instanceof String) {
                    stringWriter.write(OUTPUT.escapeElementEntities(e.toString()));
                    continue;
                }
                if (e instanceof Text) {
                    OUTPUT.output((Text)e, stringWriter);
                    continue;
                }
                if (e instanceof Document) {
                    OUTPUT.output((Document)e, stringWriter);
                    continue;
                }
                if (e instanceof ProcessingInstruction) {
                    OUTPUT.output((ProcessingInstruction)e, stringWriter);
                    continue;
                }
                if (e instanceof Comment) {
                    OUTPUT.output((Comment)e, stringWriter);
                    continue;
                }
                if (e instanceof CDATA) {
                    OUTPUT.output((CDATA)e, stringWriter);
                    continue;
                }
                if (e instanceof DocType) {
                    OUTPUT.output((DocType)e, stringWriter);
                    continue;
                }
                if (e instanceof EntityRef) {
                    OUTPUT.output((EntityRef)e, stringWriter);
                    continue;
                }
                throw new TemplateModelException(e.getClass().getName() + " is not a core JDOM class");
            }
        }
        catch (IOException iOException) {
            throw new TemplateModelException(iOException.getMessage());
        }
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateModel get(String string) throws TemplateModelException {
        Object object;
        if (this.isEmpty()) {
            return EMPTY;
        }
        if (string == null || string.length() == 0) {
            throw new TemplateModelException("Invalid key [" + string + "]");
        }
        NodeOperator nodeOperator = null;
        NamedNodeOperator namedNodeOperator = null;
        String string2 = null;
        switch (string.charAt(0)) {
            case '@': {
                if (string.length() != 2 || string.charAt(1) != '*') {
                    namedNodeOperator = NAMED_ATTRIBUTE_OP;
                    string2 = string.substring(1);
                    break;
                }
                nodeOperator = ALL_ATTRIBUTES_OP;
                break;
            }
            case '*': {
                if (string.length() == 1) {
                    nodeOperator = ALL_CHILDREN_OP;
                    break;
                }
                throw new TemplateModelException("Invalid key [" + string + "]");
            }
            case '_': 
            case 'x': {
                nodeOperator = (NodeOperator)OPERATIONS.get(string);
                if (nodeOperator != null || (object = (Integer)SPECIAL_OPERATIONS.get(string)) == null) break;
                switch ((Integer)object) {
                    case 0: {
                        Map map = this.namespaces;
                        synchronized (map) {
                            return new NodeListModel(this.nodes, (Map)((HashMap)this.namespaces).clone());
                        }
                    }
                    case 1: {
                        return new NodeListModel(NodeListModel.removeDuplicates(this.nodes), this.namespaces);
                    }
                    case 2: {
                        return new NameFilter();
                    }
                    case 3: {
                        return new TypeFilter();
                    }
                    case 4: {
                        return this.getType();
                    }
                    case 5: {
                        return new RegisterNamespace();
                    }
                    case 6: {
                        return this.getPlainText();
                    }
                }
            }
        }
        if (nodeOperator == null && namedNodeOperator == null) {
            namedNodeOperator = NAMED_CHILDREN_OP;
            string2 = string;
        }
        object = null;
        if (nodeOperator != null) {
            object = NodeListModel.evaluateElementOperation(nodeOperator, this.nodes);
        } else {
            String string3 = string2;
            Namespace namespace = Namespace.NO_NAMESPACE;
            int n = string2.indexOf(58);
            if (n != -1) {
                string3 = string2.substring(n + 1);
                String string4 = string2.substring(0, n);
                Map map = this.namespaces;
                synchronized (map) {
                    namespace = (Namespace)this.namespaces.get(string4);
                }
                if (namespace == null) {
                    if (string4.equals("xml")) {
                        namespace = Namespace.XML_NAMESPACE;
                    } else {
                        throw new TemplateModelException("Unregistered namespace prefix '" + string4 + "'");
                    }
                }
            }
            object = NodeListModel.evaluateNamedElementOperation(namedNodeOperator, string3, namespace, this.nodes);
        }
        return NodeListModel.createNodeListModel((List)object, this.namespaces);
    }

    private TemplateModel getType() {
        if (this.nodes.size() == 0) {
            return new SimpleScalar("");
        }
        Object e = this.nodes.get(0);
        char c = e instanceof Element ? (char)'e' : (e instanceof Text || e instanceof String ? (char)'x' : (e instanceof Attribute ? (char)'a' : (e instanceof EntityRef ? (char)'n' : (e instanceof Document ? (char)'d' : (e instanceof DocType ? (char)'t' : (e instanceof Comment ? (char)'c' : (e instanceof ProcessingInstruction ? (char)'p' : '?')))))));
        return new SimpleScalar(new String(new char[]{c}));
    }

    private SimpleScalar getPlainText() throws TemplateModelException {
        List list = NodeListModel.evaluateElementOperation((TextOp)OPERATIONS.get("_text"), this.nodes);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        return new SimpleScalar(stringBuffer.toString());
    }

    public TemplateModelIterator iterator() {
        return new TemplateModelIterator(){
            private final Iterator it;
            {
                this.it = NodeListModel.this.nodes.iterator();
            }

            public TemplateModel next() {
                return this.it.hasNext() ? new NodeListModel(this.it.next(), NodeListModel.this.namespaces) : null;
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }
        };
    }

    public TemplateModel get(int n) throws TemplateModelException {
        try {
            return new NodeListModel(this.nodes.get(n), this.namespaces);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new TemplateModelException("Index out of bounds: " + indexOutOfBoundsException.getMessage());
        }
    }

    public int size() {
        return this.nodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object exec(List list) throws TemplateModelException {
        if (list == null || list.size() != 1) {
            throw new TemplateModelException("Exactly one argument required for execute() on NodeTemplate");
        }
        String string = (String)list.get(0);
        JDOMXPathEx jDOMXPathEx = null;
        try {
            Map map = XPATH_CACHE;
            synchronized (map) {
                jDOMXPathEx = (JDOMXPathEx)((Object)XPATH_CACHE.get(string));
                if (jDOMXPathEx == null) {
                    jDOMXPathEx = new JDOMXPathEx(string);
                    XPATH_CACHE.put(string, jDOMXPathEx);
                }
            }
            return NodeListModel.createNodeListModel(jDOMXPathEx.selectNodes(this.nodes, this.namespaces), this.namespaces);
        }
        catch (Exception exception) {
            throw new TemplateModelException("Could not evaulate XPath expression " + string, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNamespace(String string, String string2) {
        Map map = this.namespaces;
        synchronized (map) {
            this.namespaces.put(string, Namespace.getNamespace((String)string, (String)string2));
        }
    }

    private static final Element getParent(Object object) {
        if (object instanceof Element) {
            return ((Element)object).getParent();
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getParent();
        }
        if (object instanceof Text) {
            return ((Text)object).getParent();
        }
        if (object instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)object).getParent();
        }
        if (object instanceof Comment) {
            return ((Comment)object).getParent();
        }
        if (object instanceof EntityRef) {
            return ((EntityRef)object).getParent();
        }
        return null;
    }

    private static final List evaluateElementOperation(NodeOperator nodeOperator, List list) throws TemplateModelException {
        int n = list.size();
        List[] listArray = new List[n];
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = nodeOperator.operate(iterator.next());
            if (list2 == null) continue;
            listArray[n3++] = list2;
            n2 += list2.size();
        }
        ArrayList arrayList = new ArrayList(n2);
        for (int i = 0; i < n; ++i) {
            if (listArray[i] == null) continue;
            arrayList.addAll(listArray[i]);
        }
        return arrayList;
    }

    private static final List evaluateNamedElementOperation(NamedNodeOperator namedNodeOperator, String string, Namespace namespace, List list) throws TemplateModelException {
        int n = list.size();
        List[] listArray = new List[n];
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = namedNodeOperator.operate(iterator.next(), string, namespace);
            listArray[n3++] = list2;
            n2 += list2.size();
        }
        ArrayList arrayList = new ArrayList(n2);
        for (int i = 0; i < n; ++i) {
            arrayList.addAll(listArray[i]);
        }
        return arrayList;
    }

    private static final List removeDuplicates(List list) {
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        HashSet hashSet = new HashSet(n * 4 / 3, 0.75f);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!hashSet.add(e)) continue;
            arrayList.add(e);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    private static final Map createOperations() {
        HashMap<String, NodeOperator> hashMap = new HashMap<String, NodeOperator>();
        hashMap.put("_ancestor", new AncestorOp());
        hashMap.put("_ancestorOrSelf", new AncestorOrSelfOp());
        hashMap.put("_attributes", ALL_ATTRIBUTES_OP);
        hashMap.put("_children", ALL_CHILDREN_OP);
        hashMap.put("_cname", new CanonicalNameOp());
        hashMap.put("_content", new ContentOp());
        hashMap.put("_descendant", new DescendantOp());
        hashMap.put("_descendantOrSelf", new DescendantOrSelfOp());
        hashMap.put("_document", new DocumentOp());
        hashMap.put("_doctype", new DocTypeOp());
        hashMap.put("_name", new NameOp());
        hashMap.put("_nsprefix", new NamespacePrefixOp());
        hashMap.put("_nsuri", new NamespaceUriOp());
        hashMap.put("_parent", new ParentOp());
        hashMap.put("_qname", new QNameOp());
        hashMap.put("_text", new TextOp());
        return hashMap;
    }

    private static final Map createSpecialOperations() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Integer n = new Integer(0);
        Integer n2 = new Integer(1);
        Integer n3 = new Integer(2);
        Integer n4 = new Integer(3);
        Integer n5 = new Integer(4);
        Integer n6 = new Integer(5);
        Integer n7 = new Integer(6);
        hashMap.put("_copy", n);
        hashMap.put("_unique", n2);
        hashMap.put("_fname", n3);
        hashMap.put("_ftype", n4);
        hashMap.put("_type", n5);
        hashMap.put("_registerNamespace", n6);
        hashMap.put("_plaintext", n7);
        hashMap.put("x_copy", n);
        hashMap.put("x_unique", n2);
        hashMap.put("x_fname", n3);
        hashMap.put("x_ftype", n4);
        hashMap.put("x_type", n5);
        return hashMap;
    }

    public static void main(String[] stringArray) throws Exception {
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(System.in);
        SimpleHash simpleHash = new SimpleHash();
        simpleHash.put("document", new NodeListModel(document));
        FileReader fileReader = new FileReader(stringArray[0]);
        Template template = new Template(stringArray[0], fileReader);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
        template.process(simpleHash, outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
        ((Writer)outputStreamWriter).close();
    }

    private static final class AllAttributesOp
    implements NodeOperator {
        private AllAttributesOp() {
        }

        public List operate(Object object) {
            if (!(object instanceof Element)) {
                return null;
            }
            return ((Element)object).getAttributes();
        }
    }

    private static final class AllChildrenOp
    implements NodeOperator {
        private AllChildrenOp() {
        }

        public List operate(Object object) {
            if (object instanceof Element) {
                return ((Element)object).getChildren();
            }
            if (object instanceof Document) {
                Element element = ((Document)object).getRootElement();
                return element == null ? Collections.EMPTY_LIST : Collections12.singletonList(element);
            }
            return null;
        }
    }

    private static final class AncestorOp
    implements NodeOperator {
        private AncestorOp() {
        }

        public List operate(Object object) {
            Element element = NodeListModel.getParent(object);
            if (element == null) {
                return Collections.EMPTY_LIST;
            }
            LinkedList<Element> linkedList = new LinkedList<Element>();
            do {
                linkedList.addFirst(element);
            } while ((element = element.getParent()) != null);
            return linkedList;
        }
    }

    private static final class AncestorOrSelfOp
    implements NodeOperator {
        private AncestorOrSelfOp() {
        }

        public List operate(Object object) {
            Element element = NodeListModel.getParent(object);
            if (element == null) {
                return Collections12.singletonList(object);
            }
            LinkedList<Object> linkedList = new LinkedList<Object>();
            linkedList.addFirst(object);
            do {
                linkedList.addFirst(element);
            } while ((element = element.getParent()) != null);
            return linkedList;
        }
    }

    private static final class AttributeXMLOutputter
    extends XMLOutputter {
        private AttributeXMLOutputter() {
        }

        public void output(Attribute attribute, Writer writer) throws IOException {
            writer.write(" ");
            writer.write(attribute.getQualifiedName());
            writer.write("=");
            writer.write("\"");
            writer.write(this.escapeAttributeEntities(attribute.getValue()));
            writer.write("\"");
        }
    }

    private static final class CanonicalNameOp
    implements NodeOperator {
        private CanonicalNameOp() {
        }

        public List operate(Object object) {
            if (object instanceof Element) {
                Element element = (Element)object;
                return Collections12.singletonList(element.getNamespace().getURI() + element.getName());
            }
            if (object instanceof Attribute) {
                Attribute attribute = (Attribute)object;
                return Collections12.singletonList(attribute.getNamespace().getURI() + attribute.getName());
            }
            return null;
        }
    }

    private static final class ContentOp
    implements NodeOperator {
        private ContentOp() {
        }

        public List operate(Object object) {
            if (object instanceof Element) {
                return ((Element)object).getContent();
            }
            if (object instanceof Document) {
                return ((Document)object).getContent();
            }
            return null;
        }
    }

    private static class DescendantOp
    implements NodeOperator {
        private DescendantOp() {
        }

        public List operate(Object object) {
            LinkedList<Element> linkedList = new LinkedList<Element>();
            if (object instanceof Element) {
                this.addChildren((Element)object, linkedList);
            } else if (object instanceof Document) {
                Element element = ((Document)object).getRootElement();
                linkedList.add(element);
                this.addChildren(element, linkedList);
            } else {
                return null;
            }
            return linkedList;
        }

        private void addChildren(Element element, List list) {
            List list2 = element.getChildren();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                list.add(element2);
                this.addChildren(element2, list);
            }
        }
    }

    private static final class DescendantOrSelfOp
    extends DescendantOp {
        private DescendantOrSelfOp() {
        }

        public List operate(Object object) {
            LinkedList linkedList = (LinkedList)super.operate(object);
            linkedList.addFirst(object);
            return linkedList;
        }
    }

    private static final class DocTypeOp
    implements NodeOperator {
        private DocTypeOp() {
        }

        public List operate(Object object) {
            if (object instanceof Document) {
                DocType docType = ((Document)object).getDocType();
                return docType == null ? Collections.EMPTY_LIST : Collections12.singletonList(docType);
            }
            return null;
        }
    }

    private static final class DocumentOp
    implements NodeOperator {
        private DocumentOp() {
        }

        public List operate(Object object) {
            Document document = null;
            if (object instanceof Element) {
                document = ((Element)object).getDocument();
            } else if (object instanceof Attribute) {
                Element element = ((Attribute)object).getParent();
                document = element == null ? null : element.getDocument();
            } else if (object instanceof Text) {
                Element element = ((Text)object).getParent();
                document = element == null ? null : element.getDocument();
            } else if (object instanceof Document) {
                document = (Document)object;
            } else if (object instanceof ProcessingInstruction) {
                document = ((ProcessingInstruction)object).getDocument();
            } else if (object instanceof EntityRef) {
                document = ((EntityRef)object).getDocument();
            } else if (object instanceof Comment) {
                document = ((Comment)object).getDocument();
            } else {
                return null;
            }
            return document == null ? Collections.EMPTY_LIST : Collections12.singletonList(document);
        }
    }

    private static final class JDOMXPathEx
    extends JDOMXPath {
        JDOMXPathEx(String string) throws JaxenException {
            super(string);
        }

        public List selectNodes(Object object, Map map) throws JaxenException {
            Context context = this.getContext(object);
            context.getContextSupport().setNamespaceContext((NamespaceContext)new NamespaceContextImpl(map));
            return this.selectNodesForContext(context);
        }

        private static final class NamespaceContextImpl
        implements NamespaceContext {
            private final Map namespaces;

            NamespaceContextImpl(Map map) {
                this.namespaces = map;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String translateNamespacePrefixToUri(String string) {
                if (string.length() == 0) {
                    return string;
                }
                Map map = this.namespaces;
                synchronized (map) {
                    Namespace namespace = (Namespace)this.namespaces.get(string);
                    return namespace == null ? null : namespace.getURI();
                }
            }
        }
    }

    private final class NameFilter
    implements TemplateMethodModel {
        private NameFilter() {
        }

        public boolean isEmpty() {
            return false;
        }

        public Object exec(List list) {
            HashSet hashSet = new HashSet(list);
            LinkedList linkedList = new LinkedList(NodeListModel.this.nodes);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                String string = null;
                if (e instanceof Element) {
                    string = ((Element)e).getName();
                } else if (e instanceof Attribute) {
                    string = ((Attribute)e).getName();
                } else if (e instanceof ProcessingInstruction) {
                    string = ((ProcessingInstruction)e).getTarget();
                } else if (e instanceof EntityRef) {
                    string = ((EntityRef)e).getName();
                } else if (e instanceof DocType) {
                    string = ((DocType)e).getPublicID();
                }
                if (string != null && hashSet.contains(string)) continue;
                iterator.remove();
            }
            return NodeListModel.createNodeListModel(linkedList, NodeListModel.this.namespaces);
        }
    }

    private static final class NameOp
    implements NodeOperator {
        private NameOp() {
        }

        public List operate(Object object) {
            if (object instanceof Element) {
                return Collections12.singletonList(((Element)object).getName());
            }
            if (object instanceof Attribute) {
                return Collections12.singletonList(((Attribute)object).getName());
            }
            if (object instanceof EntityRef) {
                return Collections12.singletonList(((EntityRef)object).getName());
            }
            if (object instanceof ProcessingInstruction) {
                return Collections12.singletonList(((ProcessingInstruction)object).getTarget());
            }
            if (object instanceof DocType) {
                return Collections12.singletonList(((DocType)object).getPublicID());
            }
            return null;
        }
    }

    private static final class NamedAttributeOp
    implements NamedNodeOperator {
        private NamedAttributeOp() {
        }

        public List operate(Object object, String string, Namespace namespace) {
            Attribute attribute = null;
            if (object instanceof Element) {
                Element element = (Element)object;
                attribute = element.getAttribute(string, namespace);
            } else if (object instanceof ProcessingInstruction) {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
                attribute = "target".equals(string) ? new Attribute("target", processingInstruction.getTarget()) : ("data".equals(string) ? new Attribute("data", processingInstruction.getData()) : new Attribute(string, processingInstruction.getValue(string)));
            } else if (object instanceof DocType) {
                DocType docType = (DocType)object;
                if ("publicId".equals(string)) {
                    attribute = new Attribute("publicId", docType.getPublicID());
                } else if ("systemId".equals(string)) {
                    attribute = new Attribute("systemId", docType.getSystemID());
                } else if ("elementName".equals(string)) {
                    attribute = new Attribute("elementName", docType.getElementName());
                }
            } else {
                return null;
            }
            return attribute == null ? Collections.EMPTY_LIST : Collections12.singletonList(attribute);
        }
    }

    private static final class NamedChildrenOp
    implements NamedNodeOperator {
        private NamedChildrenOp() {
        }

        public List operate(Object object, String string, Namespace namespace) {
            if (object instanceof Element) {
                return ((Element)object).getChildren(string, namespace);
            }
            if (object instanceof Document) {
                Element element = ((Document)object).getRootElement();
                if (element != null && element.getName().equals(string) && element.getNamespaceURI().equals(namespace.getURI())) {
                    return Collections12.singletonList(element);
                }
                return Collections.EMPTY_LIST;
            }
            return null;
        }
    }

    private static interface NamedNodeOperator {
        public List operate(Object var1, String var2, Namespace var3) throws TemplateModelException;
    }

    private static final class NamespacePrefixOp
    implements NodeOperator {
        private NamespacePrefixOp() {
        }

        public List operate(Object object) {
            if (object instanceof Element) {
                return Collections12.singletonList(((Element)object).getNamespace().getPrefix());
            }
            if (object instanceof Attribute) {
                return Collections12.singletonList(((Attribute)object).getNamespace().getPrefix());
            }
            return null;
        }
    }

    private static final class NamespaceUriOp
    implements NodeOperator {
        private NamespaceUriOp() {
        }

        public List operate(Object object) {
            if (object instanceof Element) {
                return Collections12.singletonList(((Element)object).getNamespace().getURI());
            }
            if (object instanceof Attribute) {
                return Collections12.singletonList(((Attribute)object).getNamespace().getURI());
            }
            return null;
        }
    }

    private static interface NodeOperator {
        public List operate(Object var1) throws TemplateModelException;
    }

    private static final class ParentOp
    implements NodeOperator {
        private ParentOp() {
        }

        public List operate(Object object) {
            Element element = NodeListModel.getParent(object);
            return element == null ? Collections.EMPTY_LIST : Collections12.singletonList(element);
        }
    }

    private static final class QNameOp
    implements NodeOperator {
        private QNameOp() {
        }

        public List operate(Object object) {
            if (object instanceof Element) {
                return Collections12.singletonList(((Element)object).getQualifiedName());
            }
            if (object instanceof Attribute) {
                return Collections12.singletonList(((Attribute)object).getQualifiedName());
            }
            return null;
        }
    }

    private final class RegisterNamespace
    implements TemplateMethodModel {
        private RegisterNamespace() {
        }

        public boolean isEmpty() {
            return false;
        }

        public Object exec(List list) throws TemplateModelException {
            if (list.size() != 2) {
                throw new TemplateModelException("_registerNamespace(prefix, uri) requires two arguments");
            }
            NodeListModel.this.registerNamespace((String)list.get(0), (String)list.get(1));
            return TemplateScalarModel.EMPTY_STRING;
        }
    }

    private static final class TextOp
    implements NodeOperator {
        private TextOp() {
        }

        public List operate(Object object) {
            if (object instanceof Element) {
                return Collections12.singletonList(((Element)object).getTextTrim());
            }
            if (object instanceof Attribute) {
                return Collections12.singletonList(((Attribute)object).getValue());
            }
            if (object instanceof CDATA) {
                return Collections12.singletonList(((CDATA)object).getText());
            }
            if (object instanceof Comment) {
                return Collections12.singletonList(((Comment)object).getText());
            }
            if (object instanceof ProcessingInstruction) {
                return Collections12.singletonList(((ProcessingInstruction)object).getData());
            }
            return null;
        }
    }

    private final class TypeFilter
    implements TemplateMethodModel {
        private TypeFilter() {
        }

        public boolean isEmpty() {
            return false;
        }

        public Object exec(List list) throws TemplateModelException {
            if (list == null || list.size() == 0) {
                throw new TemplateModelException("_type expects exactly one argument");
            }
            String string = (String)list.get(0);
            boolean bl = string.indexOf(33) != -1;
            boolean bl2 = bl != (string.indexOf(97) == -1);
            boolean bl3 = bl != (string.indexOf(99) == -1);
            boolean bl4 = bl != (string.indexOf(100) == -1);
            boolean bl5 = bl != (string.indexOf(101) == -1);
            boolean bl6 = bl != (string.indexOf(110) == -1);
            boolean bl7 = bl != (string.indexOf(112) == -1);
            boolean bl8 = bl != (string.indexOf(116) == -1);
            boolean bl9 = bl != (string.indexOf(120) == -1);
            LinkedList linkedList = new LinkedList(NodeListModel.this.nodes);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Element && bl5 || e instanceof Attribute && bl2 || e instanceof String && bl9 || e instanceof Text && bl9 || e instanceof ProcessingInstruction && bl7 || e instanceof Comment && bl3 || e instanceof EntityRef && bl6 || e instanceof Document && bl4) && (!(e instanceof DocType) || !bl8)) continue;
                iterator.remove();
            }
            return NodeListModel.createNodeListModel(linkedList, NodeListModel.this.namespaces);
        }
    }
}

