/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.core.Environment;
import freemarker.ext.dom.NodeListModel;
import freemarker.ext.dom.XPathSupport;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNull;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

class XalanXPathSupport
implements XPathSupport {
    private XPathContext xpathContext = new XPathContext();
    private static final String ERRMSG_EMPTY_NODE_SET = "Cannot perform an XPath query against an empty node set.";
    private static PrefixResolver customPrefixResolver = new PrefixResolver(){

        public String getNamespaceForPrefix(String string, Node node) {
            return this.getNamespaceForPrefix(string);
        }

        public String getNamespaceForPrefix(String string) {
            if (string.equals("D")) {
                return Environment.getCurrentEnvironment().getDefaultNS();
            }
            return Environment.getCurrentEnvironment().getNamespaceForPrefix(string);
        }

        public String getBaseIdentifier() {
            return null;
        }

        public boolean handlesNullPrefixes() {
            return false;
        }
    };

    XalanXPathSupport() {
    }

    public synchronized TemplateModel executeQuery(Object object, String string) throws TemplateModelException {
        if (!(object instanceof Node)) {
            if (object != null) {
                if (XalanXPathSupport.isNodeList(object)) {
                    int n = ((List)object).size();
                    if (n != 0) {
                        throw new TemplateModelException("Cannot perform an XPath query against a node set of " + n + " nodes. Expecting a single node.");
                    }
                    throw new TemplateModelException(ERRMSG_EMPTY_NODE_SET);
                }
                throw new TemplateModelException("Cannot perform an XPath query against a " + object.getClass().getName() + ". Expecting a single org.w3c.dom.Node.");
            }
            throw new TemplateModelException(ERRMSG_EMPTY_NODE_SET);
        }
        Node node = (Node)object;
        try {
            XPath xPath = new XPath(string, null, customPrefixResolver, 0, null);
            int n = this.xpathContext.getDTMHandleFromNode(node);
            XObject xObject = xPath.execute(this.xpathContext, n, customPrefixResolver);
            if (xObject instanceof XNodeSet) {
                Node node2;
                NodeListModel nodeListModel = new NodeListModel(node);
                nodeListModel.xpathSupport = this;
                NodeIterator nodeIterator = xObject.nodeset();
                do {
                    if ((node2 = nodeIterator.nextNode()) == null) continue;
                    nodeListModel.add(node2);
                } while (node2 != null);
                return nodeListModel.size() == 1 ? nodeListModel.get(0) : nodeListModel;
            }
            if (xObject instanceof XBoolean) {
                return ((XBoolean)xObject).bool() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
            }
            if (xObject instanceof XNull) {
                return null;
            }
            if (xObject instanceof XString) {
                return new SimpleScalar(xObject.toString());
            }
            if (xObject instanceof XNumber) {
                return new SimpleNumber(new Double(((XNumber)xObject).num()));
            }
            throw new TemplateModelException("Cannot deal with type: " + xObject.getClass().getName());
        }
        catch (TransformerException transformerException) {
            throw new TemplateModelException(transformerException);
        }
    }

    private static boolean isNodeList(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (list.get(i) instanceof Node) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

