/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Locale;
import java.util.StringTokenizer;

public class Transform {
    private File inputFile;
    private File ftlFile;
    private File outputFile;
    private String encoding;
    private Locale locale;
    private Configuration cfg;

    public static void main(String[] stringArray) {
        try {
            Transform transform = Transform.transformFromArgs(stringArray);
            transform.transform();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            Transform.usage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    Transform(File file, File file2, File file3, Locale locale, String string) throws IOException {
        if (string == null) {
            string = System.getProperty("file.encoding");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.encoding = string;
        this.locale = locale;
        this.inputFile = file;
        this.ftlFile = file2;
        this.outputFile = file3;
        File file4 = file2.getAbsoluteFile().getParentFile();
        this.cfg = new Configuration();
        this.cfg.setDirectoryForTemplateLoading(file4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transform() throws Exception {
        String string = this.ftlFile.getName();
        Template template = this.cfg.getTemplate(string, this.locale);
        NodeModel nodeModel = NodeModel.parse(this.inputFile);
        OutputStream outputStream = System.out;
        if (this.outputFile != null) {
            outputStream = new FileOutputStream(this.outputFile);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
        try {
            template.process(null, outputStreamWriter, null, nodeModel);
        }
        finally {
            if (this.outputFile != null) {
                ((Writer)outputStreamWriter).close();
            }
        }
    }

    static Transform transformFromArgs(String[] stringArray) throws IOException {
        Serializable serializable;
        Object object;
        Object object2;
        int n = 0;
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        Object object6 = null;
        Object object7 = null;
        while (n < stringArray.length) {
            object2 = stringArray[n++];
            if (n >= stringArray.length) {
                throw new IllegalArgumentException("");
            }
            object = stringArray[n++];
            if (((String)object2).equals("-in")) {
                if (object3 != null) {
                    throw new IllegalArgumentException("The input file should only be specified once");
                }
                object3 = object;
                continue;
            }
            if (((String)object2).equals("-ftl")) {
                if (object5 != null) {
                    throw new IllegalArgumentException("The ftl file should only be specified once");
                }
                object5 = object;
                continue;
            }
            if (((String)object2).equals("-out")) {
                if (object4 != null) {
                    throw new IllegalArgumentException("The output file should only be specified once");
                }
                object4 = object;
                continue;
            }
            if (((String)object2).equals("-locale")) {
                if (object6 != null) {
                    throw new IllegalArgumentException("The locale should only be specified once");
                }
                object6 = object;
                continue;
            }
            if (((String)object2).equals("-encoding")) {
                if (object7 != null) {
                    throw new IllegalArgumentException("The encoding should only be specified once");
                }
                object7 = object;
                continue;
            }
            throw new IllegalArgumentException("Unknown input argument: " + (String)object2);
        }
        if (object3 == null) {
            throw new IllegalArgumentException("No input file specified.");
        }
        if (object5 == null) {
            throw new IllegalArgumentException("No ftl file specified.");
        }
        object2 = new File((String)object3).getAbsoluteFile();
        object = new File((String)object5).getAbsoluteFile();
        if (!((File)object2).exists()) {
            throw new IllegalArgumentException("Input file does not exist: " + (String)object3);
        }
        if (!((File)object).exists()) {
            throw new IllegalArgumentException("FTL file does not exist: " + (String)object5);
        }
        if (!((File)object2).isFile() || !((File)object2).canRead()) {
            throw new IllegalArgumentException("Input file must be a readable file: " + (String)object3);
        }
        if (!((File)object).isFile() || !((File)object).canRead()) {
            throw new IllegalArgumentException("FTL file must be a readable file: " + (String)object5);
        }
        File file = null;
        if (!(object4 == null || ((File)(serializable = (file = new File((String)object4).getAbsoluteFile()).getParentFile())).exists() && ((File)serializable).canWrite())) {
            throw new IllegalArgumentException("The output directory must exist and be writable: " + serializable);
        }
        serializable = Locale.getDefault();
        if (object6 != null) {
            serializable = Transform.localeFromString((String)object6);
        }
        return new Transform((File)object2, (File)object, file, (Locale)serializable, (String)object7);
    }

    static Locale localeFromString(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = "";
        String string3 = "";
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_-,");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                }
            }
            return new Locale(string2, string3, string4);
        }
        return Locale.getDefault();
    }

    static void usage() {
        System.err.println("Usage: java freemarker.ext.dom.Transform -in <xmlfile> -ftl <ftlfile> [-out <outfile>] [-locale <locale>] [-encoding <encoding>]");
        System.exit(-1);
    }
}

