/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.core.Environment;
import freemarker.template.utility.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeOutputter {
    private Element contextNode;
    private Environment env;
    private String defaultNS;
    private boolean hasDefaultNS;
    private boolean explicitDefaultNSPrefix;
    private HashMap namespacesToPrefixLookup = new HashMap();
    private String namespaceDecl;

    NodeOutputter(Node node) {
        if (node instanceof Element) {
            this.setContext((Element)node);
        } else if (node instanceof Attr) {
            this.setContext(((Attr)node).getOwnerElement());
        } else if (node instanceof Document) {
            this.setContext(((Document)node).getDocumentElement());
        }
    }

    private void setContext(Element element) {
        this.contextNode = element;
        this.env = Environment.getCurrentEnvironment();
        this.defaultNS = this.env.getDefaultNS();
        this.hasDefaultNS = this.defaultNS != null && this.defaultNS.length() > 0;
        this.namespacesToPrefixLookup.put(null, "");
        this.namespacesToPrefixLookup.put("", "");
        this.buildPrefixLookup(element);
        if (!this.explicitDefaultNSPrefix && this.hasDefaultNS) {
            this.namespacesToPrefixLookup.put(this.defaultNS, "");
        }
        this.constructNamespaceDecl();
    }

    private void buildPrefixLookup(Node node) {
        Object object;
        String string = node.getNamespaceURI();
        if (string != null && string.length() > 0) {
            object = this.env.getPrefixForNamespace(string);
            this.namespacesToPrefixLookup.put(string, object);
        } else if (this.hasDefaultNS && node.getNodeType() == 1) {
            this.namespacesToPrefixLookup.put(this.defaultNS, "D");
            this.explicitDefaultNSPrefix = true;
        } else if (node.getNodeType() == 2 && this.hasDefaultNS && this.defaultNS.equals(string)) {
            this.namespacesToPrefixLookup.put(this.defaultNS, "D");
            this.explicitDefaultNSPrefix = true;
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            this.buildPrefixLookup(object.item(i));
        }
    }

    private void constructNamespaceDecl() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.explicitDefaultNSPrefix) {
            stringBuffer.append(" xmlns=\"");
            stringBuffer.append(this.defaultNS);
            stringBuffer.append("\"");
        }
        Iterator iterator = this.namespacesToPrefixLookup.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || string.length() == 0) continue;
            String string2 = (String)this.namespacesToPrefixLookup.get(string);
            if (string2 == null) {
                char[] cArray;
                for (int i = 0; i < 26 && this.env.getNamespaceForPrefix(string2 = new String(cArray = new char[]{(char)(97 + i)})) != null; ++i) {
                    string2 = null;
                }
                if (string2 == null) {
                    throw new RuntimeException("This will almost never happen!");
                }
                this.namespacesToPrefixLookup.put(string, string2);
            }
            stringBuffer.append(" xmlns");
            if (string2.length() > 0) {
                stringBuffer.append(":");
                stringBuffer.append(string2);
            }
            stringBuffer.append("=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        this.namespaceDecl = stringBuffer.toString();
    }

    private void outputQualifiedName(Node node, StringBuffer stringBuffer) {
        String string = node.getNamespaceURI();
        if (string == null || string.length() == 0) {
            stringBuffer.append(node.getNodeName());
        } else {
            String string2 = (String)this.namespacesToPrefixLookup.get(string);
            if (string2 == null) {
                stringBuffer.append(node.getNodeName());
            } else {
                if (string2.length() > 0) {
                    stringBuffer.append(string2);
                    stringBuffer.append(':');
                }
                stringBuffer.append(node.getLocalName());
            }
        }
    }

    void outputContent(Node node, StringBuffer stringBuffer) {
        switch (node.getNodeType()) {
            case 2: {
                if (!((Attr)node).getSpecified()) break;
                stringBuffer.append(' ');
                this.outputQualifiedName(node, stringBuffer);
                stringBuffer.append("=\"").append(StringUtil.XMLEncQAttr(node.getNodeValue())).append('\"');
                break;
            }
            case 8: {
                stringBuffer.append("<!--").append(node.getNodeValue()).append("-->");
                break;
            }
            case 9: {
                this.outputContent(node.getChildNodes(), stringBuffer);
                break;
            }
            case 10: {
                stringBuffer.append("<!DOCTYPE ").append(node.getNodeName());
                DocumentType documentType = (DocumentType)node;
                if (documentType.getPublicId() != null) {
                    stringBuffer.append(" PUBLIC \"").append(documentType.getPublicId()).append('\"');
                }
                if (documentType.getSystemId() != null) {
                    stringBuffer.append(" \"").append(documentType.getSystemId()).append('\"');
                }
                if (documentType.getInternalSubset() != null) {
                    stringBuffer.append(" [").append(documentType.getInternalSubset()).append(']');
                }
                stringBuffer.append('>');
                break;
            }
            case 1: {
                stringBuffer.append('<');
                this.outputQualifiedName(node, stringBuffer);
                if (node == this.contextNode) {
                    stringBuffer.append(this.namespaceDecl);
                }
                this.outputContent(node.getAttributes(), stringBuffer);
                NodeList nodeList = node.getChildNodes();
                if (nodeList.getLength() == 0) {
                    stringBuffer.append(" />");
                    break;
                }
                stringBuffer.append('>');
                this.outputContent(node.getChildNodes(), stringBuffer);
                stringBuffer.append("</");
                this.outputQualifiedName(node, stringBuffer);
                stringBuffer.append('>');
                break;
            }
            case 6: {
                this.outputContent(node.getChildNodes(), stringBuffer);
                break;
            }
            case 5: {
                stringBuffer.append('&').append(node.getNodeName()).append(';');
                break;
            }
            case 7: {
                stringBuffer.append("<?").append(node.getNodeName()).append(' ').append(node.getNodeValue()).append("?>");
                break;
            }
            case 3: 
            case 4: {
                stringBuffer.append(StringUtil.XMLEncNQG(node.getNodeValue()));
            }
        }
    }

    void outputContent(NodeList nodeList, StringBuffer stringBuffer) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.outputContent(nodeList.item(i), stringBuffer);
        }
    }

    void outputContent(NamedNodeMap namedNodeMap, StringBuffer stringBuffer) {
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (node.getNodeType() == 2 && (node.getNodeName().startsWith("xmlns:") || node.getNodeName().equals("xmlns"))) continue;
            this.outputContent(node, stringBuffer);
        }
    }

    String getOpeningTag(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        this.outputQualifiedName(element, stringBuffer);
        stringBuffer.append(this.namespaceDecl);
        this.outputContent(element.getAttributes(), stringBuffer);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    String getClosingTag(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("</");
        this.outputQualifiedName(element, stringBuffer);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }
}

