/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.ext.dom.AttributeNodeModel;
import freemarker.ext.dom.CharacterDataNodeModel;
import freemarker.ext.dom.DocumentModel;
import freemarker.ext.dom.DocumentTypeModel;
import freemarker.ext.dom.ElementModel;
import freemarker.ext.dom.NodeListModel;
import freemarker.ext.dom.NodeOutputter;
import freemarker.ext.dom.PINodeModel;
import freemarker.ext.dom.XPathSupport;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.log.Logger;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateSequenceModel;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class NodeModel
implements TemplateNodeModel,
TemplateHashModel,
TemplateSequenceModel,
AdapterTemplateModel,
WrapperTemplateModel {
    static final Logger logger = Logger.getLogger("freemarker.dom");
    private static DocumentBuilderFactory docBuilderFactory;
    private static Map xpathSupportMap;
    private static XPathSupport jaxenXPathSupport;
    private static ErrorHandler errorHandler;
    static Class xpathSupportClass;
    final Node node;
    private TemplateSequenceModel children;
    private NodeModel parent;
    static /* synthetic */ Class class$freemarker$ext$dom$XPathSupport;

    public static void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        docBuilderFactory = documentBuilderFactory;
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (docBuilderFactory == null) {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setIgnoringElementContentWhitespace(true);
        }
        return docBuilderFactory;
    }

    public static void setErrorHandler(ErrorHandler errorHandler) {
        NodeModel.errorHandler = errorHandler;
    }

    public static NodeModel parse(InputSource inputSource, boolean bl, boolean bl2) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder documentBuilder = NodeModel.getDocumentBuilderFactory().newDocumentBuilder();
        if (errorHandler != null) {
            documentBuilder.setErrorHandler(errorHandler);
        }
        Document document = documentBuilder.parse(inputSource);
        if (bl && bl2) {
            NodeModel.simplify(document);
        } else {
            if (bl) {
                NodeModel.removeComments(document);
            }
            if (bl2) {
                NodeModel.removePIs(document);
            }
            NodeModel.mergeAdjacentText(document);
        }
        return NodeModel.wrap(document);
    }

    public static NodeModel parse(InputSource inputSource) throws SAXException, IOException, ParserConfigurationException {
        return NodeModel.parse(inputSource, true, true);
    }

    public static NodeModel parse(File file, boolean bl, boolean bl2) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder documentBuilder = NodeModel.getDocumentBuilderFactory().newDocumentBuilder();
        if (errorHandler != null) {
            documentBuilder.setErrorHandler(errorHandler);
        }
        Document document = documentBuilder.parse(file);
        if (bl) {
            NodeModel.removeComments(document);
        }
        if (bl2) {
            NodeModel.removePIs(document);
        }
        NodeModel.mergeAdjacentText(document);
        return NodeModel.wrap(document);
    }

    public static NodeModel parse(File file) throws SAXException, IOException, ParserConfigurationException {
        return NodeModel.parse(file, true, true);
    }

    protected NodeModel(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public TemplateModel get(String string) throws TemplateModelException {
        XPathSupport xPathSupport;
        if (string.startsWith("@@")) {
            if (string.equals("@@text")) {
                return new SimpleScalar(NodeModel.getText(this.node));
            }
            if (string.equals("@@namespace")) {
                String string2 = this.node.getNamespaceURI();
                return string2 == null ? null : new SimpleScalar(string2);
            }
            if (string.equals("@@local_name")) {
                String string3 = this.node.getLocalName();
                if (string3 == null) {
                    string3 = this.getNodeName();
                }
                return new SimpleScalar(string3);
            }
            if (string.equals("@@markup")) {
                StringBuffer stringBuffer = new StringBuffer();
                NodeOutputter nodeOutputter = new NodeOutputter(this.node);
                nodeOutputter.outputContent(this.node, stringBuffer);
                return new SimpleScalar(stringBuffer.toString());
            }
            if (string.equals("@@nested_markup")) {
                StringBuffer stringBuffer = new StringBuffer();
                NodeOutputter nodeOutputter = new NodeOutputter(this.node);
                nodeOutputter.outputContent(this.node.getChildNodes(), stringBuffer);
                return new SimpleScalar(stringBuffer.toString());
            }
            if (string.equals("@@qname")) {
                String string4 = this.getQualifiedName();
                return string4 == null ? null : new SimpleScalar(string4);
            }
        }
        if ((xPathSupport = this.getXPathSupport()) != null) {
            return xPathSupport.executeQuery(this.node, string);
        }
        throw new TemplateModelException("Can't try to resolve the XML query key, because no XPath support is available. It's either malformed or an XPath expression: " + string);
    }

    public TemplateNodeModel getParentNode() {
        if (this.parent == null) {
            Node node = this.node.getParentNode();
            if (node == null && this.node instanceof Attr) {
                node = ((Attr)this.node).getOwnerElement();
            }
            this.parent = NodeModel.wrap(node);
        }
        return this.parent;
    }

    public TemplateSequenceModel getChildNodes() {
        if (this.children == null) {
            this.children = new NodeListModel(this.node.getChildNodes(), this);
        }
        return this.children;
    }

    public final String getNodeType() throws TemplateModelException {
        short s = this.node.getNodeType();
        switch (s) {
            case 2: {
                return "attribute";
            }
            case 4: {
                return "text";
            }
            case 8: {
                return "comment";
            }
            case 11: {
                return "document_fragment";
            }
            case 9: {
                return "document";
            }
            case 10: {
                return "document_type";
            }
            case 1: {
                return "element";
            }
            case 6: {
                return "entity";
            }
            case 5: {
                return "entity_reference";
            }
            case 12: {
                return "notation";
            }
            case 7: {
                return "pi";
            }
            case 3: {
                return "text";
            }
        }
        throw new TemplateModelException("Unknown node type: " + s + ". This should be impossible!");
    }

    public TemplateModel exec(List list) throws TemplateModelException {
        if (list.size() != 1) {
            throw new TemplateModelException("Expecting exactly one arguments");
        }
        String string = (String)list.get(0);
        XPathSupport xPathSupport = this.getXPathSupport();
        if (xPathSupport == null) {
            throw new TemplateModelException("No XPath support available");
        }
        return xPathSupport.executeQuery(this.node, string);
    }

    public final int size() {
        return 1;
    }

    public final TemplateModel get(int n) {
        return n == 0 ? this : null;
    }

    public String getNodeNamespace() {
        short s = this.node.getNodeType();
        if (s != 2 && s != 1) {
            return null;
        }
        String string = this.node.getNamespaceURI();
        if (string == null && s == 1) {
            string = "";
        } else if ("".equals(string) && s == 2) {
            string = null;
        }
        return string;
    }

    public final int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object.getClass() == this.getClass() && ((NodeModel)object).node.equals(this.node);
    }

    public static NodeModel wrap(Node node) {
        if (node == null) {
            return null;
        }
        NodeModel nodeModel = null;
        switch (node.getNodeType()) {
            case 9: {
                nodeModel = new DocumentModel((Document)node);
                break;
            }
            case 1: {
                nodeModel = new ElementModel((Element)node);
                break;
            }
            case 2: {
                nodeModel = new AttributeNodeModel((Attr)node);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                nodeModel = new CharacterDataNodeModel((CharacterData)node);
                break;
            }
            case 7: {
                nodeModel = new PINodeModel((ProcessingInstruction)node);
                break;
            }
            case 10: {
                nodeModel = new DocumentTypeModel((DocumentType)node);
            }
        }
        return nodeModel;
    }

    public static void removeComments(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node2 = nodeList.item(n);
            if (node2.hasChildNodes()) {
                NodeModel.removeComments(node2);
                ++n;
                continue;
            }
            if (node2.getNodeType() == 8) {
                node.removeChild(node2);
                --n2;
                continue;
            }
            ++n;
        }
    }

    public static void removePIs(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node2 = nodeList.item(n);
            if (node2.hasChildNodes()) {
                NodeModel.removePIs(node2);
                ++n;
                continue;
            }
            if (node2.getNodeType() == 7) {
                node.removeChild(node2);
                --n2;
                continue;
            }
            ++n;
        }
    }

    public static void mergeAdjacentText(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2 instanceof Text || node2 instanceof CDATASection) {
                Node node3 = node2.getNextSibling();
                if (!(node3 instanceof Text) && !(node3 instanceof CDATASection)) continue;
                String string = node2.getNodeValue() + node3.getNodeValue();
                ((CharacterData)node2).setData(string);
                node.removeChild(node3);
                continue;
            }
            NodeModel.mergeAdjacentText(node2);
        }
    }

    public static void simplify(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        Node node2 = null;
        while (n < n2) {
            Node node3 = nodeList.item(n);
            if (node3.hasChildNodes()) {
                NodeModel.simplify(node3);
                node2 = null;
                ++n;
                continue;
            }
            short s = node3.getNodeType();
            if (s == 7) {
                node.removeChild(node3);
                --n2;
                continue;
            }
            if (s == 8) {
                node.removeChild(node3);
                --n2;
                continue;
            }
            if (s == 3 || s == 4) {
                if (node2 != null) {
                    CharacterData characterData = (CharacterData)node2;
                    characterData.setData(characterData.getNodeValue() + node3.getNodeValue());
                    node.removeChild(node3);
                    --n2;
                    continue;
                }
                node2 = node3;
                ++n;
                continue;
            }
            node2 = null;
            ++n;
        }
    }

    NodeModel getDocumentNodeModel() {
        if (this.node instanceof Document) {
            return this;
        }
        return NodeModel.wrap(this.node.getOwnerDocument());
    }

    public static void useDefaultXPathSupport() {
        xpathSupportClass = null;
        jaxenXPathSupport = null;
        try {
            NodeModel.useXalanXPathSupport();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (xpathSupportClass == null) {
            try {
                NodeModel.useJaxenXPathSupport();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void useJaxenXPathSupport() throws Exception {
        Class.forName("org.jaxen.dom.DOMXPath");
        Class<?> clazz = Class.forName("freemarker.ext.dom.JaxenXPathSupport");
        jaxenXPathSupport = (XPathSupport)clazz.newInstance();
        if (logger.isDebugEnabled()) {
            logger.debug("Using Jaxen classes for XPath support");
        }
        xpathSupportClass = clazz;
    }

    public static void useXalanXPathSupport() throws Exception {
        Class.forName("org.apache.xpath.XPath");
        Class<?> clazz = Class.forName("freemarker.ext.dom.XalanXPathSupport");
        if (logger.isDebugEnabled()) {
            logger.debug("Using Xalan classes for XPath support");
        }
        xpathSupportClass = clazz;
    }

    public static void setXPathSupportClass(Class clazz) {
        if (clazz != null && !clazz.isAssignableFrom(class$freemarker$ext$dom$XPathSupport == null ? (class$freemarker$ext$dom$XPathSupport = NodeModel.class$("freemarker.ext.dom.XPathSupport")) : class$freemarker$ext$dom$XPathSupport)) {
            throw new RuntimeException("Class " + clazz.getName() + " does not implement freemarker.ext.dom.XPathSupport");
        }
        xpathSupportClass = clazz;
    }

    public static Class getXPathSupportClass() {
        return xpathSupportClass;
    }

    private static String getText(Node node) {
        String string = "";
        if (node instanceof Text || node instanceof CDATASection) {
            string = ((CharacterData)node).getData();
        } else if (node instanceof Element) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                string = string + NodeModel.getText(nodeList.item(i));
            }
        } else if (node instanceof Document) {
            string = NodeModel.getText(((Document)node).getDocumentElement());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XPathSupport getXPathSupport() {
        if (jaxenXPathSupport != null) {
            return jaxenXPathSupport;
        }
        XPathSupport xPathSupport = null;
        Document document = this.node.getOwnerDocument();
        if (document == null) {
            document = (Document)this.node;
        }
        Document document2 = document;
        synchronized (document2) {
            WeakReference weakReference = (WeakReference)xpathSupportMap.get(document);
            if (weakReference != null) {
                xPathSupport = (XPathSupport)weakReference.get();
            }
            if (xPathSupport == null) {
                try {
                    xPathSupport = (XPathSupport)xpathSupportClass.newInstance();
                    xpathSupportMap.put(document, new WeakReference<XPathSupport>(xPathSupport));
                }
                catch (Exception exception) {
                    logger.error("Error instantiating xpathSupport class");
                }
            }
        }
        return xPathSupport;
    }

    String getQualifiedName() throws TemplateModelException {
        return this.getNodeName();
    }

    public Object getAdaptedObject(Class clazz) {
        return this.node;
    }

    public Object getWrappedObject() {
        return this.node;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        xpathSupportMap = Collections.synchronizedMap(new WeakHashMap());
        try {
            NodeModel.useDefaultXPathSupport();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (xpathSupportClass == null && logger.isWarnEnabled()) {
            logger.warn("No XPath support is available.");
        }
    }
}

