/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.core.Environment;
import freemarker.ext.dom.ElementModel;
import freemarker.ext.dom.NodeModel;
import freemarker.ext.dom.XPathSupport;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeListModel
extends SimpleSequence
implements TemplateHashModel {
    NodeModel contextNode;
    XPathSupport xpathSupport;
    private static ObjectWrapper nodeWrapper = new ObjectWrapper(){

        public TemplateModel wrap(Object object) {
            if (object instanceof NodeModel) {
                return (NodeModel)object;
            }
            return NodeModel.wrap((Node)object);
        }
    };

    NodeListModel(Node node) {
        this(NodeModel.wrap(node));
    }

    NodeListModel(NodeModel nodeModel) {
        super(nodeWrapper);
        this.contextNode = nodeModel;
    }

    NodeListModel(NodeList nodeList, NodeModel nodeModel) {
        super(nodeWrapper);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.list.add(nodeList.item(i));
        }
        this.contextNode = nodeModel;
    }

    NodeListModel(NamedNodeMap namedNodeMap, NodeModel nodeModel) {
        super(nodeWrapper);
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            this.list.add(namedNodeMap.item(i));
        }
        this.contextNode = nodeModel;
    }

    NodeListModel(List list, NodeModel nodeModel) {
        super(list, nodeWrapper);
        this.contextNode = nodeModel;
    }

    NodeListModel filterByName(String string) throws TemplateModelException {
        NodeListModel nodeListModel = new NodeListModel(this.contextNode);
        int n = this.size();
        if (n == 0) {
            return nodeListModel;
        }
        Environment environment = Environment.getCurrentEnvironment();
        for (int i = 0; i < n; ++i) {
            NodeModel nodeModel = (NodeModel)this.get(i);
            if (!(nodeModel instanceof ElementModel) || !((ElementModel)nodeModel).matchesName(string, environment)) continue;
            nodeListModel.add(nodeModel);
        }
        return nodeListModel;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public TemplateModel get(String string) throws TemplateModelException {
        if (this.size() == 1) {
            NodeModel nodeModel = (NodeModel)this.get(0);
            return nodeModel.get(string);
        }
        if (string.equals("@@markup") || string.equals("@@nested_markup") || string.equals("@@text")) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.size(); ++i) {
                NodeModel nodeModel = (NodeModel)this.get(i);
                TemplateScalarModel templateScalarModel = (TemplateScalarModel)nodeModel.get(string);
                stringBuffer.append(templateScalarModel.getAsString());
            }
            return new SimpleScalar(stringBuffer.toString());
        }
        if (StringUtil.isXMLID(string) || string.startsWith("@") && StringUtil.isXMLID(string.substring(1)) || string.equals("*") || string.equals("**") || string.equals("@@") || string.equals("@*")) {
            NodeListModel nodeListModel = new NodeListModel(this.contextNode);
            for (int i = 0; i < this.size(); ++i) {
                NodeModel nodeModel = (NodeModel)this.get(i);
                if (!(nodeModel instanceof ElementModel)) continue;
                TemplateSequenceModel templateSequenceModel = (TemplateSequenceModel)((ElementModel)nodeModel).get(string);
                int n = templateSequenceModel == null ? 0 : templateSequenceModel.size();
                for (int j = 0; j < n; ++j) {
                    nodeListModel.add(templateSequenceModel.get(j));
                }
            }
            if (nodeListModel.size() == 1) {
                return nodeListModel.get(0);
            }
            return nodeListModel;
        }
        XPathSupport xPathSupport = this.getXPathSupport();
        if (xPathSupport != null) {
            List list = this.size() == 0 ? null : this.rawNodeList();
            return xPathSupport.executeQuery(list, string);
        }
        throw new TemplateModelException("Key: '" + string + "' is not legal for a node sequence (" + this.getClass().getName() + "). This node sequence contains " + this.size() + " node(s). " + "Some keys are valid only for node sequences of size 1. " + "If you use Xalan (instead of Jaxen), XPath expression keys work only with " + "node lists of size 1.");
    }

    private List rawNodeList() throws TemplateModelException {
        int n = this.size();
        ArrayList<Node> arrayList = new ArrayList<Node>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(((NodeModel)this.get((int)i)).node);
        }
        return arrayList;
    }

    XPathSupport getXPathSupport() throws TemplateModelException {
        if (this.xpathSupport == null) {
            if (this.contextNode != null) {
                this.xpathSupport = this.contextNode.getXPathSupport();
            } else if (this.size() > 0) {
                this.xpathSupport = ((NodeModel)this.get(0)).getXPathSupport();
            }
        }
        return this.xpathSupport;
    }
}

