/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.cache.TemplateCache;
import freemarker.core.CustomAttribute;
import freemarker.core.Environment;
import freemarker.ext.dom.NodeListModel;
import freemarker.ext.dom.XPathSupport;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.Collections12;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jaxen.BaseXPath;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.UnresolvableException;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom.DocumentNavigator;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class JaxenXPathSupport
implements XPathSupport {
    private static final CustomAttribute cache = new CustomAttribute(1){

        protected Object create() {
            return new HashMap();
        }
    };
    private static final ArrayList EMPTY_ARRAYLIST = new ArrayList();
    private static final NamespaceContext customNamespaceContext = new NamespaceContext(){

        public String translateNamespacePrefixToUri(String string) {
            if (string.equals("D")) {
                return Environment.getCurrentEnvironment().getDefaultNS();
            }
            return Environment.getCurrentEnvironment().getNamespaceForPrefix(string);
        }
    };
    private static final VariableContext fmVariableContext = new VariableContext(){

        public Object getVariableValue(String string, String string2, String string3) throws UnresolvableException {
            try {
                TemplateModel templateModel = Environment.getCurrentEnvironment().getVariable(string3);
                if (templateModel == null) {
                    throw new UnresolvableException("Variable " + string3 + " not found.");
                }
                if (templateModel instanceof TemplateScalarModel) {
                    return ((TemplateScalarModel)templateModel).getAsString();
                }
                if (templateModel instanceof TemplateNumberModel) {
                    return ((TemplateNumberModel)templateModel).getAsNumber();
                }
                if (templateModel instanceof TemplateDateModel) {
                    return ((TemplateDateModel)templateModel).getAsDate();
                }
                if (templateModel instanceof TemplateBooleanModel) {
                    return ((TemplateBooleanModel)templateModel).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            catch (TemplateModelException templateModelException) {
                throw new UndeclaredThrowableException(templateModelException);
            }
            throw new UnresolvableException("Variable " + string3 + " is not a string, number, date, or boolean");
        }
    };
    private static final FunctionContext fmFunctionContext = new XPathFunctionContext(){

        public Function getFunction(String string, String string2, String string3) throws UnresolvableException {
            try {
                return super.getFunction(string, string2, string3);
            }
            catch (UnresolvableException unresolvableException) {
                return super.getFunction(null, null, string3);
            }
        }
    };
    private static final CustomAttribute cachedTree = new CustomAttribute(1);
    private static final Navigator fmDomNavigator = new DocumentNavigator(){

        public Object getDocument(String string) throws FunctionCallException {
            try {
                Template template = JaxenXPathSupport.getTemplate(string);
                Document document = (Document)cachedTree.get(template);
                if (document == null) {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    FmEntityResolver fmEntityResolver = new FmEntityResolver();
                    documentBuilder.setEntityResolver(fmEntityResolver);
                    document = documentBuilder.parse(JaxenXPathSupport.createInputSource(null, template));
                    if (fmEntityResolver.getCallCount() == 0) {
                        cachedTree.set(document, template);
                    }
                }
                return document;
            }
            catch (Exception exception) {
                throw new FunctionCallException("Failed to parse document for URI: " + string, exception);
            }
        }
    };

    JaxenXPathSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateModel executeQuery(Object object, String string) throws TemplateModelException {
        try {
            BaseXPath baseXPath;
            Map map = (Map)cache.get();
            Object object2 = map;
            synchronized (object2) {
                baseXPath = (BaseXPath)map.get(string);
                if (baseXPath == null) {
                    baseXPath = new BaseXPath(string, fmDomNavigator);
                    baseXPath.setNamespaceContext(customNamespaceContext);
                    baseXPath.setFunctionContext(fmFunctionContext);
                    baseXPath.setVariableContext(fmVariableContext);
                    map.put(string, baseXPath);
                }
            }
            object2 = baseXPath.selectNodes(object != null ? object : EMPTY_ARRAYLIST);
            if (object2.size() == 1) {
                return ObjectWrapper.DEFAULT_WRAPPER.wrap(object2.get(0));
            }
            NodeListModel nodeListModel = new NodeListModel((List)object2, null);
            nodeListModel.xpathSupport = this;
            return nodeListModel;
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            Throwable throwable = undeclaredThrowableException.getUndeclaredThrowable();
            if (throwable instanceof TemplateModelException) {
                throw (TemplateModelException)throwable;
            }
            throw undeclaredThrowableException;
        }
        catch (JaxenException jaxenException) {
            throw new TemplateModelException((Exception)((Object)jaxenException));
        }
    }

    static Template getTemplate(String string) throws IOException {
        String string2;
        int n;
        Environment environment = Environment.getCurrentEnvironment();
        String string3 = environment.getTemplate().getEncoding();
        if (string3 == null) {
            string3 = environment.getConfiguration().getEncoding(environment.getLocale());
        }
        string2 = (n = (string2 = environment.getTemplate().getName()).lastIndexOf(47)) == -1 ? "" : string2.substring(0, n + 1);
        string = TemplateCache.getFullTemplatePath(environment, string2, string);
        Template template = environment.getConfiguration().getTemplate(string, environment.getLocale(), string3, false);
        return template;
    }

    private static InputSource createInputSource(String string, Template template) throws IOException, SAXException {
        StringWriter stringWriter = new StringWriter();
        try {
            template.process(Collections12.EMPTY_MAP, stringWriter);
        }
        catch (TemplateException templateException) {
            throw new SAXException(templateException);
        }
        InputSource inputSource = new InputSource();
        inputSource.setPublicId(string);
        inputSource.setSystemId(template.getName());
        inputSource.setCharacterStream(new StringReader(stringWriter.toString()));
        return inputSource;
    }

    private static class FmEntityResolver
    implements EntityResolver {
        private int callCount = 0;

        private FmEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            ++this.callCount;
            return JaxenXPathSupport.createInputSource(string, JaxenXPathSupport.getTemplate(string2));
        }

        int getCallCount() {
            return this.callCount;
        }
    }
}

