/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.core.Environment;
import freemarker.ext.dom.NodeListModel;
import freemarker.ext.dom.NodeModel;
import freemarker.ext.dom.NodeOutputter;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ElementModel
extends NodeModel
implements TemplateScalarModel {
    public ElementModel(Element element) {
        super(element);
    }

    public boolean isEmpty() {
        return false;
    }

    public TemplateModel get(String string) throws TemplateModelException {
        if (string.equals("*")) {
            NodeListModel nodeListModel = new NodeListModel(this);
            TemplateSequenceModel templateSequenceModel = this.getChildNodes();
            for (int i = 0; i < templateSequenceModel.size(); ++i) {
                NodeModel nodeModel = (NodeModel)templateSequenceModel.get(i);
                if (nodeModel.node.getNodeType() != 1) continue;
                nodeListModel.add(nodeModel);
            }
            return nodeListModel;
        }
        if (string.equals("**")) {
            Element element = (Element)this.node;
            return new NodeListModel(element.getElementsByTagName("*"), (NodeModel)this);
        }
        if (string.startsWith("@")) {
            if (string.equals("@@") || string.equals("@*")) {
                return new NodeListModel(this.node.getAttributes(), (NodeModel)this);
            }
            if (string.equals("@@start_tag")) {
                NodeOutputter nodeOutputter = new NodeOutputter(this.node);
                return new SimpleScalar(nodeOutputter.getOpeningTag((Element)this.node));
            }
            if (string.equals("@@end_tag")) {
                NodeOutputter nodeOutputter = new NodeOutputter(this.node);
                return new SimpleScalar(nodeOutputter.getClosingTag((Element)this.node));
            }
            if (string.equals("@@attributes_markup")) {
                StringBuffer stringBuffer = new StringBuffer();
                NodeOutputter nodeOutputter = new NodeOutputter(this.node);
                nodeOutputter.outputContent(this.node.getAttributes(), stringBuffer);
                return new SimpleScalar(stringBuffer.toString().trim());
            }
            if (StringUtil.isXMLID(string.substring(1))) {
                Attr attr = this.getAttribute(string.substring(1), Environment.getCurrentEnvironment());
                if (attr == null) {
                    return new NodeListModel(this);
                }
                return ElementModel.wrap(attr);
            }
        }
        if (StringUtil.isXMLID(string)) {
            NodeListModel nodeListModel = ((NodeListModel)this.getChildNodes()).filterByName(string);
            if (nodeListModel.size() == 1) {
                return nodeListModel.get(0);
            }
            return nodeListModel;
        }
        return super.get(string);
    }

    public String getAsString() throws TemplateModelException {
        NodeList nodeList = this.node.getChildNodes();
        String string = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short s = node.getNodeType();
            if (s == 1) {
                String string2 = "Only elements with no child elements can be processed as text.\nThis element with name \"" + this.node.getNodeName() + "\" has a child element named: " + node.getNodeName();
                throw new TemplateModelException(string2);
            }
            if (s != 3 && s != 4) continue;
            string = string + node.getNodeValue();
        }
        return string;
    }

    public String getNodeName() {
        String string = this.node.getLocalName();
        if (string == null || string.equals("")) {
            string = this.node.getNodeName();
        }
        return string;
    }

    String getQualifiedName() {
        String string = this.getNodeName();
        String string2 = this.getNodeNamespace();
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        Environment environment = Environment.getCurrentEnvironment();
        String string3 = environment.getDefaultNS();
        String string4 = string3 != null && string3.equals(string2) ? "D" : environment.getPrefixForNamespace(string2);
        if (string4 == null) {
            return null;
        }
        if (string4.length() > 0) {
            string4 = string4 + ":";
        }
        return string4 + string;
    }

    private Attr getAttribute(String string, Environment environment) {
        Element element = (Element)this.node;
        Attr attr = element.getAttributeNode(string);
        if (attr != null) {
            return attr;
        }
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string2.equals("D") ? Environment.getCurrentEnvironment().getDefaultNS() : Environment.getCurrentEnvironment().getNamespaceForPrefix(string2);
            String string4 = string.substring(1 + n);
            if (string3 != null) {
                attr = element.getAttributeNodeNS(string3, string4);
            }
        }
        return attr;
    }

    boolean matchesName(String string, Environment environment) {
        return StringUtil.matchesName(string, this.getNodeName(), this.getNodeNamespace(), environment);
    }
}

