/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.core.Environment;
import freemarker.ext.dom.ElementModel;
import freemarker.ext.dom.NodeListModel;
import freemarker.ext.dom.NodeModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

class DocumentModel
extends NodeModel
implements TemplateHashModel {
    private ElementModel rootElement;

    DocumentModel(Document document) {
        super(document);
    }

    public String getNodeName() {
        return "@document";
    }

    public TemplateModel get(String string) throws TemplateModelException {
        if (string.equals("*")) {
            return this.getRootElement();
        }
        if (string.equals("**")) {
            NodeList nodeList = ((Document)this.node).getElementsByTagName("*");
            return new NodeListModel(nodeList, (NodeModel)this);
        }
        if (StringUtil.isXMLID(string)) {
            ElementModel elementModel = (ElementModel)NodeModel.wrap(((Document)this.node).getDocumentElement());
            if (elementModel.matchesName(string, Environment.getCurrentEnvironment())) {
                return elementModel;
            }
            return new NodeListModel(this);
        }
        return super.get(string);
    }

    ElementModel getRootElement() {
        if (this.rootElement == null) {
            this.rootElement = (ElementModel)DocumentModel.wrap(((Document)this.node).getDocumentElement());
        }
        return this.rootElement;
    }

    public boolean isEmpty() {
        return false;
    }
}

