/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MethodMap;
import freemarker.ext.beans.OverloadedMethodModel;
import freemarker.ext.beans.SimpleMethodModel;
import freemarker.log.Logger;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class StaticModel
implements TemplateHashModelEx {
    private static final Logger logger = Logger.getLogger("freemarker.beans");
    private final Class clazz;
    private final BeansWrapper wrapper;
    private final Map map = new HashMap();

    StaticModel(Class clazz, BeansWrapper beansWrapper) throws TemplateModelException {
        this.clazz = clazz;
        this.wrapper = beansWrapper;
        this.populate();
    }

    public TemplateModel get(String string) throws TemplateModelException {
        Object v = this.map.get(string);
        if (v instanceof TemplateModel) {
            return (TemplateModel)v;
        }
        if (v instanceof Field) {
            try {
                return this.wrapper.getOuterIdentity().wrap(((Field)v).get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TemplateModelException("Illegal access for field " + string + " of class " + this.clazz.getName());
            }
        }
        throw new TemplateModelException("No such key: " + string + " in class " + this.clazz.getName());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.getOuterIdentity().wrap(this.map.keySet());
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.getOuterIdentity().wrap(this.map.values());
    }

    private void populate() throws TemplateModelException {
        if (!Modifier.isPublic(this.clazz.getModifiers())) {
            throw new TemplateModelException("Can't wrap the non-public class " + this.clazz.getName());
        }
        if (this.wrapper.getExposureLevel() == 3) {
            return;
        }
        Field[] fieldArray = this.clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if (!Modifier.isPublic(n) || !Modifier.isStatic(n)) continue;
            if (Modifier.isFinal(n)) {
                try {
                    this.map.put(field.getName(), this.wrapper.getOuterIdentity().wrap(field.get(null)));
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            this.map.put(field.getName(), field);
        }
        if (this.wrapper.getExposureLevel() < 2) {
            Object object;
            Method[] methodArray = this.clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                MethodMap methodMap;
                Method method = methodArray[i];
                int n = method.getModifiers();
                if (!Modifier.isPublic(n) || !Modifier.isStatic(n) || !this.wrapper.isSafeMethod(method)) continue;
                object = method.getName();
                Object v = this.map.get(object);
                if (v instanceof Method) {
                    methodMap = new MethodMap((String)object);
                    methodMap.addMethod((Method)v);
                    methodMap.addMethod(method);
                    this.map.put(object, methodMap);
                    continue;
                }
                if (v instanceof MethodMap) {
                    methodMap = (MethodMap)v;
                    methodMap.addMethod(method);
                    continue;
                }
                if (v != null) {
                    logger.info("Overwriting value [" + v + "] for " + " key '" + (String)object + "' with [" + method + "] in static model for " + this.clazz.getName());
                }
                this.map.put(object, method);
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object v = entry.getValue();
                if (v instanceof Method) {
                    object = (Method)v;
                    entry.setValue(new SimpleMethodModel(null, (Method)object, ((Method)object).getParameterTypes(), this.wrapper));
                    continue;
                }
                if (!(v instanceof MethodMap)) continue;
                entry.setValue(new OverloadedMethodModel(null, (MethodMap)v, this.wrapper));
            }
        }
    }
}

