/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.StringModel;
import freemarker.ext.util.ModelFactory;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class ResourceBundleModel
extends BeanModel
implements TemplateMethodModelEx {
    static final ModelFactory FACTORY = new ModelFactory(){

        public TemplateModel create(Object object, ObjectWrapper objectWrapper) {
            return new ResourceBundleModel((ResourceBundle)object, (BeansWrapper)objectWrapper);
        }
    };
    private Hashtable formats = null;

    public ResourceBundleModel(ResourceBundle resourceBundle, BeansWrapper beansWrapper) {
        super(resourceBundle, beansWrapper);
    }

    protected TemplateModel invokeGenericGet(Map map, Class clazz, String string) throws TemplateModelException {
        try {
            return this.wrap(((ResourceBundle)this.object).getObject(string));
        }
        catch (MissingResourceException missingResourceException) {
            throw new TemplateModelException("No such key: " + string);
        }
    }

    public boolean isEmpty() {
        return !((ResourceBundle)this.object).getKeys().hasMoreElements() && super.isEmpty();
    }

    public int size() {
        return this.keySet().size();
    }

    protected Set keySet() {
        Set set = super.keySet();
        Enumeration<String> enumeration = ((ResourceBundle)this.object).getKeys();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    public Object exec(List list) throws TemplateModelException {
        if (list.size() < 1) {
            throw new TemplateModelException("No message key was specified");
        }
        Iterator iterator = list.iterator();
        String string = this.unwrap((TemplateModel)iterator.next()).toString();
        try {
            if (!iterator.hasNext()) {
                return this.wrap(((ResourceBundle)this.object).getObject(string));
            }
            int n = list.size() - 1;
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.unwrap((TemplateModel)iterator.next());
            }
            return new StringModel(this.format(string, objectArray), this.wrapper);
        }
        catch (MissingResourceException missingResourceException) {
            throw new TemplateModelException("No such key: " + string);
        }
        catch (Exception exception) {
            throw new TemplateModelException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(String string, Object[] objectArray) throws MissingResourceException {
        if (this.formats == null) {
            this.formats = new Hashtable();
        }
        MessageFormat messageFormat = null;
        messageFormat = (MessageFormat)this.formats.get(string);
        if (messageFormat == null) {
            messageFormat = new MessageFormat(((ResourceBundle)this.object).getString(string));
            messageFormat.setLocale(this.getBundle().getLocale());
            this.formats.put(string, messageFormat);
        }
        MessageFormat messageFormat2 = messageFormat;
        synchronized (messageFormat2) {
            return messageFormat.format(objectArray);
        }
    }

    public ResourceBundle getBundle() {
        return (ResourceBundle)this.object;
    }
}

