/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.template.TemplateModelException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MethodMap {
    private static final Class BIGDECIMAL_CLASS = class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = MethodMap.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
    private static final Class NUMBER_CLASS = class$java$lang$Number == null ? (class$java$lang$Number = MethodMap.class$("java.lang.Number")) : class$java$lang$Number;
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class OBJECT_CLASS = class$java$lang$Object == null ? (class$java$lang$Object = MethodMap.class$("java.lang.Object")) : class$java$lang$Object;
    private static final ClassString EMPTY_STRING = new ClassString(EMPTY_ARGS);
    private static final Object NO_SUCH_METHOD = new Object();
    private static final Object AMBIGUOUS_METHOD = new Object();
    private final String name;
    private final Map selectorCache = new HashMap();
    private Class[][] unwrapTypes;
    private final List methods = new LinkedList();
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    MethodMap(String string) {
        this.name = string;
    }

    void addMethod(Method method) {
        this.methods.add(method);
        this.updateUnwrapTypes(method.getParameterTypes());
    }

    void addConstructor(Constructor constructor) {
        this.methods.add(constructor);
        this.updateUnwrapTypes(constructor.getParameterTypes());
    }

    private void updateUnwrapTypes(Class[] classArray) {
        int n = classArray.length - 1;
        if (n == -1) {
            return;
        }
        if (this.unwrapTypes == null) {
            this.unwrapTypes = new Class[n + 1][];
            this.unwrapTypes[n] = classArray;
        } else if (this.unwrapTypes.length <= n) {
            Class[][] classArrayArray = new Class[n + 1][];
            System.arraycopy(this.unwrapTypes, 0, classArrayArray, 0, this.unwrapTypes.length);
            this.unwrapTypes = classArrayArray;
            this.unwrapTypes[n] = classArray;
        } else {
            Class[] classArray2 = this.unwrapTypes[n];
            if (classArray2 == null) {
                this.unwrapTypes[n] = classArray;
            } else {
                for (int i = 0; i < classArray2.length; ++i) {
                    classArray2[i] = MethodMap.getMostSpecificCommonType(classArray2[i], classArray[i]);
                }
            }
        }
    }

    String getName() {
        return this.name;
    }

    Class[] getUnwrapTypes(List list) throws TemplateModelException {
        Class[] classArray;
        int n = list.size() - 1;
        if (n == -1) {
            return EMPTY_STRING.getClasses();
        }
        if (n < this.unwrapTypes.length && (classArray = this.unwrapTypes[n]) != null) {
            return classArray;
        }
        throw new TemplateModelException("No signature of method " + this.name + " accepts " + (n + 1) + " arguments");
    }

    AccessibleObject getMostSpecific(Object[] objectArray) throws TemplateModelException {
        ClassString classString = null;
        classString = objectArray == null ? EMPTY_STRING : new ClassString(objectArray);
        Map map = this.selectorCache;
        synchronized (map) {
            Object object = this.selectorCache.get(classString);
            if (object == null) {
                object = classString.getMostSpecific(this.methods);
                this.selectorCache.put(classString, object);
            }
            if (object instanceof AccessibleObject) {
                return (AccessibleObject)object;
            }
            if (object == NO_SUCH_METHOD) {
                throw new TemplateModelException("No signature of method " + this.name + " matches " + classString.listArgumentTypes());
            }
            throw new TemplateModelException("Multiple signatures of method " + this.name + " match " + classString.listArgumentTypes());
        }
    }

    private static boolean isMoreSpecific(Class clazz, Class clazz2) {
        if (clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz2.isPrimitive()) {
            if (clazz2 == Short.TYPE && clazz == Byte.TYPE) {
                return true;
            }
            if (clazz2 == Integer.TYPE && (clazz == Short.TYPE || clazz == Byte.TYPE)) {
                return true;
            }
            if (clazz2 == Long.TYPE && (clazz == Integer.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE)) {
                return true;
            }
            if (clazz2 == Float.TYPE && (clazz == Long.TYPE || clazz == Integer.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE)) {
                return true;
            }
            if (clazz2 == Double.TYPE && (clazz == Float.TYPE || clazz == Long.TYPE || clazz == Integer.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE)) {
                return true;
            }
        }
        return MethodMap.isBigDecimalConvertible(clazz2, clazz);
    }

    private static boolean isBigDecimalConvertible(Class clazz, Class clazz2) {
        if (BIGDECIMAL_CLASS.isAssignableFrom(clazz2)) {
            if (NUMBER_CLASS.isAssignableFrom(clazz)) {
                return true;
            }
            if (clazz.isPrimitive() && clazz != Boolean.TYPE && clazz != Character.TYPE) {
                return true;
            }
        }
        return false;
    }

    private static Class getMostSpecificCommonType(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return clazz;
        }
        if (clazz2.isPrimitive()) {
            if (clazz2 == Byte.TYPE) {
                clazz2 = class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte;
            } else if (clazz2 == Short.TYPE) {
                clazz2 = class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short;
            } else if (clazz2 == Character.TYPE) {
                clazz2 = class$java$lang$Character == null ? (class$java$lang$Character = MethodMap.class$("java.lang.Character")) : class$java$lang$Character;
            } else if (clazz2 == Integer.TYPE) {
                clazz2 = class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer;
            } else if (clazz2 == Float.TYPE) {
                clazz2 = class$java$lang$Float == null ? (class$java$lang$Float = MethodMap.class$("java.lang.Float")) : class$java$lang$Float;
            } else if (clazz2 == Long.TYPE) {
                clazz2 = class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long;
            } else if (clazz2 == Double.TYPE) {
                clazz2 = class$java$lang$Double == null ? (class$java$lang$Double = MethodMap.class$("java.lang.Double")) : class$java$lang$Double;
            }
        }
        Set set = MethodMap.getAssignables(clazz, clazz2);
        Set set2 = MethodMap.getAssignables(clazz2, clazz);
        set.retainAll(set2);
        if (set.isEmpty()) {
            return class$java$lang$Object == null ? (class$java$lang$Object = MethodMap.class$("java.lang.Object")) : class$java$lang$Object;
        }
        ArrayList<Class> arrayList = new ArrayList<Class>();
        Iterator iterator = set.iterator();
        block0: while (iterator.hasNext()) {
            Class clazz3 = (Class)iterator.next();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                Class clazz4 = (Class)iterator2.next();
                if (MethodMap.isMoreSpecific(clazz4, clazz3)) continue block0;
                if (!MethodMap.isMoreSpecific(clazz3, clazz4)) continue;
                iterator2.remove();
            }
            arrayList.add(clazz3);
        }
        if (arrayList.size() > 1) {
            return OBJECT_CLASS;
        }
        return (Class)arrayList.get(0);
    }

    private static Set getAssignables(Class clazz, Class clazz2) {
        HashSet hashSet = new HashSet();
        MethodMap.collectAssignables(clazz, clazz2, hashSet);
        return hashSet;
    }

    private static void collectAssignables(Class clazz, Class clazz2, Set set) {
        Class clazz3;
        if (clazz.isAssignableFrom(clazz2)) {
            set.add(clazz);
        }
        if ((clazz3 = clazz.getSuperclass()) != null) {
            MethodMap.collectAssignables(clazz3, clazz2, set);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            MethodMap.collectAssignables(classArray[i], clazz2, set);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ClassString {
        private final Class[] classes;
        private static final int MORE_SPECIFIC = 0;
        private static final int LESS_SPECIFIC = 1;
        private static final int INDETERMINATE = 2;

        ClassString(Object[] objectArray) {
            int n = objectArray.length;
            this.classes = new Class[n];
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                this.classes[i] = object == null ? OBJECT_CLASS : object.getClass();
            }
        }

        Class[] getClasses() {
            return this.classes;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.classes.length; ++i) {
                n ^= this.classes[i].hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof ClassString) {
                ClassString classString = (ClassString)object;
                if (classString.classes.length != this.classes.length) {
                    return false;
                }
                for (int i = 0; i < this.classes.length; ++i) {
                    if (classString.classes[i] == this.classes[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        Object getMostSpecific(List list) {
            LinkedList linkedList = this.getApplicables(list);
            if (linkedList.isEmpty()) {
                return NO_SUCH_METHOD;
            }
            if (linkedList.size() == 1) {
                return linkedList.getFirst();
            }
            LinkedList linkedList2 = new LinkedList();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Class[] classArray = ClassString.getParameterTypes(e);
                boolean bl = false;
                Iterator iterator2 = linkedList2.iterator();
                while (!bl && iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    switch (ClassString.moreSpecific(classArray, ClassString.getParameterTypes(e2))) {
                        case 0: {
                            iterator2.remove();
                            break;
                        }
                        case 1: {
                            bl = true;
                        }
                    }
                }
                if (bl) continue;
                linkedList2.addLast(e);
            }
            if (linkedList2.size() > 1) {
                return AMBIGUOUS_METHOD;
            }
            return linkedList2.getFirst();
        }

        private static Class[] getParameterTypes(Object object) {
            if (object instanceof Method) {
                return ((Method)object).getParameterTypes();
            }
            if (object instanceof Constructor) {
                return ((Constructor)object).getParameterTypes();
            }
            throw new Error();
        }

        private static int moreSpecific(Class[] classArray, Class[] classArray2) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == classArray2[i]) continue;
                bl = bl || MethodMap.isMoreSpecific(classArray[i], classArray2[i]);
                bl2 = bl2 || MethodMap.isMoreSpecific(classArray2[i], classArray[i]);
            }
            if (bl) {
                if (bl2) {
                    return 2;
                }
                return 0;
            }
            if (bl2) {
                return 1;
            }
            return 2;
        }

        LinkedList getApplicables(List list) {
            LinkedList linkedList = new LinkedList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!this.isApplicable(e)) continue;
                linkedList.add(e);
            }
            return linkedList;
        }

        private boolean isApplicable(Object object) {
            Class[] classArray = ClassString.getParameterTypes(object);
            if (classArray.length != this.classes.length) {
                return false;
            }
            for (int i = 0; i < this.classes.length; ++i) {
                if (ClassString.isMethodInvocationConvertible(classArray[i], this.classes[i])) continue;
                return false;
            }
            return true;
        }

        private static boolean isMethodInvocationConvertible(Class clazz, Class clazz2) {
            if (clazz.isAssignableFrom(clazz2)) {
                return true;
            }
            if (clazz.isPrimitive()) {
                if (clazz == Boolean.TYPE && clazz2 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodMap.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return true;
                }
                if (clazz == Character.TYPE && clazz2 == (class$java$lang$Character == null ? (class$java$lang$Character = MethodMap.class$("java.lang.Character")) : class$java$lang$Character)) {
                    return true;
                }
                if (clazz == Byte.TYPE && clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    return true;
                }
                if (clazz == Short.TYPE && (clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                    return true;
                }
                if (clazz == Integer.TYPE && (clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                    return true;
                }
                if (clazz == Long.TYPE && (clazz2 == (class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long) || clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                    return true;
                }
                if (clazz == Float.TYPE && (clazz2 == (class$java$lang$Float == null ? (class$java$lang$Float = MethodMap.class$("java.lang.Float")) : class$java$lang$Float) || clazz2 == (class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long) || clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                    return true;
                }
                if (clazz == Double.TYPE && (clazz2 == (class$java$lang$Double == null ? (class$java$lang$Double = MethodMap.class$("java.lang.Double")) : class$java$lang$Double) || clazz2 == (class$java$lang$Float == null ? (class$java$lang$Float = MethodMap.class$("java.lang.Float")) : class$java$lang$Float) || clazz2 == (class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long) || clazz2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz2 == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || clazz2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                    return true;
                }
            }
            return MethodMap.isBigDecimalConvertible(clazz, clazz2);
        }

        private String listArgumentTypes() {
            StringBuffer stringBuffer = new StringBuffer(this.classes.length * 32).append('(');
            for (int i = 0; i < this.classes.length; ++i) {
                stringBuffer.append(this.classes[i].getName()).append(',');
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            return stringBuffer.append(')').toString();
        }
    }
}

