/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.ArrayModel;
import freemarker.ext.beans.BooleanModel;
import freemarker.ext.beans.ClassBasedModelFactory;
import freemarker.ext.beans.CollectionAdapter;
import freemarker.ext.beans.CollectionModel;
import freemarker.ext.beans.DateModel;
import freemarker.ext.beans.EnumerationModel;
import freemarker.ext.beans.HashAdapter;
import freemarker.ext.beans.IteratorModel;
import freemarker.ext.beans.MapModel;
import freemarker.ext.beans.MethodMap;
import freemarker.ext.beans.NumberModel;
import freemarker.ext.beans.ResourceBundleModel;
import freemarker.ext.beans.SequenceAdapter;
import freemarker.ext.beans.SetAdapter;
import freemarker.ext.beans.SimpleMapModel;
import freemarker.ext.beans.StaticModels;
import freemarker.ext.beans.StringModel;
import freemarker.ext.util.IdentityHashMap;
import freemarker.ext.util.ModelCache;
import freemarker.ext.util.ModelFactory;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.log.Logger;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelAdapter;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.Collections12;
import freemarker.template.utility.SecurityUtilities;
import freemarker.template.utility.UndeclaredThrowableException;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class BeansWrapper
implements ObjectWrapper {
    private static final Class BIGINTEGER_CLASS;
    private static final Class BOOLEAN_CLASS;
    private static final Class CHARACTER_CLASS;
    private static final Class COLLECTION_CLASS;
    private static final Class DATE_CLASS;
    private static final Class HASHADAPTER_CLASS;
    private static final Class ITERABLE_CLASS;
    private static final Class LIST_CLASS;
    private static final Class MAP_CLASS;
    private static final Class NUMBER_CLASS;
    private static final Class OBJECT_CLASS;
    private static final Class SEQUENCEADAPTER_CLASS;
    private static final Class SET_CLASS;
    private static final Class SETADAPTER_CLASS;
    private static final Class STRING_CLASS;
    private static final boolean DEVELOPMENT;
    private static final Constructor ENUMS_MODEL_CTOR;
    private static final Logger logger;
    private static final Set UNSAFE_METHODS;
    static final Object GENERIC_GET_KEY;
    private static final Object CONSTRUCTORS;
    private static final Object ARGTYPES;
    private static final BeansWrapper INSTANCE;
    private final Map classCache = new HashMap();
    private Set cachedClassNames = new HashSet();
    private final StaticModels staticModels = new StaticModels(this);
    private final ClassBasedModelFactory enumModels = BeansWrapper.createEnumModels(this);
    private final ModelCache modelCache = new ModelCache(this);
    private final BooleanModel FALSE = new BooleanModel(Boolean.FALSE, this);
    private final BooleanModel TRUE = new BooleanModel(Boolean.TRUE, this);
    public static final int EXPOSE_ALL = 0;
    public static final int EXPOSE_SAFE = 1;
    public static final int EXPOSE_PROPERTIES_ONLY = 2;
    public static final int EXPOSE_NOTHING = 3;
    private int exposureLevel = 1;
    private TemplateModel nullModel = null;
    private boolean methodsShadowItems = true;
    private boolean exposeFields = false;
    private int defaultDateType = 0;
    private ObjectWrapper outerIdentity = this;
    private boolean simpleMapWrapper;
    private boolean strict = false;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$freemarker$ext$beans$HashAdapter;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$freemarker$ext$beans$SequenceAdapter;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$freemarker$ext$beans$SetAdapter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$freemarker$ext$beans$BeansWrapper;

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public void setOuterIdentity(ObjectWrapper objectWrapper) {
        this.outerIdentity = objectWrapper;
    }

    public ObjectWrapper getOuterIdentity() {
        return this.outerIdentity;
    }

    public void setSimpleMapWrapper(boolean bl) {
        this.simpleMapWrapper = bl;
    }

    public boolean isSimpleMapWrapper() {
        return this.simpleMapWrapper;
    }

    public void setExposureLevel(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Illegal exposure level " + n);
        }
        this.exposureLevel = n;
    }

    int getExposureLevel() {
        return this.exposureLevel;
    }

    public void setExposeFields(boolean bl) {
        this.exposeFields = bl;
    }

    public boolean isExposeFields() {
        return this.exposeFields;
    }

    public synchronized void setMethodsShadowItems(boolean bl) {
        this.methodsShadowItems = bl;
    }

    boolean isMethodsShadowItems() {
        return this.methodsShadowItems;
    }

    public synchronized void setDefaultDateType(int n) {
        this.defaultDateType = n;
    }

    protected int getDefaultDateType() {
        return this.defaultDateType;
    }

    public void setUseCache(boolean bl) {
        this.modelCache.setUseCache(bl);
    }

    public void setNullModel(TemplateModel templateModel) {
        this.nullModel = templateModel;
    }

    public static final BeansWrapper getDefaultInstance() {
        return INSTANCE;
    }

    public TemplateModel wrap(Object object) throws TemplateModelException {
        if (object == null) {
            return this.nullModel;
        }
        if (object instanceof TemplateModel) {
            return (TemplateModel)object;
        }
        if (object instanceof TemplateModelAdapter) {
            return ((TemplateModelAdapter)object).getTemplateModel();
        }
        if (object instanceof Map) {
            return this.modelCache.getInstance(object, this.simpleMapWrapper ? SimpleMapModel.FACTORY : MapModel.FACTORY);
        }
        if (object instanceof Collection) {
            return this.modelCache.getInstance(object, CollectionModel.FACTORY);
        }
        if (object.getClass().isArray()) {
            return this.modelCache.getInstance(object, ArrayModel.FACTORY);
        }
        if (object instanceof Number) {
            return this.modelCache.getInstance(object, NumberModel.FACTORY);
        }
        if (object instanceof Date) {
            return this.modelCache.getInstance(object, DateModel.FACTORY);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? this.TRUE : this.FALSE;
        }
        if (object instanceof ResourceBundle) {
            return this.modelCache.getInstance(object, ResourceBundleModel.FACTORY);
        }
        if (object instanceof Iterator) {
            return new IteratorModel((Iterator)object, this);
        }
        if (object instanceof Enumeration) {
            return new EnumerationModel((Enumeration)object, this);
        }
        return this.modelCache.getInstance(object, StringModel.FACTORY);
    }

    protected TemplateModel getInstance(Object object, ModelFactory modelFactory) {
        return this.modelCache.getInstance(object, modelFactory);
    }

    protected TemplateModel create(Object object, Object object2) {
        return ((ModelFactory)object2).create(object, this);
    }

    public Object unwrap(TemplateModel templateModel) throws TemplateModelException {
        return this.unwrap(templateModel, OBJECT_CLASS);
    }

    public Object unwrap(TemplateModel templateModel, Class clazz) throws TemplateModelException {
        return this.unwrap(templateModel, clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unwrap(TemplateModel templateModel, Class clazz, Map map) throws TemplateModelException {
        Serializable serializable;
        Object object;
        boolean bl;
        if (templateModel == this.nullModel) {
            return null;
        }
        boolean bl2 = Boolean.TYPE == clazz;
        boolean bl3 = bl = Character.TYPE == clazz;
        if (templateModel instanceof AdapterTemplateModel) {
            object = ((AdapterTemplateModel)templateModel).getAdaptedObject(clazz);
            if (clazz.isInstance(object)) {
                return object;
            }
            if (object instanceof Number && (clazz.isPrimitive() && !bl && !bl2 || NUMBER_CLASS.isAssignableFrom(clazz)) && (serializable = BeansWrapper.convertUnwrappedNumber(clazz, (Number)object)) != null) {
                return serializable;
            }
        }
        if (templateModel instanceof WrapperTemplateModel) {
            object = ((WrapperTemplateModel)templateModel).getWrappedObject();
            if (clazz.isInstance(object)) {
                return object;
            }
            if (object instanceof Number && (clazz.isPrimitive() && !bl && !bl2 || NUMBER_CLASS.isAssignableFrom(clazz)) && (serializable = BeansWrapper.convertUnwrappedNumber(clazz, (Number)object)) != null) {
                return serializable;
            }
        }
        if (STRING_CLASS == clazz) {
            if (templateModel instanceof TemplateScalarModel) {
                return ((TemplateScalarModel)templateModel).getAsString();
            }
            throw BeansWrapper.canNotConvert(templateModel, clazz);
        }
        if ((clazz.isPrimitive() && !bl && !bl2 || NUMBER_CLASS.isAssignableFrom(clazz)) && templateModel instanceof TemplateNumberModel && (object = BeansWrapper.convertUnwrappedNumber(clazz, ((TemplateNumberModel)templateModel).getAsNumber())) != null) {
            return object;
        }
        if (bl2 || BOOLEAN_CLASS == clazz) {
            if (templateModel instanceof TemplateBooleanModel) {
                return ((TemplateBooleanModel)templateModel).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            throw BeansWrapper.canNotConvert(templateModel, clazz);
        }
        if (MAP_CLASS == clazz && templateModel instanceof TemplateHashModel) {
            return new HashAdapter((TemplateHashModel)templateModel, this);
        }
        if (LIST_CLASS == clazz && templateModel instanceof TemplateSequenceModel) {
            return new SequenceAdapter((TemplateSequenceModel)templateModel, this);
        }
        if (SET_CLASS == clazz && templateModel instanceof TemplateCollectionModel) {
            return new SetAdapter((TemplateCollectionModel)templateModel, this);
        }
        if (COLLECTION_CLASS == clazz || ITERABLE_CLASS == clazz) {
            if (templateModel instanceof TemplateCollectionModel) {
                return new CollectionAdapter((TemplateCollectionModel)templateModel, this);
            }
            if (templateModel instanceof TemplateSequenceModel) {
                return new SequenceAdapter((TemplateSequenceModel)templateModel, this);
            }
        }
        if (clazz.isArray()) {
            if (templateModel instanceof TemplateSequenceModel) {
                if (map != null) {
                    object = map.get(templateModel);
                    if (object != null) {
                        return object;
                    }
                } else {
                    map = new IdentityHashMap();
                }
                object = (TemplateSequenceModel)templateModel;
                serializable = clazz.getComponentType();
                Object object2 = Array.newInstance(serializable, object.size());
                map.put(templateModel, object2);
                try {
                    int n = object.size();
                    for (int i = 0; i < n; ++i) {
                        Array.set(object2, i, this.unwrap(templateModel, (Class)serializable, map));
                    }
                }
                finally {
                    map.remove(templateModel);
                }
                return object2;
            }
            throw BeansWrapper.canNotConvert(templateModel, clazz);
        }
        if (bl || clazz == CHARACTER_CLASS) {
            if (templateModel instanceof TemplateScalarModel && ((String)(object = ((TemplateScalarModel)templateModel).getAsString())).length() == 1) {
                return new Character(((String)object).charAt(0));
            }
            throw BeansWrapper.canNotConvert(templateModel, clazz);
        }
        if (DATE_CLASS.isAssignableFrom(clazz) && templateModel instanceof TemplateDateModel && clazz.isInstance(object = ((TemplateDateModel)templateModel).getAsDate())) {
            return object;
        }
        if (templateModel instanceof TemplateNumberModel && clazz.isInstance(object = ((TemplateNumberModel)templateModel).getAsNumber())) {
            return object;
        }
        if (templateModel instanceof TemplateDateModel && clazz.isInstance(object = ((TemplateDateModel)templateModel).getAsDate())) {
            return object;
        }
        if (templateModel instanceof TemplateScalarModel && clazz.isAssignableFrom(STRING_CLASS)) {
            return ((TemplateScalarModel)templateModel).getAsString();
        }
        if (templateModel instanceof TemplateBooleanModel && clazz.isAssignableFrom(BOOLEAN_CLASS)) {
            return ((TemplateBooleanModel)templateModel).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (templateModel instanceof TemplateHashModel && clazz.isAssignableFrom(HASHADAPTER_CLASS)) {
            return new HashAdapter((TemplateHashModel)templateModel, this);
        }
        if (templateModel instanceof TemplateSequenceModel && clazz.isAssignableFrom(SEQUENCEADAPTER_CLASS)) {
            return new SequenceAdapter((TemplateSequenceModel)templateModel, this);
        }
        if (templateModel instanceof TemplateCollectionModel && clazz.isAssignableFrom(SETADAPTER_CLASS)) {
            return new SetAdapter((TemplateCollectionModel)templateModel, this);
        }
        if (clazz.isInstance(templateModel)) {
            return templateModel;
        }
        throw BeansWrapper.canNotConvert(templateModel, clazz);
    }

    private static Number convertUnwrappedNumber(Class clazz, Number number) {
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = BeansWrapper.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return number instanceof Integer ? (Integer)number : new Integer(number.intValue());
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = BeansWrapper.class$("java.lang.Long")) : class$java$lang$Long)) {
            return number instanceof Long ? (Long)number : new Long(number.longValue());
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = BeansWrapper.class$("java.lang.Float")) : class$java$lang$Float)) {
            return number instanceof Float ? (Float)number : new Float(number.longValue());
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = BeansWrapper.class$("java.lang.Double")) : class$java$lang$Double)) {
            return number instanceof Double ? (Double)number : new Double(number.longValue());
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = BeansWrapper.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return number instanceof Byte ? (Byte)number : new Byte(number.byteValue());
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = BeansWrapper.class$("java.lang.Short")) : class$java$lang$Short)) {
            return number instanceof Short ? (Short)number : new Short(number.shortValue());
        }
        if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = BeansWrapper.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return number instanceof BigInteger ? number : new BigInteger(number.toString());
        }
        if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BeansWrapper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            if (number instanceof BigDecimal) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            if (number instanceof Long) {
                return new BigDecimal(number.toString());
            }
            return new BigDecimal(number.doubleValue());
        }
        if (clazz.isInstance(number)) {
            return number;
        }
        return null;
    }

    private static TemplateModelException canNotConvert(TemplateModel templateModel, Class clazz) {
        if (templateModel == null) {
            return new TemplateModelException("Could not convert null to " + clazz.getName());
        }
        return new TemplateModelException("Could not convert an instance of " + templateModel.getClass().getName() + " with value [" + templateModel.toString() + "] to " + clazz.getName());
    }

    Object[] unwrapArguments(List list, Class[] classArray) throws TemplateModelException {
        Object[] objectArray = null;
        if (list != null) {
            int n = list.size();
            objectArray = new Object[n];
            Iterator iterator = list.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                objectArray[n2] = this.unwrap((TemplateModel)iterator.next(), classArray[n2]);
                ++n2;
            }
        }
        return objectArray;
    }

    Object[] unwrapArguments(List list) throws TemplateModelException {
        Object[] objectArray = null;
        if (list != null) {
            int n = list.size();
            objectArray = new Object[n];
            Iterator iterator = list.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                objectArray[n2++] = this.unwrap((TemplateModel)iterator.next());
            }
        }
        return objectArray;
    }

    TemplateModel invokeMethod(Object object, Method method, Object[] objectArray) throws InvocationTargetException, IllegalAccessException, TemplateModelException {
        Object object2 = method.invoke(object, objectArray);
        return method.getReturnType() == Void.TYPE ? TemplateModel.NOTHING : this.getOuterIdentity().wrap(object2);
    }

    public TemplateHashModel getStaticModels() {
        return this.staticModels;
    }

    public TemplateHashModel getEnumModels() {
        if (this.enumModels == null) {
            throw new UnsupportedOperationException("Enums not supported on pre-1.5 JRE");
        }
        return this.enumModels;
    }

    public Object newInstance(Class clazz, List list) throws TemplateModelException {
        try {
            Object[] objectArray;
            this.introspectClass(clazz);
            Map map = (Map)this.classCache.get(clazz);
            Object v = map.get(CONSTRUCTORS);
            if (v == null) {
                throw new TemplateModelException("Class " + clazz.getName() + " has no public constructors.");
            }
            Constructor constructor = null;
            if (v instanceof Constructor) {
                constructor = (Constructor)v;
                objectArray = this.unwrapArguments(list, BeansWrapper.getArgTypes(map, constructor));
            } else if (v instanceof MethodMap) {
                MethodMap methodMap = (MethodMap)v;
                objectArray = this.unwrapArguments(list, methodMap.getUnwrapTypes(list));
                constructor = (Constructor)methodMap.getMostSpecific(objectArray);
            } else {
                throw new Error();
            }
            if (objectArray != null) {
                BeansWrapper.coerceBigDecimals(constructor, objectArray);
            }
            return constructor.newInstance(objectArray);
        }
        catch (TemplateModelException templateModelException) {
            throw templateModelException;
        }
        catch (Exception exception) {
            throw new TemplateModelException("Could not create instance of class " + clazz.getName(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void introspectClass(Class clazz) {
        Map map = this.classCache;
        synchronized (map) {
            if (!this.classCache.containsKey(clazz)) {
                this.introspectClassInternal(clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectClassInternal(Class clazz) {
        String string = clazz.getName();
        if (this.cachedClassNames.contains(string)) {
            if (logger.isInfoEnabled()) {
                logger.info("Detected a reloaded class [" + string + "]. Clearing BeansWrapper caches.");
            }
            this.classCache.clear();
            this.cachedClassNames = new HashSet();
            BeansWrapper beansWrapper = this;
            synchronized (beansWrapper) {
                this.modelCache.clearCache();
            }
            this.staticModels.clearCache();
            if (this.enumModels != null) {
                this.enumModels.clearCache();
            }
        }
        this.classCache.put(clazz, this.populateClassMap(clazz));
        this.cachedClassNames.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getClassKeyMap(Class clazz) {
        Map map;
        Map map2 = this.classCache;
        synchronized (map2) {
            map = (Map)this.classCache.get(clazz);
            if (map == null) {
                this.introspectClassInternal(clazz);
                map = (Map)this.classCache.get(clazz);
            }
        }
        return map;
    }

    int keyCount(Class clazz) {
        Map map = this.getClassKeyMap(clazz);
        int n = map.size();
        if (map.containsKey(CONSTRUCTORS)) {
            --n;
        }
        if (map.containsKey(GENERIC_GET_KEY)) {
            --n;
        }
        if (map.containsKey(ARGTYPES)) {
            --n;
        }
        return n;
    }

    Set keySet(Class clazz) {
        HashSet hashSet = new HashSet(this.getClassKeyMap(clazz).keySet());
        hashSet.remove(CONSTRUCTORS);
        hashSet.remove(GENERIC_GET_KEY);
        hashSet.remove(ARGTYPES);
        return hashSet;
    }

    private Map populateClassMap(Class clazz) {
        Object object;
        Map map = this.populateClassMapWithBeanInfo(clazz);
        try {
            object = clazz.getConstructors();
            if (((Constructor<?>[])object).length == 1) {
                Constructor<?> constructor = object[0];
                map.put(CONSTRUCTORS, constructor);
                BeansWrapper.getArgTypes(map).put(constructor, constructor.getParameterTypes());
            } else if (((Constructor<?>[])object).length > 1) {
                MethodMap methodMap = new MethodMap("<init>");
                for (int i = 0; i < ((Constructor<?>[])object).length; ++i) {
                    methodMap.addConstructor((Constructor)object[i]);
                }
                map.put(CONSTRUCTORS, methodMap);
            }
        }
        catch (SecurityException securityException) {
            logger.warn("Canont discover constructors for class " + clazz.getName(), securityException);
        }
        switch (map.size()) {
            case 0: {
                map = Collections12.EMPTY_MAP;
                break;
            }
            case 1: {
                object = map.entrySet().iterator().next();
                map = Collections12.singletonMap(object.getKey(), object.getValue());
                break;
            }
        }
        return map;
    }

    private Map populateClassMapWithBeanInfo(Class clazz) {
        Method method;
        Object object;
        Object object2;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (this.exposeFields) {
            object2 = clazz.getFields();
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object = object2[i];
                if ((((Field)object).getModifiers() & 8) != 0) continue;
                hashMap.put(((Field)object).getName(), object);
            }
        }
        if ((method = (Method)(object2 = BeansWrapper.discoverAccessibleMethods(clazz)).get(MethodSignature.GET_STRING_SIGNATURE)) == null) {
            method = (Method)object2.get(MethodSignature.GET_OBJECT_SIGNATURE);
        }
        if (method != null) {
            hashMap.put(GENERIC_GET_KEY, method);
        }
        if (this.exposureLevel == 3) {
            return hashMap;
        }
        try {
            Object object3;
            Method method2;
            Object object4;
            FeatureDescriptor featureDescriptor;
            int n;
            object = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = object.getPropertyDescriptors();
            MethodDescriptor[] methodDescriptorArray = object.getMethodDescriptors();
            for (n = propertyDescriptorArray.length - 1; n >= 0; --n) {
                featureDescriptor = propertyDescriptorArray[n];
                if (featureDescriptor instanceof IndexedPropertyDescriptor) {
                    object4 = (IndexedPropertyDescriptor)featureDescriptor;
                    method2 = ((IndexedPropertyDescriptor)object4).getIndexedReadMethod();
                    object3 = BeansWrapper.getAccessibleMethod(method2, (Map)object2);
                    if (object3 == null || !this.isSafeMethod((Method)object3)) continue;
                    try {
                        if (method2 != object3) {
                            object4 = new IndexedPropertyDescriptor(((FeatureDescriptor)object4).getName(), ((PropertyDescriptor)object4).getReadMethod(), ((PropertyDescriptor)object4).getWriteMethod(), (Method)object3, ((IndexedPropertyDescriptor)object4).getIndexedWriteMethod());
                        }
                        hashMap.put(((FeatureDescriptor)object4).getName(), object4);
                        BeansWrapper.getArgTypes(hashMap).put(object3, ((Method)object3).getParameterTypes());
                    }
                    catch (IntrospectionException introspectionException) {
                        logger.warn("Couldn't properly perform introspection", introspectionException);
                    }
                    continue;
                }
                object4 = ((PropertyDescriptor)featureDescriptor).getReadMethod();
                method2 = BeansWrapper.getAccessibleMethod((Method)object4, (Map)object2);
                if (method2 == null || !this.isSafeMethod(method2)) continue;
                try {
                    if (object4 != method2) {
                        featureDescriptor = new PropertyDescriptor(featureDescriptor.getName(), method2, ((PropertyDescriptor)featureDescriptor).getWriteMethod());
                        ((PropertyDescriptor)featureDescriptor).setReadMethod(method2);
                    }
                    hashMap.put(featureDescriptor.getName(), featureDescriptor);
                    continue;
                }
                catch (IntrospectionException introspectionException) {
                    logger.warn("Couldn't properly perform introspection", introspectionException);
                }
            }
            if (this.exposureLevel < 2) {
                for (n = methodDescriptorArray.length - 1; n >= 0; --n) {
                    featureDescriptor = methodDescriptorArray[n];
                    object4 = ((MethodDescriptor)featureDescriptor).getMethod();
                    method2 = BeansWrapper.getAccessibleMethod((Method)object4, (Map)object2);
                    if (method2 == null || !this.isSafeMethod(method2)) continue;
                    object3 = featureDescriptor.getName();
                    Object v = hashMap.get(object3);
                    if (v instanceof Method) {
                        MethodMap methodMap = new MethodMap((String)object3);
                        methodMap.addMethod((Method)v);
                        methodMap.addMethod(method2);
                        hashMap.put(object3, methodMap);
                        BeansWrapper.getArgTypes(hashMap).remove(v);
                        continue;
                    }
                    if (v instanceof MethodMap) {
                        ((MethodMap)v).addMethod(method2);
                        continue;
                    }
                    hashMap.put(object3, method2);
                    BeansWrapper.getArgTypes(hashMap).put(method2, method2.getParameterTypes());
                }
            }
            return hashMap;
        }
        catch (IntrospectionException introspectionException) {
            logger.warn("Couldn't properly perform introspection", introspectionException);
            return new HashMap();
        }
    }

    private static Map getArgTypes(Map map) {
        HashMap hashMap = (HashMap)map.get(ARGTYPES);
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(ARGTYPES, hashMap);
        }
        return hashMap;
    }

    static Class[] getArgTypes(Map map, AccessibleObject accessibleObject) {
        return (Class[])((Map)map.get(ARGTYPES)).get(accessibleObject);
    }

    private static Method getAccessibleMethod(Method method, Map map) {
        return method == null ? null : (Method)map.get(new MethodSignature(method));
    }

    boolean isSafeMethod(Method method) {
        return this.exposureLevel < 1 || !UNSAFE_METHODS.contains(method);
    }

    private static Map discoverAccessibleMethods(Class clazz) {
        HashMap hashMap = new HashMap();
        BeansWrapper.discoverAccessibleMethods(clazz, hashMap);
        return hashMap;
    }

    private static void discoverAccessibleMethods(Class clazz, Map map) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                Method[] methodArray = clazz.getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    Method method = methodArray[i];
                    MethodSignature methodSignature = new MethodSignature(method);
                    map.put(methodSignature, method);
                }
                return;
            }
            catch (SecurityException securityException) {
                logger.warn("Could not discover accessible methods of class " + clazz.getName() + ", attemping superclasses/interfaces.", securityException);
            }
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            BeansWrapper.discoverAccessibleMethods(classArray[i], map);
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            BeansWrapper.discoverAccessibleMethods(clazz2, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set createUnsafeMethodsSet() {
        Properties properties = new Properties();
        InputStream inputStream = (class$freemarker$ext$beans$BeansWrapper == null ? (class$freemarker$ext$beans$BeansWrapper = BeansWrapper.class$("freemarker.ext.beans.BeansWrapper")) : class$freemarker$ext$beans$BeansWrapper).getResourceAsStream("unsafeMethods.txt");
        if (inputStream != null) {
            String string = null;
            try {
                try {
                    properties.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
                HashSet<Method> hashSet = new HashSet<Method>(properties.size() * 4 / 3, 0.75f);
                Map map = BeansWrapper.createPrimitiveClassesMap();
                Iterator<Object> iterator = properties.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    try {
                        hashSet.add(BeansWrapper.parseMethodSpec(string, map));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!DEVELOPMENT) continue;
                        throw classNotFoundException;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (!DEVELOPMENT) continue;
                        throw noSuchMethodException;
                    }
                }
                return hashSet;
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not load unsafe method " + string + " " + exception.getClass().getName() + " " + exception.getMessage());
            }
        }
        return Collections.EMPTY_SET;
    }

    private static Method parseMethodSpec(String string, Map map) throws ClassNotFoundException, NoSuchMethodException {
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(46, n);
        Class clazz = ClassUtil.forName(string.substring(0, n2));
        String string2 = string.substring(n2 + 1, n);
        String string3 = string.substring(n + 1, string.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        int n3 = stringTokenizer.countTokens();
        Class[] classArray = new Class[n3];
        for (int i = 0; i < n3; ++i) {
            String string4 = stringTokenizer.nextToken();
            classArray[i] = (Class)map.get(string4);
            if (classArray[i] != null) continue;
            classArray[i] = ClassUtil.forName(string4);
        }
        return clazz.getMethod(string2, classArray);
    }

    private static Map createPrimitiveClassesMap() {
        HashMap<String, Class<Comparable<Boolean>>> hashMap = new HashMap<String, Class<Comparable<Boolean>>>();
        hashMap.put("boolean", Boolean.TYPE);
        hashMap.put("byte", Byte.TYPE);
        hashMap.put("char", Character.TYPE);
        hashMap.put("short", Short.TYPE);
        hashMap.put("int", Integer.TYPE);
        hashMap.put("long", Long.TYPE);
        hashMap.put("float", Float.TYPE);
        hashMap.put("double", Double.TYPE);
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    public static void coerceBigDecimals(AccessibleObject accessibleObject, Object[] objectArray) {
        Class<?>[] classArray = null;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            void var7_7;
            Object object = objectArray[i];
            if (!(object instanceof BigDecimal)) continue;
            BigDecimal bigDecimal = (BigDecimal)object;
            if (classArray == null) {
                if (accessibleObject instanceof Method) {
                    classArray = ((Method)accessibleObject).getParameterTypes();
                } else if (accessibleObject instanceof Constructor) {
                    classArray = ((Constructor)accessibleObject).getParameterTypes();
                } else {
                    throw new Error();
                }
                if (classArray.length != n) {
                    return;
                }
            }
            if ((var7_7 = classArray[i]) == Integer.TYPE || var7_7 == (class$java$lang$Integer == null ? BeansWrapper.class$("java.lang.Integer") : class$java$lang$Integer)) {
                objectArray[i] = new Integer(bigDecimal.intValue());
                continue;
            }
            if (var7_7 == Double.TYPE || var7_7 == (class$java$lang$Double == null ? BeansWrapper.class$("java.lang.Double") : class$java$lang$Double)) {
                objectArray[i] = new Double(bigDecimal.doubleValue());
                continue;
            }
            if (var7_7 == Long.TYPE || var7_7 == (class$java$lang$Long == null ? BeansWrapper.class$("java.lang.Long") : class$java$lang$Long)) {
                objectArray[i] = new Long(bigDecimal.longValue());
                continue;
            }
            if (var7_7 == Float.TYPE || var7_7 == (class$java$lang$Float == null ? BeansWrapper.class$("java.lang.Float") : class$java$lang$Float)) {
                objectArray[i] = new Float(bigDecimal.floatValue());
                continue;
            }
            if (var7_7 == Short.TYPE || var7_7 == (class$java$lang$Short == null ? BeansWrapper.class$("java.lang.Short") : class$java$lang$Short)) {
                objectArray[i] = new Short(bigDecimal.shortValue());
                continue;
            }
            if (var7_7 == Byte.TYPE || var7_7 == (class$java$lang$Byte == null ? BeansWrapper.class$("java.lang.Byte") : class$java$lang$Byte)) {
                objectArray[i] = new Byte(bigDecimal.byteValue());
                continue;
            }
            if (!BIGINTEGER_CLASS.isAssignableFrom((Class<?>)var7_7)) continue;
            objectArray[i] = bigDecimal.toBigInteger();
        }
    }

    private static ClassBasedModelFactory createEnumModels(BeansWrapper beansWrapper) {
        if (ENUMS_MODEL_CTOR != null) {
            try {
                return (ClassBasedModelFactory)ENUMS_MODEL_CTOR.newInstance(beansWrapper);
            }
            catch (Exception exception) {
                throw new UndeclaredThrowableException(exception);
            }
        }
        return null;
    }

    private static Constructor enumsModelCtor() {
        try {
            Class.forName("java.lang.Enum");
            return Class.forName("freemarker.ext.beans.EnumModels").getDeclaredConstructor(class$freemarker$ext$beans$BeansWrapper == null ? (class$freemarker$ext$beans$BeansWrapper = BeansWrapper.class$("freemarker.ext.beans.BeansWrapper")) : class$freemarker$ext$beans$BeansWrapper);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Class access$200() {
        return STRING_CLASS;
    }

    static /* synthetic */ Class access$300() {
        return OBJECT_CLASS;
    }

    static {
        Class<?> clazz;
        BIGINTEGER_CLASS = class$java$math$BigInteger == null ? (class$java$math$BigInteger = BeansWrapper.class$("java.math.BigInteger")) : class$java$math$BigInteger;
        BOOLEAN_CLASS = class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeansWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        CHARACTER_CLASS = class$java$lang$Character == null ? (class$java$lang$Character = BeansWrapper.class$("java.lang.Character")) : class$java$lang$Character;
        COLLECTION_CLASS = class$java$util$Collection == null ? (class$java$util$Collection = BeansWrapper.class$("java.util.Collection")) : class$java$util$Collection;
        DATE_CLASS = class$java$util$Date == null ? (class$java$util$Date = BeansWrapper.class$("java.util.Date")) : class$java$util$Date;
        HASHADAPTER_CLASS = class$freemarker$ext$beans$HashAdapter == null ? (class$freemarker$ext$beans$HashAdapter = BeansWrapper.class$("freemarker.ext.beans.HashAdapter")) : class$freemarker$ext$beans$HashAdapter;
        LIST_CLASS = class$java$util$List == null ? (class$java$util$List = BeansWrapper.class$("java.util.List")) : class$java$util$List;
        MAP_CLASS = class$java$util$Map == null ? (class$java$util$Map = BeansWrapper.class$("java.util.Map")) : class$java$util$Map;
        NUMBER_CLASS = class$java$lang$Number == null ? (class$java$lang$Number = BeansWrapper.class$("java.lang.Number")) : class$java$lang$Number;
        OBJECT_CLASS = class$java$lang$Object == null ? (class$java$lang$Object = BeansWrapper.class$("java.lang.Object")) : class$java$lang$Object;
        SEQUENCEADAPTER_CLASS = class$freemarker$ext$beans$SequenceAdapter == null ? (class$freemarker$ext$beans$SequenceAdapter = BeansWrapper.class$("freemarker.ext.beans.SequenceAdapter")) : class$freemarker$ext$beans$SequenceAdapter;
        SET_CLASS = class$java$util$Set == null ? (class$java$util$Set = BeansWrapper.class$("java.util.Set")) : class$java$util$Set;
        SETADAPTER_CLASS = class$freemarker$ext$beans$SetAdapter == null ? (class$freemarker$ext$beans$SetAdapter = BeansWrapper.class$("freemarker.ext.beans.SetAdapter")) : class$freemarker$ext$beans$SetAdapter;
        STRING_CLASS = class$java$lang$String == null ? (class$java$lang$String = BeansWrapper.class$("java.lang.String")) : class$java$lang$String;
        try {
            clazz = Class.forName("java.lang.Iterable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        ITERABLE_CLASS = clazz;
        DEVELOPMENT = "true".equals(SecurityUtilities.getSystemProperty("freemarker.development"));
        ENUMS_MODEL_CTOR = BeansWrapper.enumsModelCtor();
        logger = Logger.getLogger("freemarker.beans");
        UNSAFE_METHODS = BeansWrapper.createUnsafeMethodsSet();
        GENERIC_GET_KEY = new Object();
        CONSTRUCTORS = new Object();
        ARGTYPES = new Object();
        INSTANCE = new BeansWrapper();
    }

    private static final class MethodSignature {
        private static final MethodSignature GET_STRING_SIGNATURE = new MethodSignature("get", new Class[]{BeansWrapper.access$200()});
        private static final MethodSignature GET_OBJECT_SIGNATURE = new MethodSignature("get", new Class[]{BeansWrapper.access$300()});
        private final String name;
        private final Class[] args;

        private MethodSignature(String string, Class[] classArray) {
            this.name = string;
            this.args = classArray;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object object) {
            if (object instanceof MethodSignature) {
                MethodSignature methodSignature = (MethodSignature)object;
                return methodSignature.name.equals(this.name) && Arrays.equals(this.args, methodSignature.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

