/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.core.CollectionAndSequence;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.InvalidPropertyException;
import freemarker.ext.beans.MethodMap;
import freemarker.ext.beans.OverloadedMethodModel;
import freemarker.ext.beans.SimpleMethodModel;
import freemarker.ext.util.ModelFactory;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.log.Logger;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateScalarModel;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BeanModel
implements TemplateHashModelEx,
AdapterTemplateModel,
WrapperTemplateModel {
    private static final Logger logger = Logger.getLogger("freemarker.beans");
    protected final Object object;
    protected final BeansWrapper wrapper;
    private static final TemplateModel UNKNOWN = new SimpleScalar("UNKNOWN");
    static final ModelFactory FACTORY = new ModelFactory(){

        public TemplateModel create(Object object, ObjectWrapper objectWrapper) {
            return new BeanModel(object, (BeansWrapper)objectWrapper);
        }
    };
    private final HashMap memberMap = new HashMap();

    public BeanModel(Object object, BeansWrapper beansWrapper) {
        this.object = object;
        this.wrapper = beansWrapper;
        if (object == null) {
            return;
        }
        beansWrapper.introspectClass(object.getClass());
    }

    public TemplateModel get(String string) throws TemplateModelException {
        Class<?> clazz = this.object.getClass();
        Map map = this.wrapper.getClassKeyMap(clazz);
        TemplateModel templateModel = null;
        try {
            if (this.wrapper.isMethodsShadowItems()) {
                Object v = map.get(string);
                templateModel = v != null ? this.invokeThroughDescriptor(v, map) : this.invokeGenericGet(map, clazz, string);
            } else {
                TemplateModel templateModel2;
                TemplateModel templateModel3 = this.invokeGenericGet(map, clazz, string);
                if (templateModel3 != (templateModel2 = this.wrapper.wrap(null)) && templateModel3 != UNKNOWN) {
                    return templateModel3;
                }
                Object v = map.get(string);
                if (v != null && (templateModel = this.invokeThroughDescriptor(v, map)) == UNKNOWN && templateModel3 == templateModel2) {
                    templateModel = templateModel2;
                }
            }
            if (templateModel == UNKNOWN) {
                if (this.wrapper.isStrict()) {
                    throw new InvalidPropertyException("No such bean property: " + string);
                }
                if (logger.isDebugEnabled()) {
                    this.logNoSuchKey(string, map);
                }
                templateModel = this.wrapper.wrap(null);
            }
            return templateModel;
        }
        catch (TemplateModelException templateModelException) {
            throw templateModelException;
        }
        catch (Exception exception) {
            throw new TemplateModelException("get(" + string + ") failed on " + "instance of " + this.object.getClass().getName(), exception);
        }
    }

    private void logNoSuchKey(String string, Map map) {
        logger.debug("Key '" + string + "' was not found on instance of " + this.object.getClass().getName() + ". Introspection information for " + "the class is: " + map);
    }

    protected boolean hasPlainGetMethod() {
        return this.wrapper.getClassKeyMap(this.object.getClass()).get(BeansWrapper.GENERIC_GET_KEY) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateModel invokeThroughDescriptor(Object object, Map map) throws IllegalAccessException, InvocationTargetException, TemplateModelException {
        Object object2;
        TemplateModel templateModel = null;
        Object object3 = this.memberMap;
        synchronized (object3) {
            templateModel = (TemplateModel)this.memberMap.get(object);
        }
        if (templateModel != null) {
            return templateModel;
        }
        object3 = UNKNOWN;
        if (object instanceof IndexedPropertyDescriptor) {
            object2 = ((IndexedPropertyDescriptor)object).getIndexedReadMethod();
            templateModel = new SimpleMethodModel(this.object, (Method)object2, BeansWrapper.getArgTypes(map, (AccessibleObject)object2), this.wrapper);
            object3 = templateModel;
        } else if (object instanceof PropertyDescriptor) {
            object2 = (PropertyDescriptor)object;
            object3 = this.wrapper.invokeMethod(this.object, ((PropertyDescriptor)object2).getReadMethod(), null);
        } else if (object instanceof Field) {
            object3 = this.wrapper.wrap(((Field)object).get(this.object));
        } else if (object instanceof Method) {
            object2 = (Method)object;
            templateModel = new SimpleMethodModel(this.object, (Method)object2, BeansWrapper.getArgTypes(map, (AccessibleObject)object2), this.wrapper);
            object3 = templateModel;
        } else if (object instanceof MethodMap) {
            templateModel = new OverloadedMethodModel(this.object, (MethodMap)object, this.wrapper);
            object3 = templateModel;
        }
        if (templateModel != null) {
            object2 = this.memberMap;
            synchronized (object2) {
                this.memberMap.put(object, templateModel);
            }
        }
        return object3;
    }

    protected TemplateModel invokeGenericGet(Map map, Class clazz, String string) throws IllegalAccessException, InvocationTargetException, TemplateModelException {
        Method method = (Method)map.get(BeansWrapper.GENERIC_GET_KEY);
        if (method == null) {
            return UNKNOWN;
        }
        return this.wrapper.invokeMethod(this.object, method, new Object[]{string});
    }

    protected TemplateModel wrap(Object object) throws TemplateModelException {
        return this.wrapper.getOuterIdentity().wrap(object);
    }

    protected Object unwrap(TemplateModel templateModel) throws TemplateModelException {
        return this.wrapper.unwrap(templateModel);
    }

    public boolean isEmpty() {
        if (this.object instanceof String) {
            return ((String)this.object).length() == 0;
        }
        if (this.object instanceof Collection) {
            return ((Collection)this.object).isEmpty();
        }
        if (this.object instanceof Map) {
            return ((Map)this.object).isEmpty();
        }
        return this.object == null || Boolean.FALSE.equals(this.object);
    }

    public Object getAdaptedObject(Class clazz) {
        return this.object;
    }

    public Object getWrappedObject() {
        return this.object;
    }

    public int size() {
        return this.wrapper.keyCount(this.object.getClass());
    }

    public TemplateCollectionModel keys() {
        return new CollectionAndSequence(new SimpleSequence(this.keySet(), this.wrapper));
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        ArrayList<TemplateModel> arrayList = new ArrayList<TemplateModel>(this.size());
        TemplateModelIterator templateModelIterator = this.keys().iterator();
        while (templateModelIterator.hasNext()) {
            String string = ((TemplateScalarModel)templateModelIterator.next()).getAsString();
            arrayList.add(this.get(string));
        }
        return new CollectionAndSequence(new SimpleSequence(arrayList, this.wrapper));
    }

    public String toString() {
        return this.object.toString();
    }

    protected Set keySet() {
        return this.wrapper.keySet(this.object.getClass());
    }
}

