/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.util.ModelFactory;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import java.lang.reflect.Array;

public class ArrayModel
extends BeanModel
implements TemplateCollectionModel,
TemplateSequenceModel {
    static final ModelFactory FACTORY = new ModelFactory(){

        public TemplateModel create(Object object, ObjectWrapper objectWrapper) {
            return new ArrayModel(object, (BeansWrapper)objectWrapper);
        }
    };
    private int length;

    public ArrayModel(Object object, BeansWrapper beansWrapper) {
        super(object, beansWrapper);
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Object is not an array, it is " + object.getClass().getName());
        }
        this.length = Array.getLength(object);
    }

    public TemplateModelIterator iterator() {
        return new Iterator();
    }

    public TemplateModel get(int n) throws TemplateModelException {
        try {
            return this.wrap(Array.get(this.object, n));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new TemplateModelException("Index out of bounds: " + n);
        }
    }

    public int size() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    private class Iterator
    implements TemplateSequenceModel,
    TemplateModelIterator {
        private int position = 0;

        private Iterator() {
        }

        public boolean hasNext() {
            return this.position < ArrayModel.this.length;
        }

        public TemplateModel get(int n) throws TemplateModelException {
            return ArrayModel.this.get(n);
        }

        public TemplateModel next() throws TemplateModelException {
            return this.position < ArrayModel.this.length ? this.get(this.position++) : null;
        }

        public int size() {
            return ArrayModel.this.size();
        }
    }
}

