/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.ant;

import freemarker.ext.ant.UnlinkedJythonOperations;
import freemarker.template.utility.ClassUtil;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class JythonAntTask
extends Task {
    private File scriptFile;
    private String script = "";
    private UnlinkedJythonOperations jythonOps;

    public void setFile(File file) throws BuildException {
        this.ensureJythonOpsExists();
        this.scriptFile = file;
    }

    public void addText(String string) {
        this.script = this.script + string;
    }

    public void execute(Map map) throws BuildException {
        if (this.scriptFile != null) {
            this.ensureJythonOpsExists();
            this.jythonOps.execute(this.scriptFile, map);
        }
        if (this.script.trim().length() > 0) {
            this.ensureJythonOpsExists();
            String string = ProjectHelper.replaceProperties((Project)this.project, (String)this.script, (Hashtable)this.project.getProperties());
            this.jythonOps.execute(string, map);
        }
    }

    private void ensureJythonOpsExists() {
        if (this.jythonOps == null) {
            Class clazz;
            try {
                clazz = ClassUtil.forName("freemarker.ext.ant.UnlinkedJythonOperationsImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("A ClassNotFoundException has been thrown when trying to get the freemarker.ext.ant.UnlinkedJythonOperationsImpl class. The error message was: " + classNotFoundException.getMessage());
            }
            try {
                this.jythonOps = (UnlinkedJythonOperations)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("An exception has been thrown when trying to create a freemarker.ext.ant.JythonAntTask object. The exception was: " + exception);
            }
        }
    }
}

