/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.ant;

import freemarker.core.Environment;
import freemarker.ext.ant.JythonAntTask;
import freemarker.ext.dom.NodeModel;
import freemarker.ext.xml.NodeListModel;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNodeModel;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.SecurityUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class FreemarkerXmlTask
extends MatchingTask {
    private JythonAntTask prepareModel;
    private JythonAntTask prepareEnvironment;
    private final DocumentBuilderFactory builderFactory;
    private DocumentBuilder builder;
    private Configuration cfg = new Configuration();
    private File destDir;
    private File baseDir;
    private File templateDir;
    private String templateName;
    private Template parsedTemplate;
    private long templateFileLastModified = 0L;
    private String projectAttribute = null;
    private File projectFile = null;
    private TemplateModel projectTemplate;
    private TemplateNodeModel projectNode;
    private TemplateModel propertiesTemplate;
    private TemplateModel userPropertiesTemplate;
    private long projectFileLastModified = 0L;
    private boolean incremental = true;
    private String extension = ".html";
    private String encoding;
    private String templateEncoding = this.encoding = SecurityUtilities.getSystemProperty("file.encoding");
    private boolean validation = false;
    private String models = "";
    private final Map modelsMap = new HashMap();

    public FreemarkerXmlTask() {
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builderFactory.setNamespaceAware(true);
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public void setTemplate(String string) {
        this.templateName = string;
    }

    public void setTemplateDir(File file) throws BuildException {
        this.templateDir = file;
        try {
            this.cfg.setDirectoryForTemplateLoading(file);
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    public void setProjectfile(String string) {
        this.projectAttribute = string;
    }

    public void setIncremental(String string) {
        this.incremental = !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no") && !string.equalsIgnoreCase("off");
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setTemplateEncoding(String string) {
        this.templateEncoding = string;
    }

    public void setValidation(boolean bl) {
        this.validation = bl;
    }

    public void setModels(String string) {
        this.models = string;
    }

    public void execute() throws BuildException {
        if (this.baseDir == null) {
            this.baseDir = this.getProject().getBaseDir();
        }
        if (this.destDir == null) {
            String string = "destdir attribute must be set!";
            throw new BuildException(string, this.getLocation());
        }
        File file = null;
        if (this.templateDir == null) {
            if (this.templateName != null) {
                file = new File(this.templateName);
                if (!file.isAbsolute()) {
                    file = new File(this.getProject().getBaseDir(), this.templateName);
                }
                this.templateDir = file.getParentFile();
                this.templateName = file.getName();
            } else {
                this.templateDir = this.baseDir;
            }
            this.setTemplateDir(this.templateDir);
        } else if (this.templateName != null) {
            if (new File(this.templateName).isAbsolute()) {
                throw new BuildException("Do not specify an absolute location for the template as well as a templateDir");
            }
            file = new File(this.templateDir, this.templateName);
        }
        if (file != null) {
            this.templateFileLastModified = file.lastModified();
        }
        try {
            if (this.templateName != null) {
                this.parsedTemplate = this.cfg.getTemplate(this.templateName, this.templateEncoding);
            }
        }
        catch (IOException iOException) {
            throw new BuildException(iOException.toString());
        }
        this.log("Transforming into: " + this.destDir.getAbsolutePath(), 2);
        if (this.projectAttribute != null && this.projectAttribute.length() > 0) {
            this.projectFile = new File(this.baseDir, this.projectAttribute);
            if (this.projectFile.isFile()) {
                this.projectFileLastModified = this.projectFile.lastModified();
            } else {
                this.log("Project file is defined, but could not be located: " + this.projectFile.getAbsolutePath(), 2);
                this.projectFile = null;
            }
        }
        this.generateModels();
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.baseDir);
        this.propertiesTemplate = FreemarkerXmlTask.wrapMap(this.project.getProperties());
        this.userPropertiesTemplate = FreemarkerXmlTask.wrapMap(this.project.getUserProperties());
        this.builderFactory.setValidating(this.validation);
        try {
            this.builder = this.builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BuildException("Could not create document builder", (Throwable)parserConfigurationException, this.getLocation());
        }
        String[] stringArray = directoryScanner.getIncludedFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            this.process(this.baseDir, stringArray[i], this.destDir);
        }
    }

    public void addConfiguredJython(JythonAntTask jythonAntTask) {
        this.prepareEnvironment = jythonAntTask;
    }

    public void addConfiguredPrepareModel(JythonAntTask jythonAntTask) {
        this.prepareModel = jythonAntTask;
    }

    public void addConfiguredPrepareEnvironment(JythonAntTask jythonAntTask) {
        this.prepareEnvironment = jythonAntTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(File file, String string, File file2) throws BuildException {
        block14: {
            File file3 = null;
            File file4 = null;
            try {
                Document document;
                file4 = new File(file, string);
                file3 = new File(file2, string.substring(0, string.lastIndexOf(46)) + this.extension);
                if (this.incremental && file4.lastModified() <= file3.lastModified() && this.templateFileLastModified <= file3.lastModified() && this.projectFileLastModified <= file3.lastModified()) break block14;
                this.ensureDirectoryFor(file3);
                this.log("Input:  " + string, 2);
                if (this.projectTemplate == null && this.projectFile != null) {
                    document = this.builder.parse(this.projectFile);
                    this.projectTemplate = new NodeListModel(this.builder.parse(this.projectFile));
                    this.projectNode = NodeModel.wrap(document);
                }
                document = this.builder.parse(file4);
                NodeListModel nodeListModel = new NodeListModel(document);
                NodeModel nodeModel = NodeModel.wrap(document);
                HashMap<String, NodeListModel> hashMap = new HashMap<String, NodeListModel>();
                hashMap.put("document", nodeListModel);
                this.insertDefaults(hashMap);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file3), this.encoding));
                try {
                    Object object;
                    if (this.parsedTemplate == null) {
                        throw new BuildException("No template file specified in build script or in XML file");
                    }
                    if (this.prepareModel != null) {
                        object = new HashMap<String, HashMap<String, NodeListModel>>();
                        object.put("model", hashMap);
                        object.put("doc", document);
                        if (this.projectNode != null) {
                            object.put("project", ((NodeModel)this.projectNode).getNode());
                        }
                        this.prepareModel.execute((Map)object);
                    }
                    object = this.parsedTemplate.createProcessingEnvironment(hashMap, bufferedWriter);
                    ((Environment)object).setCurrentVisitorNode(nodeModel);
                    if (this.prepareEnvironment != null) {
                        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                        hashMap2.put("env", object);
                        hashMap2.put("doc", document);
                        if (this.projectNode != null) {
                            hashMap2.put("project", ((NodeModel)this.projectNode).getNode());
                        }
                        this.prepareEnvironment.execute(hashMap2);
                    }
                    ((Environment)object).process();
                    ((Writer)bufferedWriter).flush();
                }
                finally {
                    ((Writer)bufferedWriter).close();
                }
                this.log("Output: " + file3, 2);
            }
            catch (SAXParseException sAXParseException) {
                Exception exception = sAXParseException;
                if (sAXParseException.getException() != null) {
                    exception = sAXParseException.getException();
                }
                this.log("XML parsing error in " + file4.getAbsolutePath(), 0);
                this.log("Line number " + sAXParseException.getLineNumber());
                this.log("Column number " + sAXParseException.getColumnNumber());
                throw new BuildException((Throwable)exception, this.getLocation());
            }
            catch (Throwable throwable) {
                if (file3 != null) {
                    file3.delete();
                }
                throwable.printStackTrace();
                throw new BuildException(throwable, this.getLocation());
            }
        }
    }

    private void generateModels() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.models, ",; ");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            String string2 = null;
            String string3 = null;
            int n = string.indexOf(61);
            if (n == -1) {
                string3 = string;
                int n2 = string3.lastIndexOf(46);
                string2 = n2 == -1 ? string3 : string3.substring(n2 + 1);
            } else {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            try {
                this.modelsMap.put(string2, ClassUtil.forName(string3).newInstance());
            }
            catch (Exception exception) {
                throw new BuildException((Throwable)exception);
            }
        }
    }

    private void ensureDirectoryFor(File file) throws BuildException {
        File file2 = new File(file.getParent());
        if (!file2.exists() && !file2.mkdirs()) {
            throw new BuildException("Unable to create directory: " + file2.getAbsolutePath(), this.getLocation());
        }
    }

    private static TemplateModel wrapMap(Map map) {
        SimpleHash simpleHash = new SimpleHash();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            simpleHash.put(k.toString(), new SimpleScalar(v.toString()));
        }
        return simpleHash;
    }

    protected void insertDefaults(Map map) {
        map.put("properties", this.propertiesTemplate);
        map.put("userProperties", this.userPropertiesTemplate);
        if (this.projectTemplate != null) {
            map.put("project", this.projectTemplate);
            map.put("project_node", this.projectNode);
        }
        if (this.modelsMap.size() > 0) {
            Iterator iterator = this.modelsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                map.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

