/*
 * Decompiled with CFR 0.152.
 */
package freemarker.debug.impl;

import freemarker.core.DebugBreak;
import freemarker.core.Environment;
import freemarker.core.TemplateElement;
import freemarker.debug.Breakpoint;
import freemarker.debug.DebuggerListener;
import freemarker.debug.EnvironmentSuspendedEvent;
import freemarker.debug.impl.DebuggerServer;
import freemarker.debug.impl.DebuggerService;
import freemarker.debug.impl.RmiDebuggedEnvironmentImpl;
import freemarker.debug.impl.RmiDebuggerImpl;
import freemarker.template.Template;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class RmiDebuggerService
extends DebuggerService {
    private final Map templateDebugInfos = new HashMap();
    private final HashSet suspendedEnvironments = new HashSet();
    private final Map listeners = new HashMap();
    private final ReferenceQueue refQueue = new ReferenceQueue();

    RmiDebuggerService() {
        try {
            new DebuggerServer((Serializable)((Object)RemoteObject.toStub(new RmiDebuggerImpl(this)))).start();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new UndeclaredThrowableException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getBreakpointsSpi(String string) {
        Map map = this.templateDebugInfos;
        synchronized (map) {
            TemplateDebugInfo templateDebugInfo = this.findTemplateDebugInfo(string);
            return templateDebugInfo == null ? Collections.EMPTY_LIST : templateDebugInfo.breakpoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getBreakpointsSpi() {
        ArrayList arrayList = new ArrayList();
        Map map = this.templateDebugInfos;
        synchronized (map) {
            Iterator iterator = this.templateDebugInfos.values().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(((TemplateDebugInfo)iterator.next()).breakpoints);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean suspendEnvironmentSpi(Environment environment, int n) throws RemoteException {
        Object object;
        RmiDebuggedEnvironmentImpl rmiDebuggedEnvironmentImpl = (RmiDebuggedEnvironmentImpl)RmiDebuggedEnvironmentImpl.getCachedWrapperFor(environment);
        Serializable serializable = this.suspendedEnvironments;
        synchronized (serializable) {
            this.suspendedEnvironments.add(rmiDebuggedEnvironmentImpl);
        }
        try {
            serializable = new EnvironmentSuspendedEvent(this, n, rmiDebuggedEnvironmentImpl);
            Object object2 = this.listeners;
            synchronized (object2) {
                object = this.listeners.values().iterator();
                while (object.hasNext()) {
                    DebuggerListener debuggerListener = (DebuggerListener)object.next();
                    debuggerListener.environmentSuspended((EnvironmentSuspendedEvent)serializable);
                }
            }
            object2 = rmiDebuggedEnvironmentImpl;
            synchronized (object2) {
                try {
                    rmiDebuggedEnvironmentImpl.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            boolean bl = rmiDebuggedEnvironmentImpl.isStopped();
            return bl;
        }
        finally {
            object = this.suspendedEnvironments;
            synchronized (object) {
                this.suspendedEnvironments.remove(rmiDebuggedEnvironmentImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTemplateSpi(Template template) {
        String string = template.getName();
        Map map = this.templateDebugInfos;
        synchronized (map) {
            TemplateDebugInfo templateDebugInfo = this.createTemplateDebugInfo(string);
            templateDebugInfo.templates.add(new TemplateReference(string, template, this.refQueue));
            Iterator iterator = templateDebugInfo.breakpoints.iterator();
            while (iterator.hasNext()) {
                Breakpoint breakpoint = (Breakpoint)iterator.next();
                RmiDebuggerService.insertDebugBreak(template, breakpoint);
            }
        }
    }

    Collection getSuspendedEnvironments() {
        return (Collection)this.suspendedEnvironments.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object addDebuggerListener(DebuggerListener debuggerListener) {
        Long l;
        Map map = this.listeners;
        synchronized (map) {
            l = new Long(System.currentTimeMillis());
            this.listeners.put(l, debuggerListener);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDebuggerListener(Object object) {
        Map map = this.listeners;
        synchronized (map) {
            this.listeners.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBreakpoint(Breakpoint breakpoint) {
        String string = breakpoint.getTemplateName();
        Map map = this.templateDebugInfos;
        synchronized (map) {
            TemplateDebugInfo templateDebugInfo = this.createTemplateDebugInfo(string);
            List list = templateDebugInfo.breakpoints;
            int n = Collections.binarySearch(list, breakpoint);
            if (n < 0) {
                list.add(-n - 1, breakpoint);
                Iterator iterator = templateDebugInfo.templates.iterator();
                while (iterator.hasNext()) {
                    TemplateReference templateReference = (TemplateReference)iterator.next();
                    Template template = templateReference.getTemplate();
                    if (template == null) {
                        iterator.remove();
                        continue;
                    }
                    RmiDebuggerService.insertDebugBreak(template, breakpoint);
                }
            }
        }
    }

    private static void insertDebugBreak(Template template, Breakpoint breakpoint) {
        TemplateElement templateElement = RmiDebuggerService.findTemplateElement(template.getRootTreeNode(), breakpoint.getLine());
        if (templateElement == null) {
            return;
        }
        TemplateElement templateElement2 = (TemplateElement)templateElement.getParent();
        DebugBreak debugBreak = new DebugBreak(templateElement);
        templateElement2.setChildAt(templateElement2.getIndex(templateElement), debugBreak);
    }

    private static TemplateElement findTemplateElement(TemplateElement templateElement, int n) {
        if (templateElement.getBeginLine() > n || templateElement.getEndLine() < n) {
            return null;
        }
        Enumeration enumeration = templateElement.children();
        while (enumeration.hasMoreElements()) {
            TemplateElement templateElement2 = (TemplateElement)enumeration.nextElement();
            TemplateElement templateElement3 = RmiDebuggerService.findTemplateElement(templateElement2, n);
            if (templateElement3 == null) continue;
            return templateElement3;
        }
        return templateElement;
    }

    private TemplateDebugInfo findTemplateDebugInfo(String string) {
        this.processRefQueue();
        return (TemplateDebugInfo)this.templateDebugInfos.get(string);
    }

    private TemplateDebugInfo createTemplateDebugInfo(String string) {
        TemplateDebugInfo templateDebugInfo = this.findTemplateDebugInfo(string);
        if (templateDebugInfo == null) {
            templateDebugInfo = new TemplateDebugInfo();
            this.templateDebugInfos.put(string, templateDebugInfo);
        }
        return templateDebugInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBreakpoint(Breakpoint breakpoint) {
        String string = breakpoint.getTemplateName();
        Map map = this.templateDebugInfos;
        synchronized (map) {
            TemplateDebugInfo templateDebugInfo = this.findTemplateDebugInfo(string);
            if (templateDebugInfo != null) {
                List list = templateDebugInfo.breakpoints;
                int n = Collections.binarySearch(list, breakpoint);
                if (n >= 0) {
                    list.remove(n);
                    Iterator iterator = templateDebugInfo.templates.iterator();
                    while (iterator.hasNext()) {
                        TemplateReference templateReference = (TemplateReference)iterator.next();
                        Template template = templateReference.getTemplate();
                        if (template == null) {
                            iterator.remove();
                            continue;
                        }
                        this.removeDebugBreak(template, breakpoint);
                    }
                }
                if (templateDebugInfo.isEmpty()) {
                    this.templateDebugInfos.remove(string);
                }
            }
        }
    }

    private void removeDebugBreak(Template template, Breakpoint breakpoint) {
        TemplateElement templateElement = RmiDebuggerService.findTemplateElement(template.getRootTreeNode(), breakpoint.getLine());
        if (templateElement == null) {
            return;
        }
        TemplateElement templateElement2 = null;
        while (templateElement != null) {
            if (templateElement instanceof DebugBreak) {
                templateElement2 = (DebugBreak)templateElement;
                break;
            }
            templateElement = (TemplateElement)templateElement.getParent();
        }
        if (templateElement2 == null) {
            return;
        }
        TemplateElement templateElement3 = (TemplateElement)templateElement2.getParent();
        templateElement3.setChildAt(templateElement3.getIndex(templateElement2), (TemplateElement)templateElement2.getChildAt(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBreakpoints(String string) {
        Map map = this.templateDebugInfos;
        synchronized (map) {
            TemplateDebugInfo templateDebugInfo = this.findTemplateDebugInfo(string);
            if (templateDebugInfo != null) {
                this.removeBreakpoints(templateDebugInfo);
                if (templateDebugInfo.isEmpty()) {
                    this.templateDebugInfos.remove(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBreakpoints() {
        Map map = this.templateDebugInfos;
        synchronized (map) {
            Iterator iterator = this.templateDebugInfos.values().iterator();
            while (iterator.hasNext()) {
                TemplateDebugInfo templateDebugInfo = (TemplateDebugInfo)iterator.next();
                this.removeBreakpoints(templateDebugInfo);
                if (!templateDebugInfo.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    private void removeBreakpoints(TemplateDebugInfo templateDebugInfo) {
        templateDebugInfo.breakpoints.clear();
        Iterator iterator = templateDebugInfo.templates.iterator();
        while (iterator.hasNext()) {
            TemplateReference templateReference = (TemplateReference)iterator.next();
            Template template = templateReference.getTemplate();
            if (template == null) {
                iterator.remove();
                continue;
            }
            this.removeDebugBreaks(template.getRootTreeNode());
        }
    }

    private void removeDebugBreaks(TemplateElement templateElement) {
        int n = templateElement.getChildCount();
        for (int i = 0; i < n; ++i) {
            TemplateElement templateElement2 = (TemplateElement)templateElement.getChildAt(i);
            while (templateElement2 instanceof DebugBreak) {
                TemplateElement templateElement3 = (TemplateElement)templateElement2.getChildAt(0);
                templateElement.setChildAt(i, templateElement3);
                templateElement2 = templateElement3;
            }
            this.removeDebugBreaks(templateElement2);
        }
    }

    private void processRefQueue() {
        TemplateReference templateReference;
        while ((templateReference = (TemplateReference)this.refQueue.poll()) != null) {
            TemplateDebugInfo templateDebugInfo = this.findTemplateDebugInfo(templateReference.templateName);
            if (templateDebugInfo == null) continue;
            templateDebugInfo.templates.remove(templateReference);
            if (!templateDebugInfo.isEmpty()) continue;
            this.templateDebugInfos.remove(templateReference.templateName);
        }
    }

    private static final class TemplateDebugInfo {
        final List templates = new ArrayList();
        final List breakpoints = new ArrayList();

        private TemplateDebugInfo() {
        }

        boolean isEmpty() {
            return this.templates.isEmpty() && this.breakpoints.isEmpty();
        }
    }

    private static final class TemplateReference
    extends WeakReference {
        final String templateName;

        TemplateReference(String string, Template template, ReferenceQueue referenceQueue) {
            super(template, referenceQueue);
            this.templateName = string;
        }

        Template getTemplate() {
            return (Template)this.get();
        }
    }
}

