/*
 * Decompiled with CFR 0.152.
 */
package freemarker.debug.impl;

import freemarker.cache.CacheStorage;
import freemarker.cache.SoftCacheStorage;
import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.debug.DebuggedEnvironment;
import freemarker.debug.impl.RmiDebugModelImpl;
import freemarker.ext.util.IdentityHashMap;
import freemarker.template.Configuration;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class RmiDebuggedEnvironmentImpl
extends RmiDebugModelImpl
implements DebuggedEnvironment {
    private static final long serialVersionUID = 1L;
    private static final CacheStorage storage = new SoftCacheStorage(new IdentityHashMap());
    private static final Object idLock = new Object();
    private static long nextId = 1L;
    private boolean stopped = false;
    private final long id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RmiDebuggedEnvironmentImpl(Environment environment) throws RemoteException {
        super(new DebugEnvironmentModel(environment), 2048);
        Object object = idLock;
        synchronized (object) {
            this.id = nextId++;
        }
    }

    static synchronized Object getCachedWrapperFor(Object object) throws RemoteException {
        Object object2 = storage.get(object);
        if (object2 == null) {
            if (object instanceof TemplateModel) {
                int n = object instanceof DebugConfigurationModel ? 8192 : (object instanceof DebugTemplateModel ? 4096 : 0);
                object2 = new RmiDebugModelImpl((TemplateModel)object, n);
            } else if (object instanceof Environment) {
                object2 = new RmiDebuggedEnvironmentImpl((Environment)object);
            } else if (object instanceof Template) {
                object2 = new DebugTemplateModel((Template)object);
            } else if (object instanceof Configuration) {
                object2 = new DebugConfigurationModel((Configuration)object);
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        RmiDebuggedEnvironmentImpl rmiDebuggedEnvironmentImpl = this;
        synchronized (rmiDebuggedEnvironmentImpl) {
            this.notify();
        }
    }

    public void stop() {
        this.stopped = true;
        this.resume();
    }

    public long getId() {
        return this.id;
    }

    boolean isStopped() {
        return this.stopped;
    }

    private static class DebugConfigurableModel
    extends DebugMapModel {
        static final List KEYS = Arrays.asList("arithmetic_engine", "boolean_format", "classic_compatible", "locale", "number_format", "object_wrapper", "template_exception_handler");
        final Configurable configurable;

        DebugConfigurableModel(Configurable configurable) {
            this.configurable = configurable;
        }

        Collection keySet() {
            return KEYS;
        }

        public TemplateModel get(String string) throws TemplateModelException {
            String string2 = this.configurable.getSetting(string);
            return string2 == null ? null : new SimpleScalar(string2);
        }
    }

    private static class DebugConfigurationModel
    extends DebugConfigurableModel {
        private static final List KEYS = DebugConfigurationModel.composeList(DebugConfigurableModel.KEYS, Collections.singleton("sharedVariables"));
        private TemplateModel sharedVariables = new DebugMapModel(){

            Collection keySet() {
                return ((Configuration)DebugConfigurationModel.this.configurable).getSharedVariableNames();
            }

            public TemplateModel get(String string) {
                return ((Configuration)DebugConfigurationModel.this.configurable).getSharedVariable(string);
            }
        };

        DebugConfigurationModel(Configuration configuration) {
            super(configuration);
        }

        Collection keySet() {
            return KEYS;
        }

        public TemplateModel get(String string) throws TemplateModelException {
            if ("sharedVariables".equals(string)) {
                return this.sharedVariables;
            }
            return super.get(string);
        }
    }

    private static class DebugEnvironmentModel
    extends DebugConfigurableModel {
        private static final List KEYS = DebugEnvironmentModel.composeList(DebugConfigurableModel.KEYS, Arrays.asList("currentNamespace", "dataModel", "globalNamespace", "knownVariables", "mainNamespace", "template"));
        private TemplateModel knownVariables = new DebugMapModel(){

            Collection keySet() {
                try {
                    return ((Environment)DebugEnvironmentModel.this.configurable).getKnownVariableNames();
                }
                catch (TemplateModelException templateModelException) {
                    throw new UndeclaredThrowableException(templateModelException);
                }
            }

            public TemplateModel get(String string) throws TemplateModelException {
                return ((Environment)DebugEnvironmentModel.this.configurable).getVariable(string);
            }
        };

        DebugEnvironmentModel(Environment environment) {
            super(environment);
        }

        Collection keySet() {
            return KEYS;
        }

        public TemplateModel get(String string) throws TemplateModelException {
            if ("currentNamespace".equals(string)) {
                return ((Environment)this.configurable).getCurrentNamespace();
            }
            if ("dataModel".equals(string)) {
                return ((Environment)this.configurable).getDataModel();
            }
            if ("globalNamespace".equals(string)) {
                return ((Environment)this.configurable).getGlobalNamespace();
            }
            if ("knownVariables".equals(string)) {
                return this.knownVariables;
            }
            if ("mainNamespace".equals(string)) {
                return ((Environment)this.configurable).getMainNamespace();
            }
            if ("template".equals(string)) {
                try {
                    return (TemplateModel)RmiDebuggedEnvironmentImpl.getCachedWrapperFor(((Environment)this.configurable).getTemplate());
                }
                catch (RemoteException remoteException) {
                    throw new TemplateModelException(remoteException);
                }
            }
            return super.get(string);
        }
    }

    private static abstract class DebugMapModel
    implements TemplateHashModelEx {
        private DebugMapModel() {
        }

        public int size() {
            return this.keySet().size();
        }

        public TemplateCollectionModel keys() {
            return new SimpleCollection(this.keySet());
        }

        public TemplateCollectionModel values() throws TemplateModelException {
            Collection collection = this.keySet();
            ArrayList<TemplateModel> arrayList = new ArrayList<TemplateModel>(collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(this.get((String)iterator.next()));
            }
            return new SimpleCollection(arrayList);
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        abstract Collection keySet();

        static List composeList(Collection collection, Collection collection2) {
            ArrayList arrayList = new ArrayList(collection);
            arrayList.addAll(collection2);
            Collections.sort(arrayList);
            return arrayList;
        }
    }

    private static class DebugTemplateModel
    extends DebugConfigurableModel {
        private static final List KEYS = DebugTemplateModel.composeList(DebugConfigurableModel.KEYS, Arrays.asList("configuration", "name"));
        private final SimpleScalar name;

        DebugTemplateModel(Template template) {
            super(template);
            this.name = new SimpleScalar(template.getName());
        }

        Collection keySet() {
            return KEYS;
        }

        public TemplateModel get(String string) throws TemplateModelException {
            if ("configuration".equals(string)) {
                try {
                    return (TemplateModel)RmiDebuggedEnvironmentImpl.getCachedWrapperFor(((Template)this.configurable).getConfiguration());
                }
                catch (RemoteException remoteException) {
                    throw new TemplateModelException(remoteException);
                }
            }
            if ("name".equals(string)) {
                return this.name;
            }
            return super.get(string);
        }
    }
}

