/*
 * Decompiled with CFR 0.152.
 */
package freemarker.debug.impl;

import freemarker.debug.DebugModel;
import freemarker.debug.impl.RmiDebuggedEnvironmentImpl;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.TemplateTransformModel;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Date;

class RmiDebugModelImpl
extends UnicastRemoteObject
implements DebugModel {
    private static final long serialVersionUID = 1L;
    private final TemplateModel model;
    private final int type;

    RmiDebugModelImpl(TemplateModel templateModel, int n) throws RemoteException {
        this.model = templateModel;
        this.type = RmiDebugModelImpl.calculateType(templateModel) + n;
    }

    private static DebugModel getDebugModel(TemplateModel templateModel) throws RemoteException {
        return (DebugModel)RmiDebuggedEnvironmentImpl.getCachedWrapperFor(templateModel);
    }

    public String getAsString() throws TemplateModelException {
        return ((TemplateScalarModel)this.model).getAsString();
    }

    public Number getAsNumber() throws TemplateModelException {
        return ((TemplateNumberModel)this.model).getAsNumber();
    }

    public Date getAsDate() throws TemplateModelException {
        return ((TemplateDateModel)this.model).getAsDate();
    }

    public int getDateType() {
        return ((TemplateDateModel)this.model).getDateType();
    }

    public boolean getAsBoolean() throws TemplateModelException {
        return ((TemplateBooleanModel)this.model).getAsBoolean();
    }

    public int size() throws TemplateModelException {
        if (this.model instanceof TemplateSequenceModel) {
            return ((TemplateSequenceModel)this.model).size();
        }
        return ((TemplateHashModelEx)this.model).size();
    }

    public DebugModel get(int n) throws TemplateModelException, RemoteException {
        return RmiDebugModelImpl.getDebugModel(((TemplateSequenceModel)this.model).get(n));
    }

    public DebugModel[] get(int n, int n2) throws TemplateModelException, RemoteException {
        DebugModel[] debugModelArray = new DebugModel[n2 - n];
        TemplateSequenceModel templateSequenceModel = (TemplateSequenceModel)this.model;
        for (int i = n; i < n2; ++i) {
            debugModelArray[i - n] = RmiDebugModelImpl.getDebugModel(templateSequenceModel.get(i));
        }
        return debugModelArray;
    }

    public DebugModel[] getCollection() throws TemplateModelException, RemoteException {
        ArrayList<DebugModel> arrayList = new ArrayList<DebugModel>();
        TemplateModelIterator templateModelIterator = ((TemplateCollectionModel)this.model).iterator();
        while (templateModelIterator.hasNext()) {
            arrayList.add(RmiDebugModelImpl.getDebugModel(templateModelIterator.next()));
        }
        return arrayList.toArray(new DebugModel[arrayList.size()]);
    }

    public DebugModel get(String string) throws TemplateModelException, RemoteException {
        return RmiDebugModelImpl.getDebugModel(((TemplateHashModel)this.model).get(string));
    }

    public DebugModel[] get(String[] stringArray) throws TemplateModelException, RemoteException {
        DebugModel[] debugModelArray = new DebugModel[stringArray.length];
        TemplateHashModel templateHashModel = (TemplateHashModel)this.model;
        for (int i = 0; i < stringArray.length; ++i) {
            debugModelArray[i] = RmiDebugModelImpl.getDebugModel(templateHashModel.get(stringArray[i]));
        }
        return debugModelArray;
    }

    public String[] keys() throws TemplateModelException {
        TemplateHashModelEx templateHashModelEx = (TemplateHashModelEx)this.model;
        ArrayList<String> arrayList = new ArrayList<String>();
        TemplateModelIterator templateModelIterator = templateHashModelEx.keys().iterator();
        while (templateModelIterator.hasNext()) {
            arrayList.add(((TemplateScalarModel)templateModelIterator.next()).getAsString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public int getModelTypes() {
        return this.type;
    }

    private static int calculateType(TemplateModel templateModel) {
        int n = 0;
        if (templateModel instanceof TemplateScalarModel) {
            ++n;
        }
        if (templateModel instanceof TemplateNumberModel) {
            n += 2;
        }
        if (templateModel instanceof TemplateDateModel) {
            n += 4;
        }
        if (templateModel instanceof TemplateBooleanModel) {
            n += 8;
        }
        if (templateModel instanceof TemplateSequenceModel) {
            n += 16;
        }
        if (templateModel instanceof TemplateCollectionModel) {
            n += 32;
        }
        if (templateModel instanceof TemplateHashModelEx) {
            n += 128;
        } else if (templateModel instanceof TemplateHashModel) {
            n += 64;
        }
        if (templateModel instanceof TemplateMethodModelEx) {
            n += 512;
        } else if (templateModel instanceof TemplateMethodModel) {
            n += 256;
        }
        if (templateModel instanceof TemplateTransformModel) {
            n += 1024;
        }
        return n;
    }
}

