/*
 * Decompiled with CFR 0.152.
 */
package freemarker.debug.impl;

import freemarker.log.Logger;
import freemarker.template.utility.SecurityUtilities;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

class DebuggerServer {
    private static final Logger logger = Logger.getLogger("freemarker.debug.server");
    private static final Random R = new SecureRandom();
    private final byte[] password;
    private final int port = SecurityUtilities.getSystemProperty("freemarker.debug.port", 7011);
    private final Serializable debuggerStub;

    public DebuggerServer(Serializable serializable) {
        try {
            this.password = SecurityUtilities.getSystemProperty("freemarker.debug.password", "").getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UndeclaredThrowableException(unsupportedEncodingException);
        }
        this.debuggerStub = serializable;
    }

    public void start() {
        new Thread(new Runnable(){

            public void run() {
                DebuggerServer.this.startInternal();
            }
        }, "FreeMarker Debugger Server Acceptor").start();
    }

    private void startInternal() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.port);
            while (true) {
                Socket socket = serverSocket.accept();
                new Thread(new DebuggerAuthProtocol(socket)).start();
            }
        }
        catch (IOException iOException) {
            logger.error("Debugger server shut down.", iOException);
            return;
        }
    }

    private class DebuggerAuthProtocol
    implements Runnable {
        private final Socket s;

        DebuggerAuthProtocol(Socket socket) {
            this.s = socket;
        }

        public void run() {
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.s.getOutputStream());
                ObjectInputStream objectInputStream = new ObjectInputStream(this.s.getInputStream());
                byte[] byArray = new byte[512];
                R.nextBytes(byArray);
                objectOutputStream.writeInt(220);
                objectOutputStream.writeObject(byArray);
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update(DebuggerServer.this.password);
                messageDigest.update(byArray);
                byte[] byArray2 = (byte[])objectInputStream.readObject();
                if (Arrays.equals(byArray2, messageDigest.digest())) {
                    objectOutputStream.writeObject(DebuggerServer.this.debuggerStub);
                } else {
                    objectOutputStream.writeObject(null);
                }
            }
            catch (Exception exception) {
                logger.warn("Connection to " + this.s.getInetAddress().getHostAddress() + " abruply broke", exception);
            }
        }
    }
}

