/*
 * Decompiled with CFR 0.152.
 */
package freemarker.debug;

import freemarker.debug.Breakpoint;
import freemarker.debug.Debugger;
import freemarker.debug.DebuggerListener;
import freemarker.debug.impl.RmiDebuggerListenerImpl;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;

public class DebuggerClient {
    private DebuggerClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Debugger getDebugger(InetAddress inetAddress, int n, String string) throws IOException {
        LocalDebuggerProxy localDebuggerProxy;
        Socket socket = new Socket(inetAddress, n);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            int n2 = objectInputStream.readInt();
            if (n2 > 220) {
                throw new IOException("Incompatible protocol version " + n2 + ". At most 220 was expected.");
            }
            byte[] byArray = (byte[])objectInputStream.readObject();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(string.getBytes("UTF-8"));
            messageDigest.update(byArray);
            objectOutputStream.writeObject(messageDigest.digest());
            localDebuggerProxy = new LocalDebuggerProxy((Debugger)objectInputStream.readObject());
        }
        catch (Throwable throwable) {
            try {
                socket.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new UndeclaredThrowableException(exception);
            }
        }
        socket.close();
        return localDebuggerProxy;
    }

    private static class LocalDebuggerProxy
    implements Debugger {
        private final Debugger remoteDebugger;

        LocalDebuggerProxy(Debugger debugger) {
            this.remoteDebugger = debugger;
        }

        public void addBreakpoint(Breakpoint breakpoint) throws RemoteException {
            this.remoteDebugger.addBreakpoint(breakpoint);
        }

        public Object addDebuggerListener(DebuggerListener debuggerListener) throws RemoteException {
            if (debuggerListener instanceof RemoteObject) {
                return this.remoteDebugger.addDebuggerListener(debuggerListener);
            }
            RmiDebuggerListenerImpl rmiDebuggerListenerImpl = new RmiDebuggerListenerImpl(debuggerListener);
            return this.remoteDebugger.addDebuggerListener(rmiDebuggerListenerImpl);
        }

        public List getBreakpoints() throws RemoteException {
            return this.remoteDebugger.getBreakpoints();
        }

        public List getBreakpoints(String string) throws RemoteException {
            return this.remoteDebugger.getBreakpoints(string);
        }

        public Collection getSuspendedEnvironments() throws RemoteException {
            return this.remoteDebugger.getSuspendedEnvironments();
        }

        public void removeBreakpoint(Breakpoint breakpoint) throws RemoteException {
            this.remoteDebugger.removeBreakpoint(breakpoint);
        }

        public void removeBreakpoints(String string) throws RemoteException {
            this.remoteDebugger.removeBreakpoints(string);
        }

        public void removeBreakpoints() throws RemoteException {
            this.remoteDebugger.removeBreakpoints();
        }

        public void removeDebuggerListener(Object object) throws RemoteException {
            this.remoteDebugger.removeDebuggerListener(object);
        }
    }
}

