/*
 * Decompiled with CFR 0.152.
 */
package freemarker.debug;

import java.io.Serializable;

public class Breakpoint
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private final String templateName;
    private final int line;

    public Breakpoint(String string, int n) {
        this.templateName = string;
        this.line = n;
    }

    public int getLine() {
        return this.line;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public int hashCode() {
        return this.templateName.hashCode() + 31 * this.line;
    }

    public boolean equals(Object object) {
        if (object instanceof Breakpoint) {
            Breakpoint breakpoint = (Breakpoint)object;
            return breakpoint.templateName.equals(this.templateName) && breakpoint.line == this.line;
        }
        return false;
    }

    public int compareTo(Object object) {
        Breakpoint breakpoint = (Breakpoint)object;
        int n = this.templateName.compareTo(breakpoint.templateName);
        return n == 0 ? this.line - breakpoint.line : n;
    }

    public String getLocationString() {
        return this.templateName + ":" + this.line;
    }
}

