/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ListLiteral;
import freemarker.core.StringLiteral;
import freemarker.core.TemplateElement;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;

final class VisitNode
extends TemplateElement {
    Expression targetNode;
    Expression namespaces;

    VisitNode(Expression expression, Expression expression2) {
        this.targetNode = expression;
        this.namespaces = expression2;
    }

    void accept(Environment environment) throws IOException, TemplateException {
        TemplateModel templateModel;
        TemplateModel templateModel2 = this.targetNode.getAsTemplateModel(environment);
        VisitNode.assertNonNull(templateModel2, this.targetNode, environment);
        if (!(templateModel2 instanceof TemplateNodeModel)) {
            throw new TemplateException("Expecting an XML node here", environment);
        }
        TemplateModel templateModel3 = templateModel = this.namespaces == null ? null : this.namespaces.getAsTemplateModel(environment);
        if (this.namespaces instanceof StringLiteral) {
            templateModel = environment.importLib(((TemplateScalarModel)templateModel).getAsString(), null);
        } else if (this.namespaces instanceof ListLiteral) {
            templateModel = ((ListLiteral)this.namespaces).evaluateStringsToNamespaces(environment);
        }
        if (templateModel != null) {
            if (templateModel instanceof Environment.Namespace) {
                SimpleSequence simpleSequence = new SimpleSequence(1);
                simpleSequence.add(templateModel);
                templateModel = simpleSequence;
            } else if (!(templateModel instanceof TemplateSequenceModel)) {
                throw new TemplateException("Expecting a sequence of namespaces after 'using'", environment);
            }
        }
        environment.visit((TemplateNodeModel)templateModel2, (TemplateSequenceModel)templateModel);
    }

    public String getCanonicalForm() {
        if (this.namespaces == null) {
            return "<#visit " + this.targetNode.getCanonicalForm() + "/>";
        }
        return "<#visit " + this.targetNode.getCanonicalForm() + " using " + this.namespaces.getCanonicalForm() + "/>";
    }

    public String getDescription() {
        return "visit instruction";
    }
}

